<?php

namespace App\Repository;

use App\Entity\Pokemon;
use App\Model\PokemonSearchAvancee;
use App\Model\SearchData;
use Doctrine\Bundle\DoctrineBundle\Repository\ServiceEntityRepository;
use Doctrine\Persistence\ManagerRegistry;

/**
 * @method Pokemon|null find($id, $lockMode = null, $lockVersion = null)
 * @method Pokemon|null findOneBy(array $criteria, array $orderBy = null)
 * @method Pokemon[]    findAll()
 * @method Pokemon[]    findBy(array $criteria, array $orderBy = null, $limit = null, $offset = null)
 */
class PokemonRepository extends ServiceEntityRepository
{
    public function __construct(ManagerRegistry $registry)
    {
        parent::__construct($registry, Pokemon::class);
    }

    // /**
    //  * @return Pokemon[] Returns an array of Pokemon objects
    //  */
    /*
    public function findByExampleField($value)
    {
        return $this->createQueryBuilder('p')
            ->andWhere('p.exampleField = :val')
            ->setParameter('val', $value)
            ->orderBy('p.id', 'ASC')
            ->setMaxResults(10)
            ->getQuery()
            ->getResult()
        ;
    }
    */

    /*
    public function findOneBySomeField($value): ?Pokemon
    {
        return $this->createQueryBuilder('p')
            ->andWhere('p.exampleField = :val')
            ->setParameter('val', $value)
            ->getQuery()
            ->getOneOrNullResult()
        ;
    }
    */
    public function findSearch(SearchData $search)
    {
        return $this->createQueryBuilder('p')
            ->setParameter('val' , '%'.$search->q.'%')
            ->where('p.nom LIKE :val')
            ->orderBY('p.nom','ASC')
            ->getQuery()
            ->getResult()
        ;
    }

    public function findSearchFilter(PokemonSearchAvancee $search)
    {
        if (null!==$search->getMinVie() && null!==$search->getMaxVie() && null!==$search->getMinAttaque() && null!==$search->getMaxAttaque() && null!==$search->getMinDefense() && null!==$search->getMaxDefense())
        {

            return $this->createQueryBuilder('p')
                ->andwhere('p.vie >= :minvie')
                ->andwhere('p.vie <= :maxvie')
                ->andwhere('p.attaque >= :minattaque')
                ->andwhere('p.attaque <= :maxattaque')
                ->andwhere('p.defense >= :mindefense')
                ->andwhere('p.defense <= :maxdefense')
                ->setParameter('minvie', $search->getMinVie())
                ->setParameter('maxvie', $search->getMaxVie())
                ->setParameter('minattaque', $search->getMinAttaque())
                ->setParameter('maxattaque', $search->getMaxAttaque())
                ->setParameter('mindefense', $search->getMinDefense())
                ->setParameter('maxdefense', $search->getMaxDefense())
                ->orderBY('p.nom','ASC')
                ->getQuery()
                ->getResult()
                ;
        }

        /*if ($search->getMaxAttaque()){
            return $this->createQueryBuilder('p')
                ->andwhere('p.attaque <= :maxattaque')
                ->setParameter('maxattaque', $search->getMaxAttaque())
                ->getQuery()
                ->getResult()
                ;
        }*/

        
    }
}

