<?php

namespace App\Form;

use App\Model\PokemonSearchAvancee;
use Symfony\Component\Form\Extension\Core\Type\SubmitType;
use Symfony\Component\Form\AbstractType;
use Symfony\Component\Form\FormBuilderInterface;
use Symfony\Component\OptionsResolver\OptionsResolver;
use Symfony\Component\Form\Extension\Core\Type\CheckboxType;
use Symfony\Component\Form\Extension\Core\Type\IntegerType;
use Symfony\Bridge\Doctrine\Form\Type\EntityType;


class SearchPokemonAvanceeType extends AbstractType
{
    public function buildForm(FormBuilderInterface $builder, array $options)
    {
        $builder

            ->add('minVie', IntegerType::class,[
                'required' => true,
                'label'    => 'Min vie',
                'attr'     => [
                    'placeholder' => 'Vie minimale'
                ]
            ])
            ->add('maxVie', IntegerType::class,[
                'required' => true,
                'label'    => 'Max vie',
                'attr'     => [
                    'placeholder' => 'Vie maximale'
                ]
            ])

            ->add('minAttaque', IntegerType::class,[
                'required' => true,
                'label'    => 'Min attaque',
                'attr'     => [
                    'placeholder' => 'Attaque minimale'
                ]
            ])
            ->add('maxAttaque', IntegerType::class,[
                'required' => true,
                'label'    => 'Max attaque',
                'attr'     => [
                    'placeholder' => 'Attaque maximale'
                ]
            ])

            ->add('minDefense', IntegerType::class,[
                'required' => true,
                'label'    => 'Min defense',
                'attr'     => [
                    'placeholder' => 'Defense minimale'
                ]
            ])
            ->add('maxDefense', IntegerType::class,[
                'required' => true,
                'label'    => 'Max defense',
                'attr'     => [
                    'placeholder' => 'Defense maximale'
                ]
            ])

        ;
    }

    public function configureOptions(OptionsResolver $resolver)
    {
        $resolver->setDefaults([
            'data_class' => PokemonSearchAvancee::class,
            'method'     => 'get',
            'csrf_protection' => false,
        ]);
    }
}