<?php

namespace App\Entity;

use App\Repository\TypeRepository;
use Doctrine\Common\Collections\ArrayCollection;
use Doctrine\Common\Collections\Collection;
use Doctrine\ORM\Mapping as ORM;

/**
 * @ORM\Entity(repositoryClass=TypeRepository::class)
 */
class Type
{
    /**
     * @ORM\Id
     * @ORM\GeneratedValue
     * @ORM\Column(type="integer")
     */
    private $id;

    /**
     * @ORM\Column(type="string", length=255)
     */
    private $name;

    /**
     * @ORM\OneToMany(targetEntity=Pokemon::class, mappedBy="type1", orphanRemoval=true)
     */
    private $pokemon_type1;

    /**
     * @ORM\OneToMany(targetEntity=Pokemon::class, mappedBy="type2")
     */
    private $type2;

    /**
     * @ORM\OneToMany(targetEntity=Pokemon::class, mappedBy="type2")
     */
    private $pokemon_type2;


    public function __construct()
    {
        $this->pokemon_type1 = new ArrayCollection();
        $this->type2 = new ArrayCollection();
        $this->pokemon_type2 = new ArrayCollection();
    }

    public function __toString()
    {
        return "Type :" .$this->name;
    }

    public function getId(): ?int
    {
        return $this->id;
    }

    public function getName(): ?string
    {
        return $this->name;
    }

    public function setName(string $name): self
    {
        $this->name = $name;

        return $this;
    }

    /**
     * @return Collection|Pokemon[]
     */
    public function getPokemonType1(): Collection
    {
        return $this->pokemon_type1;
    }

    public function addPokemonType1(Pokemon $pokemonType1): self
    {
        if (!$this->pokemon_type1->contains($pokemonType1)) {
            $this->pokemon_type1[] = $pokemonType1;
            $pokemonType1->setType1($this);
        }

        return $this;
    }

    public function removePokemonType1(Pokemon $pokemonType1): self
    {
        if ($this->pokemon_type1->removeElement($pokemonType1)) {
            // set the owning side to null (unless already changed)
            if ($pokemonType1->getType1() === $this) {
                $pokemonType1->setType1(null);
            }
        }

        return $this;
    }

    /**
     * @return Collection|Pokemon[]
     */
    public function getType2(): Collection
    {
        return $this->type2;
    }

    public function addType2(Pokemon $type2): self
    {
        if (!$this->type2->contains($type2)) {
            $this->type2[] = $type2;
            $type2->setType2($this);
        }

        return $this;
    }

    public function removeType2(Pokemon $type2): self
    {
        if ($this->type2->removeElement($type2)) {
            // set the owning side to null (unless already changed)
            if ($type2->getType2() === $this) {
                $type2->setType2(null);
            }
        }

        return $this;
    }

    /**
     * @return Collection|Pokemon[]
     */
    public function getPokemonType2(): Collection
    {
        return $this->pokemon_type2;
    }

    public function addPokemonType2(Pokemon $pokemonType2): self
    {
        if (!$this->pokemon_type2->contains($pokemonType2)) {
            $this->pokemon_type2[] = $pokemonType2;
            $pokemonType2->setType2($this);
        }

        return $this;
    }

    public function removePokemonType2(Pokemon $pokemonType2): self
    {
        if ($this->pokemon_type2->removeElement($pokemonType2)) {
            // set the owning side to null (unless already changed)
            if ($pokemonType2->getType2() === $this) {
                $pokemonType2->setType2(null);
            }
        }

        return $this;
    }
}
