/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.tools.item;

import com.google.common.collect.ImmutableList;
import java.util.List;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.EnumCreatureAttribute;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.BlockPos;
import net.minecraft.world.World;
import slimeknights.tconstruct.TConstruct;
import slimeknights.tconstruct.library.materials.HandleMaterialStats;
import slimeknights.tconstruct.library.materials.HeadMaterialStats;
import slimeknights.tconstruct.library.materials.Material;
import slimeknights.tconstruct.library.tinkering.Category;
import slimeknights.tconstruct.library.tinkering.PartMaterialType;
import slimeknights.tconstruct.library.tools.ToolNBT;
import slimeknights.tconstruct.library.utils.ToolHelper;
import slimeknights.tconstruct.tools.TinkerTools;
import slimeknights.tconstruct.tools.item.Pickaxe;

public class Hammer
extends Pickaxe {
    public Hammer() {
        super(PartMaterialType.handle(TinkerTools.toughToolRod), PartMaterialType.head(TinkerTools.hammerHead), PartMaterialType.head(TinkerTools.largePlate), PartMaterialType.head(TinkerTools.largePlate));
        this.addCategory(Category.WEAPON);
    }

    @Override
    public void func_150895_a(Item itemIn, CreativeTabs tab, List<ItemStack> subItems) {
        this.addDefaultSubItems(subItems);
        this.addInfiTool(subItems, "InfiMiner");
    }

    @Override
    public float miningSpeedModifier() {
        return 0.4f;
    }

    @Override
    public float damagePotential() {
        return 1.0f;
    }

    @Override
    public boolean dealDamage(ItemStack stack, EntityPlayer player, EntityLivingBase entity, float damage) {
        if (entity.func_70668_bt() == EnumCreatureAttribute.UNDEAD) {
            damage += (float)(3 + TConstruct.random.nextInt(4));
        }
        return super.dealDamage(stack, player, entity, damage);
    }

    @Override
    public ImmutableList<BlockPos> getAOEBlocks(ItemStack stack, World world, EntityPlayer player, BlockPos origin) {
        if (!ToolHelper.isToolEffective2(stack, world.func_180495_p(origin))) {
            return ImmutableList.of();
        }
        return ToolHelper.calcAOEBlocks(stack, world, player, origin, 3, 3, 1);
    }

    @Override
    public int[] getRepairParts() {
        return new int[]{1, 2, 3};
    }

    @Override
    public float getRepairModifierForPart(int index) {
        return index == 1 ? 1.0f : 0.5f;
    }

    @Override
    public NBTTagCompound buildTag(List<Material> materials) {
        HandleMaterialStats handle = (HandleMaterialStats)materials.get(0).getStatsOrUnknown("handle");
        HeadMaterialStats head = (HeadMaterialStats)materials.get(1).getStatsOrUnknown("head");
        HeadMaterialStats plate1 = (HeadMaterialStats)materials.get(2).getStatsOrUnknown("head");
        HeadMaterialStats plate2 = (HeadMaterialStats)materials.get(3).getStatsOrUnknown("head");
        ToolNBT data = new ToolNBT();
        data.head(head, head, plate1, plate2);
        data.handle(handle);
        data.harvestLevel = head.harvestLevel;
        data.durability = (int)((float)data.durability * 2.5f);
        data.modifiers = 3;
        return data.get();
    }
}

