/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.shared.tileentity;

import net.minecraft.block.Block;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.client.resources.model.IBakedModel;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.Packet;
import net.minecraft.network.play.server.S35PacketUpdateTileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.world.WorldServer;
import net.minecraftforge.client.model.IFlexibleBakedModel;
import net.minecraftforge.common.property.IExtendedBlockState;
import net.minecraftforge.common.property.IUnlistedProperty;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import slimeknights.mantle.network.AbstractPacket;
import slimeknights.mantle.tileentity.TileInventory;
import slimeknights.tconstruct.common.TinkerNetwork;
import slimeknights.tconstruct.common.config.Config;
import slimeknights.tconstruct.library.client.model.ModelHelper;
import slimeknights.tconstruct.shared.block.BlockTable;
import slimeknights.tconstruct.shared.block.PropertyTableItem;
import slimeknights.tconstruct.tools.network.InventorySlotSyncPacket;

public class TileTable
extends TileInventory {
    public static final String FEET_TAG = "textureBlock";
    public static final String FACE_TAG = "facing";
    protected int displaySlot = 0;

    public TileTable() {
        super("", 0, 0);
    }

    public TileTable(String name, int inventorySize) {
        super(name, inventorySize);
    }

    public TileTable(String name, int inventorySize, int maxStackSize) {
        super(name, inventorySize, maxStackSize);
    }

    public IExtendedBlockState writeExtendedBlockState(IExtendedBlockState state) {
        ItemStack stack;
        String texture = this.getTileData().func_74779_i("texture");
        if ((texture == null || texture.isEmpty()) && (stack = ItemStack.func_77949_a((NBTTagCompound)this.getTileData().func_74775_l(FEET_TAG))) != null) {
            Block block = Block.func_149634_a((Item)stack.func_77973_b());
            texture = ModelHelper.getTextureFromBlock(block, stack.func_77952_i()).func_94215_i();
            this.getTileData().func_74778_a("texture", texture);
        }
        if (texture != null && !texture.isEmpty()) {
            state = state.withProperty((IUnlistedProperty)BlockTable.TEXTURE, (Object)texture);
        }
        EnumFacing facing = this.getFacing();
        state = state.withProperty((IUnlistedProperty)BlockTable.FACING, (Object)facing);
        state = this.setInventoryDisplay(state);
        return state;
    }

    protected IExtendedBlockState setInventoryDisplay(IExtendedBlockState state) {
        ItemStack stack;
        PropertyTableItem.TableItem item;
        PropertyTableItem.TableItems toDisplay = new PropertyTableItem.TableItems();
        if (this.func_70301_a(this.displaySlot) != null && (item = TileTable.getTableItem(stack = this.func_70301_a(this.displaySlot))) != null) {
            toDisplay.items.add(item);
        }
        return state.withProperty((IUnlistedProperty)BlockTable.INVENTORY, (Object)toDisplay);
    }

    @SideOnly(value=Side.CLIENT)
    public static PropertyTableItem.TableItem getTableItem(ItemStack stack) {
        if (stack == null) {
            return null;
        }
        IBakedModel model = Minecraft.func_71410_x().func_175599_af().func_175037_a().func_178089_a(stack);
        if (model == null) {
            return null;
        }
        Object stackModel = model instanceof IFlexibleBakedModel ? (IFlexibleBakedModel)model : new IFlexibleBakedModel.Wrapper(model, DefaultVertexFormats.field_176599_b);
        PropertyTableItem.TableItem item = new PropertyTableItem.TableItem((IFlexibleBakedModel)stackModel, 0.0f, -0.46875f, 0.0f, 0.8f, -1.5707964f);
        if (stack.func_77973_b() instanceof ItemBlock) {
            item.y = -0.3125f;
            item.s = 0.375f;
            item.r = 0.0f;
        }
        return item;
    }

    public Packet func_145844_m() {
        NBTTagCompound tag = (NBTTagCompound)this.getTileData().func_74737_b();
        this.func_145841_b(tag);
        return new S35PacketUpdateTileEntity(this.func_174877_v(), this.func_145832_p(), tag);
    }

    public void onDataPacket(NetworkManager net, S35PacketUpdateTileEntity pkt) {
        NBTBase facing;
        NBTTagCompound tag = pkt.func_148857_g();
        NBTBase feet = tag.func_74781_a(FEET_TAG);
        if (feet != null) {
            this.getTileData().func_74782_a(FEET_TAG, feet);
        }
        if ((facing = tag.func_74781_a(FACE_TAG)) != null) {
            this.getTileData().func_74782_a(FACE_TAG, facing);
        }
        this.func_145839_a(tag);
    }

    public void setFacing(EnumFacing face) {
        this.getTileData().func_74768_a(FACE_TAG, face.func_176745_a());
    }

    public EnumFacing getFacing() {
        return EnumFacing.func_82600_a((int)this.getTileData().func_74762_e(FACE_TAG));
    }

    public void updateTextureBlock(NBTTagCompound tag) {
        this.getTileData().func_74782_a(FEET_TAG, (NBTBase)tag);
    }

    public NBTTagCompound getTextureBlock() {
        return this.getTileData().func_74775_l(FEET_TAG);
    }

    public void func_70299_a(int slot, ItemStack itemstack) {
        if (this.field_145850_b != null && this.field_145850_b instanceof WorldServer && !this.field_145850_b.field_72995_K && !ItemStack.func_77989_b((ItemStack)itemstack, (ItemStack)this.func_70301_a(slot))) {
            TinkerNetwork.sendToClients((WorldServer)this.field_145850_b, this.field_174879_c, (AbstractPacket)new InventorySlotSyncPacket(itemstack, slot, this.field_174879_c));
        }
        super.func_70299_a(slot, itemstack);
        if (this.func_145831_w() != null && this.func_145831_w().field_72995_K && Config.renderTableItems) {
            Minecraft.func_71410_x().field_71438_f.func_174960_a(this.field_174879_c);
        }
    }
}

