/*
 * Decompiled with CFR 0.152.
 */
package ovh.corail.tombstone.tileentity;

import java.text.SimpleDateFormat;
import java.util.Date;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyBool;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.effect.EntityLightningBolt;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.S35PacketUpdateTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.BlockPos;
import net.minecraft.util.ITickable;
import net.minecraft.world.World;
import ovh.corail.tombstone.block.BlockGrave;
import ovh.corail.tombstone.core.Helper;
import ovh.corail.tombstone.core.Main;
import ovh.corail.tombstone.handler.ConfigurationHandler;

public class TileEntityWritableGrave
extends TileEntity
implements ITickable {
    protected String ownerName = "";
    protected long deathDate;
    private int countTicks = 0;

    public <T extends Entity> void setOwner(T owner, long deathDate) {
        this.setOwner(owner.func_145748_c_().func_150260_c(), deathDate);
    }

    public void setOwner(String ownerName, long deathDate) {
        this.ownerName = ownerName;
        this.deathDate = deathDate;
    }

    public String getOwnerName() {
        return this.ownerName;
    }

    public String getOwnerDeathDate(int part, boolean formated) {
        String part2;
        Date date = new Date(this.deathDate);
        String dateString = new SimpleDateFormat("dd/MM/yyyy").format(date);
        String timeString = new SimpleDateFormat("HH:mm:ss").format(date);
        String part1 = formated ? Helper.getTranslation("message.death_date.died_on") + " " + dateString : dateString;
        String string = part2 = formated ? Helper.getTranslation("message.death_date.at") + " " + timeString : timeString;
        return part == 0 ? part1 + " " + part2 : (part == 1 ? part1 : part2);
    }

    public void func_145841_b(NBTTagCompound compound) {
        super.func_145841_b(compound);
        compound.func_74778_a("ownerName", this.ownerName);
        compound.func_74772_a("deathDate", this.deathDate);
        compound.func_74768_a("countTicks", this.countTicks);
    }

    public void func_145839_a(NBTTagCompound compound) {
        super.func_145839_a(compound);
        this.ownerName = compound.func_74779_i("ownerName");
        this.deathDate = compound.func_74763_f("deathDate");
        this.countTicks = compound.func_74762_e("countTicks");
    }

    public boolean shouldRefresh(World world, BlockPos pos, IBlockState oldState, IBlockState newState) {
        return oldState.func_177230_c() != newState.func_177230_c();
    }

    public S35PacketUpdateTileEntity getDescriptionPacket() {
        NBTTagCompound nbttagcompound = new NBTTagCompound();
        this.func_145841_b(nbttagcompound);
        return new S35PacketUpdateTileEntity(this.field_174879_c, 1, nbttagcompound);
    }

    public void onDataPacket(NetworkManager net, S35PacketUpdateTileEntity pkt) {
        this.func_145839_a(pkt.func_148857_g());
    }

    public void func_73660_a() {
        IBlockState state = this.field_145850_b.func_180495_p(this.field_174879_c);
        if (!(state.func_177230_c() instanceof BlockGrave)) {
            return;
        }
        BlockGrave grave = (BlockGrave)state.func_177230_c();
        boolean hasSoul = (Boolean)state.func_177229_b((IProperty)BlockGrave.HAS_SOUL);
        if (this.field_145850_b.field_72995_K) {
            if (hasSoul && this.countTicks % 100 == 0) {
                Main.proxy.produceGraveSoul(this.field_145850_b, this.field_174879_c);
            }
            if (!ConfigurationHandler.showFog) {
                return;
            }
            if (!grave.isDecorative() || (double)this.field_145850_b.func_72826_c(0.0f) >= 0.245 && (double)this.field_145850_b.func_72826_c(0.0f) <= 0.755) {
                Main.proxy.produceGraveSmoke(this.field_145850_b, this.field_174879_c);
            }
        } else if (this.countTicks % 20 == 0 && !hasSoul && grave.canHoldSoul() && this.field_145850_b.func_72911_I() && Helper.getRandom(1, ConfigurationHandler.chanceSoul) <= 1) {
            this.field_145850_b.func_72942_c((Entity)new EntityLightningBolt(this.field_145850_b, (double)this.field_174879_c.func_177958_n(), (double)this.field_174879_c.func_177956_o(), (double)this.field_174879_c.func_177952_p()));
            this.field_145850_b.func_180501_a(this.field_174879_c, state.func_177226_a((IProperty)PropertyBool.func_177716_a((String)"has_soul"), (Comparable)Boolean.valueOf(true)), 3);
        }
        ++this.countTicks;
    }
}

