/*
 * Decompiled with CFR 0.152.
 */
package ovh.corail.tombstone.tileentity;

import baubles.api.BaublesApi;
import java.util.Date;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemArmor;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.EnumFacing;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.ItemStackHandler;
import ovh.corail.tombstone.core.Helper;
import ovh.corail.tombstone.handler.ConfigurationHandler;
import ovh.corail.tombstone.handler.SoundHandler;
import ovh.corail.tombstone.tileentity.TileEntityWritableGrave;

public class TileEntityTombstone
extends TileEntityWritableGrave {
    protected ItemStackHandler inventory = new ItemStackHandler(64);
    protected boolean needAccess = false;

    public boolean hasCapability(Capability<?> capability, EnumFacing facing) {
        return capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY || super.hasCapability(capability, facing);
    }

    public <T> T getCapability(Capability<T> capability, EnumFacing facing) {
        return (T)(capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY ? this.inventory : super.getCapability(capability, facing));
    }

    public void giveInventory(EntityPlayer player) {
        if (player == null || this.field_145850_b.field_72995_K) {
            return;
        }
        boolean isBaublesLoaded = Loader.isModLoaded((String)"Baubles") || Loader.isModLoaded((String)"baubles");
        IInventory handler = isBaublesLoaded ? BaublesApi.getBaubles((EntityPlayer)player) : null;
        for (int i = 0; i < this.inventory.getSlots(); ++i) {
            int slotId;
            ItemStack stack = this.inventory.getStackInSlot(i);
            if (stack == null) continue;
            boolean set = false;
            if (isBaublesLoaded) {
                for (int slot = 0; slot < handler.func_70302_i_(); ++slot) {
                    if (handler.func_70301_a(slot) != null || !handler.func_94041_b(slot, stack)) continue;
                    handler.func_70299_a(slot, stack);
                    this.inventory.setStackInSlot(i, null);
                    set = true;
                    break;
                }
            }
            if (!set && stack.func_77973_b() instanceof ItemArmor && player.field_71071_by.field_70460_b[slotId = ((ItemArmor)stack.func_77973_b()).field_77881_a] == null) {
                player.field_71071_by.field_70460_b[slotId] = stack;
                this.inventory.setStackInSlot(i, null);
                set = true;
            }
            if (set) continue;
            Helper.addToInventoryWithLeftover(stack, (IInventory)player.field_71071_by, false);
            this.inventory.setStackInSlot(i, null);
        }
        player.field_71069_bz.func_75142_b();
        this.field_145850_b.func_175698_g(this.field_174879_c);
        SoundHandler.playSoundAllAround("block.wooden_door.close", this.field_145850_b, player.func_180425_c(), 10.0);
        Helper.sendMessage("message.open_grave.success", player, true);
        this.field_145850_b.func_175713_t(this.field_174879_c);
    }

    public <T extends Entity> void setOwner(T owner, long deathDate, boolean needAccess) {
        super.setOwner(owner, deathDate);
        this.needAccess = needAccess;
    }

    public boolean getNeedAccess() {
        if (!this.needAccess) {
            return false;
        }
        if (ConfigurationHandler.decayTime == -1) {
            return true;
        }
        return (new Date().getTime() - this.deathDate) / 60000L < (long)ConfigurationHandler.decayTime;
    }

    @Override
    public void func_145841_b(NBTTagCompound compound) {
        super.func_145841_b(compound);
        compound.func_74782_a("inventory", (NBTBase)this.inventory.serializeNBT());
        compound.func_74757_a("needAccess", this.needAccess);
    }

    @Override
    public void func_145839_a(NBTTagCompound compound) {
        super.func_145839_a(compound);
        this.inventory.deserializeNBT(compound.func_74775_l("inventory"));
        this.needAccess = compound.func_74767_n("needAccess");
    }

    public AxisAlignedBB getRenderBoundingBox() {
        double renderExtension = 1.0;
        AxisAlignedBB bb = new AxisAlignedBB((double)this.field_174879_c.func_177958_n() - renderExtension, (double)this.field_174879_c.func_177956_o() - renderExtension, (double)this.field_174879_c.func_177952_p() - renderExtension, (double)(this.field_174879_c.func_177958_n() + 1) + renderExtension, (double)(this.field_174879_c.func_177956_o() + 1) + renderExtension, (double)(this.field_174879_c.func_177952_p() + 1) + renderExtension);
        return bb;
    }
}

