/*
 * Decompiled with CFR 0.152.
 */
package ovh.corail.tombstone.item;

import java.util.List;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.stats.StatBase;
import net.minecraft.util.BlockPos;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.world.World;
import ovh.corail.tombstone.core.Helper;
import ovh.corail.tombstone.core.Main;
import ovh.corail.tombstone.core.NBTStackHelper;
import ovh.corail.tombstone.core.TeleportUtils;
import ovh.corail.tombstone.handler.AchievementHandler;
import ovh.corail.tombstone.handler.ConfigurationHandler;
import ovh.corail.tombstone.handler.SoundHandler;
import ovh.corail.tombstone.item.ISoulConsumption;

public class ItemScrollOfRecall
extends Item
implements ISoulConsumption {
    private static final String name = "scroll_of_recall";

    public ItemScrollOfRecall() {
        this.setRegistryName(name);
        this.func_77655_b(name);
        this.func_77637_a(Main.tabTombstone);
        this.func_77625_d(1);
    }

    protected boolean isStackValid(ItemStack stack) {
        return stack != null && stack.func_77973_b() instanceof ItemScrollOfRecall;
    }

    public boolean setTombPos(ItemStack stack, BlockPos tombPos, int tombDim) {
        if (!this.isStackValid(stack)) {
            return false;
        }
        NBTStackHelper.setBlockPos(stack, "tombPos", tombPos);
        NBTStackHelper.setInteger(stack, "tombDim", tombDim);
        this.setUseCount(stack, ConfigurationHandler.scrollOfRecallUseCount);
        return true;
    }

    public BlockPos getTombPos(ItemStack stack) {
        if (!this.isStackValid(stack)) {
            return BlockPos.field_177992_a;
        }
        return NBTStackHelper.getBlockPos(stack, "tombPos");
    }

    public int getTombDim(ItemStack stack) {
        if (!this.isStackValid(stack)) {
            return Integer.MAX_VALUE;
        }
        return NBTStackHelper.getInteger(stack, "tombDim");
    }

    private ItemStack setUseCount(ItemStack stack, int useCount) {
        if (this.isStackValid(stack)) {
            NBTStackHelper.setInteger(stack, "useCount", useCount);
        }
        return stack;
    }

    public int getUseCount(ItemStack stack) {
        if (!this.isStackValid(stack)) {
            return 0;
        }
        return NBTStackHelper.getInteger(stack, "useCount");
    }

    public void func_77622_d(ItemStack stack, World worldIn, EntityPlayer player) {
        player.func_71064_a((StatBase)AchievementHandler.getAchievement("create_magic_scroll"), 1);
    }

    public boolean func_77636_d(ItemStack stack) {
        return this.isEnchanted(stack);
    }

    @Override
    public boolean isEnchanted(ItemStack stack) {
        return this.isStackValid(stack) && this.getTombPos(stack) != BlockPos.field_177992_a;
    }

    @Override
    public boolean setEnchant(World world, BlockPos gravePos, EntityPlayer player, ItemStack stack) {
        if (!this.isStackValid(stack)) {
            return false;
        }
        boolean valid = this.setTombPos(stack, gravePos, world.field_73011_w.func_177502_q());
        if (valid) {
            player.func_71064_a((StatBase)AchievementHandler.getAchievement("activate_magic_scroll"), 1);
            return true;
        }
        return false;
    }

    public void func_77624_a(ItemStack stack, EntityPlayer player, List<String> list, boolean advanced) {
        if (!this.isStackValid(stack)) {
            return;
        }
        if (!stack.func_77942_o()) {
            list.add(EnumChatFormatting.AQUA + Helper.getTranslation("item.scroll_of_recall.desc1"));
        } else {
            list.add(EnumChatFormatting.WHITE + Helper.getTranslation("item.scroll_of_recall.desc2"));
            int tombDimId = this.getTombDim(stack);
            BlockPos tombPos = this.getTombPos(stack);
            String tombDim = tombDimId == 0 ? "The Overworld" : (tombDimId == -1 ? "The Nether" : (tombDimId == -1 ? "The End" : "Unknown Land " + tombDimId));
            list.add(EnumChatFormatting.WHITE + Helper.getTranslation("item.info.dimTitle") + " : " + tombDim);
            list.add(EnumChatFormatting.WHITE + Helper.getTranslation("item.info.posTitle") + " :  " + tombPos.func_177958_n() + ", " + tombPos.func_177956_o() + ", " + tombPos.func_177952_p());
            list.add(EnumChatFormatting.WHITE + Helper.getTranslation("item.info.useCount") + " : " + this.getUseCount(stack));
            list.add(EnumChatFormatting.AQUA + Helper.getTranslation("item.info.tele"));
        }
    }

    public ItemStack func_77659_a(ItemStack stack, World world, EntityPlayer player) {
        if (this.isStackValid(stack)) {
            if (((ItemScrollOfRecall)stack.func_77973_b()).isEnchanted(stack)) {
                BlockPos tombPos = this.getTombPos(stack);
                int tombDim = this.getTombDim(stack);
                if (world.field_73011_w.func_177502_q() == tombDim && tombPos.func_177954_c(player.field_70165_t, player.field_70163_u, player.field_70161_v) < 10.0) {
                    Helper.sendMessage("message.teleport_near_grave.too_close", player, true);
                    return super.func_77659_a(stack, world, player);
                }
                int useCount = this.getUseCount(stack) - 1;
                if (useCount <= 0) {
                    player.field_71071_by.func_70299_a(player.field_71071_by.field_70461_c, null);
                } else {
                    this.setUseCount(stack, useCount);
                    player.field_71071_by.func_70299_a(player.field_71071_by.field_70461_c, stack);
                }
                if (useCount >= 0) {
                    TeleportUtils.TeleportLocation location = new TeleportUtils.TeleportLocation((double)tombPos.func_177958_n() + 0.5, (double)tombPos.func_177956_o() + 1.05, (double)tombPos.func_177952_p() + 0.5, tombDim);
                    location.sendEntityToCoords((Entity)player);
                    SoundHandler.playSoundAllAround("magic_use01", world, player.func_180425_c(), 10.0);
                    Main.proxy.useMagic(world, player.func_180425_c());
                    Helper.sendMessage("message.teleport_near_grave.success", player, true);
                }
                player.func_71064_a((StatBase)AchievementHandler.getAchievement("recall"), 1);
            } else {
                Helper.sendMessage("message.teleport_near_grave.not_activate", player, true);
            }
        }
        return super.func_77659_a(stack, world, player);
    }
}

