/*
 * Decompiled with CFR 0.152.
 */
package ovh.corail.tombstone.item;

import java.util.List;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.stats.StatBase;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.BlockPos;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.StatCollector;
import net.minecraft.world.World;
import ovh.corail.tombstone.core.Helper;
import ovh.corail.tombstone.core.Main;
import ovh.corail.tombstone.core.NBTStackHelper;
import ovh.corail.tombstone.core.TeleportUtils;
import ovh.corail.tombstone.handler.AchievementHandler;
import ovh.corail.tombstone.handler.ConfigurationHandler;
import ovh.corail.tombstone.handler.SoundHandler;
import ovh.corail.tombstone.item.ISoulConsumption;
import ovh.corail.tombstone.tileentity.TileEntityTombstone;

public class ItemGraveKey
extends Item
implements ISoulConsumption {
    private static final String name = "grave_key";

    public ItemGraveKey() {
        this.setRegistryName(name);
        this.func_77655_b(name);
        this.func_77637_a(null);
        this.func_77625_d(1);
    }

    public boolean setTombPos(ItemStack stack, BlockPos tombPos, int tombDim) {
        if (!this.isStackValid(stack)) {
            return false;
        }
        NBTStackHelper.setBlockPos(stack, "tombPos", tombPos);
        NBTStackHelper.setInteger(stack, "tombDim", tombDim);
        return true;
    }

    public BlockPos getTombPos(ItemStack stack) {
        if (!this.isStackValid(stack)) {
            return BlockPos.field_177992_a;
        }
        return NBTStackHelper.getBlockPos(stack, "tombPos");
    }

    public int getTombDim(ItemStack stack) {
        if (!this.isStackValid(stack)) {
            return Integer.MAX_VALUE;
        }
        return NBTStackHelper.getInteger(stack, "tombDim");
    }

    public void func_77663_a(ItemStack stack, World world, Entity entity, int slotId, boolean isSelected) {
        if (!this.isStackValid(stack)) {
            return;
        }
        if (world.field_72995_K) {
            return;
        }
        if (entity == null || !(entity instanceof EntityPlayer)) {
            return;
        }
        EntityPlayer player = (EntityPlayer)entity;
        int tombDimId = this.getTombDim(stack);
        if (tombDimId != world.field_73011_w.func_177502_q()) {
            return;
        }
        BlockPos tombPos = this.getTombPos(stack);
        if (!world.func_175667_e(tombPos)) {
            return;
        }
        TileEntity tile = world.func_175625_s(tombPos);
        if (tile == null || !(tile instanceof TileEntityTombstone)) {
            player.func_174820_d(slotId, null);
            player.field_71069_bz.func_75142_b();
        }
    }

    protected boolean isStackValid(ItemStack stack) {
        return stack != null && stack.func_77973_b() instanceof ItemGraveKey;
    }

    public String func_77653_i(ItemStack stack) {
        return this.func_77636_d(stack) ? Helper.getTranslation("item.grave_key.nameUpgraded") : StatCollector.func_74838_a((String)(this.func_77657_g(stack) + ".name")).trim();
    }

    public void func_77622_d(ItemStack stack, World world, EntityPlayer player) {
        if (this.isEnchanted(stack)) {
            player.func_71064_a((StatBase)AchievementHandler.getAchievement("upgrade_grave_key"), 1);
        }
    }

    public boolean func_77636_d(ItemStack stack) {
        return this.isEnchanted(stack);
    }

    @Override
    public boolean isEnchanted(ItemStack stack) {
        return this.isStackValid(stack) && NBTStackHelper.getBoolean(stack, "enchant");
    }

    @Override
    public boolean setEnchant(World world, BlockPos gravePos, EntityPlayer player, ItemStack stack) {
        if (!this.isStackValid(stack) || !ConfigurationHandler.upgradeTombKey) {
            return false;
        }
        NBTStackHelper.setBoolean(stack, "enchant", true);
        return true;
    }

    public void func_77624_a(ItemStack stack, EntityPlayer player, List<String> list, boolean advanced) {
        if (this.isStackValid(stack) && stack.func_77942_o()) {
            int tombDimId = this.getTombDim(stack);
            BlockPos tombPos = this.getTombPos(stack);
            if (tombDimId != Integer.MAX_VALUE && tombPos != BlockPos.field_177992_a) {
                String tombDim = tombDimId == 0 ? "The Overworld" : (tombDimId == -1 ? "The Nether" : (tombDimId == -1 ? "The End" : "Unknown Land " + tombDimId));
                list.add(EnumChatFormatting.WHITE + Helper.getTranslation("item.info.dimTitle") + " : " + tombDim);
                list.add(EnumChatFormatting.WHITE + Helper.getTranslation("item.info.posTitle") + " :  " + tombPos.func_177958_n() + ", " + tombPos.func_177956_o() + ", " + tombPos.func_177952_p());
            }
            if (this.func_77636_d(stack)) {
                list.add(EnumChatFormatting.AQUA + Helper.getTranslation("item.info.tele"));
            }
        }
    }

    public ItemStack func_77659_a(ItemStack stack, World world, EntityPlayer player) {
        if (this.isEnchanted(stack)) {
            BlockPos pos = this.getTombPos(stack);
            int dimId = this.getTombDim(stack);
            if (player.field_71093_bK != dimId && !ConfigurationHandler.teleportDim) {
                Helper.sendMessage("message.teleport_near_grave.sameDimension", player, true);
            } else {
                stack.func_77978_p().func_74757_a("enchant", false);
                TeleportUtils.TeleportLocation location = new TeleportUtils.TeleportLocation((double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o() + 1.05, (double)pos.func_177952_p() + 0.5, dimId);
                location.sendEntityToCoords((Entity)player);
                SoundHandler.playSoundAllAround("magic_use01", world, player.func_180425_c(), 10.0);
                Main.proxy.useMagic(world, player.func_180425_c());
                Helper.sendMessage("message.teleport_near_grave.success", player, true);
            }
        }
        return super.func_77659_a(stack, world, player);
    }
}

