/*
 * Decompiled with CFR 0.152.
 */
package ovh.corail.tombstone.handler;

import java.io.File;
import java.util.stream.Stream;
import net.minecraftforge.common.config.Configuration;
import ovh.corail.tombstone.block.BlockGrave;
import ovh.corail.tombstone.core.Helper;
import scala.Int;

public class ConfigurationHandler {
    public static Configuration config;
    private static File configDir;
    public static String lastFavoriteGrave;
    public static boolean handlePlayerDeath;
    public static boolean tombAccess;
    public static boolean upgradeTombKey;
    public static boolean xpLoss;
    public static boolean highlight;
    public static boolean teleportDim;
    public static boolean showFog;
    public static boolean pvpMode;
    public static String ingredientToUpgradeKey;
    public static String favoriteGrave;
    public static int percentXpLoss;
    public static int decayTime;
    public static int scrollOfRecallUseCount;
    public static int chanceSoul;
    public static int textColorRIP;
    public static int textColorOwner;
    public static int textColorDeathDate;
    public static int snifferRange;
    public static int graveRange;
    public static int ghostlyShapeDuration;

    private ConfigurationHandler() {
    }

    public static void refreshConfig() {
        handlePlayerDeath = config.getBoolean("handlePlayerDeath", "general", true, Helper.getTranslation("config.handlePlayerDeath"));
        String[] allowValues = (String[])Stream.of(BlockGrave.GraveType.values()).map(Enum::name).toArray(String[]::new);
        favoriteGrave = config.getString("favoriteGrave", "client", BlockGrave.GraveType.TOMBSTONE.toString(), Helper.getTranslation("config.favoriteGrave"), allowValues);
        tombAccess = config.getBoolean("tombAccess", "general", true, Helper.getTranslation("config.tombAccess"));
        upgradeTombKey = config.getBoolean("upgradeTombKey", "general", true, Helper.getTranslation("config.upgradeTombKey"));
        xpLoss = config.getBoolean("xpLoss", "general", false, Helper.getTranslation("config.xpLoss"));
        percentXpLoss = config.getInt("percentXpLoss", "general", 0, 0, 100, Helper.getTranslation("config.percentXpLoss"));
        ingredientToUpgradeKey = config.getString("ingredientToUpgradeKey", "general", "minecraft:ender_pearl:1", Helper.getTranslation("config.ingredientToUpgradeKey"));
        decayTime = config.getInt("decayTime", "general", -1, -1, Int.MaxValue(), Helper.getTranslation("config.decayTime"));
        highlight = config.getBoolean("highlight", "client", true, Helper.getTranslation("config.highlight"));
        teleportDim = config.getBoolean("teleportDim", "general", true, Helper.getTranslation("config.teleportDim"));
        showFog = config.getBoolean("showFog", "client", true, Helper.getTranslation("config.showFog"));
        pvpMode = config.getBoolean("pvpMode", "general", false, Helper.getTranslation("config.pvpMode"));
        scrollOfRecallUseCount = config.getInt("scrollOfRecallUseCount", "general", 3, 1, 10, Helper.getTranslation("config.scrollOfRecallUseCount"));
        chanceSoul = config.getInt("chanceSoul", "general", 3000, 1000, 5000, Helper.getTranslation("config.chanceSoul"));
        textColorRIP = config.getInt("textColorRIP", "client", 2962496, 0, 0xFFFFFF, Helper.getTranslation("config.textColorRIP"));
        textColorOwner = config.getInt("textColorOwner", "client", 5991302, 0, 0xFFFFFF, Helper.getTranslation("config.textColorOwner"));
        textColorDeathDate = config.getInt("textColorDeathDate", "client", 2962496, 0, 0xFFFFFF, Helper.getTranslation("config.textColorDeathDate"));
        snifferRange = config.getInt("snifferRange", "general", 5, 0, 10, Helper.getTranslation("config.snifferRange"));
        graveRange = config.getInt("graveRange", "general", 2, 0, 5, Helper.getTranslation("config.graveRange"));
        ghostlyShapeDuration = config.getInt("ghostlyShapeDuration", "general", 120, 0, 600, Helper.getTranslation("config.ghostlyShapeDuration"));
        if (config.hasChanged()) {
            config.save();
        }
    }

    public static void loadConfig(File configDir) {
        ConfigurationHandler.configDir = configDir;
        if (!configDir.exists()) {
            configDir.mkdir();
        }
        config = new Configuration(new File(configDir, "tombstone.cfg"), "1.4.1");
        config.load();
        ConfigurationHandler.refreshConfig();
        lastFavoriteGrave = favoriteGrave;
    }

    public static File getConfigDir() {
        return configDir;
    }
}

