/*
 * Decompiled with CFR 0.152.
 */
package ovh.corail.tombstone.core;

import com.google.common.collect.Lists;
import java.util.List;
import java.util.Random;
import net.minecraft.client.Minecraft;
import net.minecraft.client.particle.EntityFX;
import net.minecraft.client.renderer.tileentity.TileEntitySpecialRenderer;
import net.minecraft.util.BlockPos;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.world.World;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.client.registry.ClientRegistry;
import net.minecraftforge.fml.common.event.FMLInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPostInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.relauncher.Side;
import ovh.corail.tombstone.core.CommonProxy;
import ovh.corail.tombstone.core.Helper;
import ovh.corail.tombstone.handler.ClientEventHandler;
import ovh.corail.tombstone.particle.ParticleGraveSmoke;
import ovh.corail.tombstone.particle.ParticleGraveSoul;
import ovh.corail.tombstone.render.RenderWritableGrave;
import ovh.corail.tombstone.tileentity.TileEntityWritableGrave;

public class ClientProxy
extends CommonProxy {
    public List<List<Double>> smokeMotions = Lists.newArrayList();

    @Override
    public void preInit(FMLPreInitializationEvent event) {
        super.preInit(event);
        Helper.render();
        this.loadSmokeMotions();
    }

    @Override
    public void init(FMLInitializationEvent event) {
        super.init(event);
        ClientRegistry.bindTileEntitySpecialRenderer(TileEntityWritableGrave.class, (TileEntitySpecialRenderer)new RenderWritableGrave());
        MinecraftForge.EVENT_BUS.register((Object)new ClientEventHandler());
    }

    @Override
    public void postInit(FMLPostInitializationEvent event) {
        super.postInit(event);
    }

    @Override
    public Side getSide() {
        return Side.CLIENT;
    }

    private void loadSmokeMotions() {
        double motionZ = 0.01;
        double motionX = 0.01;
        double motionY = 0.0;
        double motion_null = 0.0;
        this.smokeMotions.add(Lists.newArrayList((Object[])new Double[]{0.2, 0.2, -motionX, motionY, -motionZ}));
        this.smokeMotions.add(Lists.newArrayList((Object[])new Double[]{0.2, 0.8, -motionX, motionY, motionZ}));
        this.smokeMotions.add(Lists.newArrayList((Object[])new Double[]{0.8, 0.2, motionX, motionY, -motionZ}));
        this.smokeMotions.add(Lists.newArrayList((Object[])new Double[]{0.8, 0.8, motionX, motionY, motionZ}));
        this.smokeMotions.add(Lists.newArrayList((Object[])new Double[]{0.2, 0.5, -motionX, motionY, motion_null}));
        this.smokeMotions.add(Lists.newArrayList((Object[])new Double[]{0.8, 0.5, motionX, motionY, motion_null}));
        this.smokeMotions.add(Lists.newArrayList((Object[])new Double[]{0.5, 0.2, motion_null, motionY, -motionZ}));
        this.smokeMotions.add(Lists.newArrayList((Object[])new Double[]{0.5, 0.8, motion_null, motionY, motionZ}));
        this.smokeMotions.add(Lists.newArrayList((Object[])new Double[]{0.5, 0.5, motionX, motionY, motionZ}));
        this.smokeMotions.add(Lists.newArrayList((Object[])new Double[]{0.5, 0.5, motionX, motionY, motionZ}));
        this.smokeMotions.add(Lists.newArrayList((Object[])new Double[]{0.5, 0.5, motionX, motionY, -motionZ}));
        this.smokeMotions.add(Lists.newArrayList((Object[])new Double[]{0.5, 0.5, -motionX, motionY, motionZ}));
        this.smokeMotions.add(Lists.newArrayList((Object[])new Double[]{0.5, 0.5, -motionX, motionY, -motionZ}));
    }

    @Override
    public void produceGraveSmoke(World world, BlockPos pos) {
        List<Double> smokeMotion = this.smokeMotions.get(Helper.getRandom(0, this.smokeMotions.size() - 1));
        ParticleGraveSmoke particle = new ParticleGraveSmoke(world, (double)pos.func_177958_n() + smokeMotion.get(0), (double)pos.func_177956_o() + 0.4, (double)pos.func_177952_p() + smokeMotion.get(1), smokeMotion.get(2), smokeMotion.get(3), smokeMotion.get(4));
        Minecraft.func_71410_x().field_71452_i.func_78873_a((EntityFX)particle);
    }

    @Override
    public void produceGraveSoul(World world, BlockPos pos) {
        ParticleGraveSoul particle = new ParticleGraveSoul(world, pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p(), 0.3);
        Minecraft.func_71410_x().field_71452_i.func_78873_a((EntityFX)particle);
    }

    @Override
    public void useMagic(World world, BlockPos pos) {
        Random rand = new Random();
        for (double i = 0.0; i < 4.0; i += 1.0) {
            world.func_175688_a(EnumParticleTypes.SPELL_INSTANT, (double)pos.func_177958_n() + (double)rand.nextFloat(), (double)pos.func_177956_o() + (double)rand.nextFloat(), (double)pos.func_177952_p() + (double)rand.nextFloat(), 0.0, 0.0, 0.0, new int[0]);
        }
    }
}

