/*
 * Decompiled with CFR 0.152.
 */
package ic2.core.item.tool;

import ic2.core.IC2;
import ic2.core.block.machine.tileentity.TileEntityTeleporter;
import ic2.core.item.ItemIC2;
import ic2.core.ref.ItemName;
import ic2.core.util.StackUtil;
import java.util.List;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.BlockPos;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.StatCollector;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class ItemFrequencyTransmitter
extends ItemIC2 {
    private static final String targetSetNbt = "targetSet";
    private static final String targetXNbt = "targetX";
    private static final String targetYNbt = "targetY";
    private static final String targetZNbt = "targetZ";

    public ItemFrequencyTransmitter() {
        super(ItemName.frequency_transmitter);
        this.field_77777_bU = 1;
    }

    public ItemStack func_77659_a(ItemStack itemstack, World world, EntityPlayer entityplayer) {
        NBTTagCompound nbtData;
        if (IC2.platform.isSimulating() && (nbtData = StackUtil.getOrCreateNbtData(itemstack)).func_74767_n(targetSetNbt)) {
            nbtData.func_74757_a(targetSetNbt, false);
            IC2.platform.messagePlayer(entityplayer, "Frequency Transmitter unlinked", new Object[0]);
        }
        return itemstack;
    }

    public boolean onItemUseFirst(ItemStack stack, EntityPlayer player, World world, BlockPos pos, EnumFacing side, float hitX, float hitY, float hitZ) {
        if (world.field_72995_K) {
            return false;
        }
        TileEntity te = world.func_175625_s(pos);
        if (!(te instanceof TileEntityTeleporter)) {
            return false;
        }
        TileEntityTeleporter tp = (TileEntityTeleporter)te;
        NBTTagCompound nbtData = StackUtil.getOrCreateNbtData(stack);
        boolean targetSet = nbtData.func_74767_n(targetSetNbt);
        BlockPos target = new BlockPos(nbtData.func_74762_e(targetXNbt), nbtData.func_74762_e(targetYNbt), nbtData.func_74762_e(targetZNbt));
        if (!targetSet) {
            targetSet = true;
            target = tp.func_174877_v();
            IC2.platform.messagePlayer(player, "Frequency Transmitter linked to Teleporter.", new Object[0]);
        } else if (tp.func_174877_v().equals((Object)target)) {
            IC2.platform.messagePlayer(player, "Can't link Teleporter to itself.", new Object[0]);
        } else if (tp.hasTarget() && tp.getTarget().equals((Object)target)) {
            IC2.platform.messagePlayer(player, "Teleportation link unchanged.", new Object[0]);
        } else {
            TileEntity targetTe = world.func_175625_s(target);
            if (targetTe instanceof TileEntityTeleporter) {
                tp.setTarget(target);
                ((TileEntityTeleporter)targetTe).setTarget(pos);
                IC2.platform.messagePlayer(player, "Teleportation link established.", new Object[0]);
            } else {
                targetSet = false;
            }
        }
        nbtData.func_74757_a(targetSetNbt, targetSet);
        nbtData.func_74768_a(targetXNbt, target.func_177958_n());
        nbtData.func_74768_a(targetYNbt, target.func_177956_o());
        nbtData.func_74768_a(targetZNbt, target.func_177952_p());
        return false;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack stack, EntityPlayer player, List<String> tooltip, boolean advanced) {
        NBTTagCompound nbtData = StackUtil.getOrCreateNbtData(stack);
        if (nbtData.func_74767_n(targetSetNbt)) {
            tooltip.add(StatCollector.func_74837_a((String)"ic2.frequency_transmitter.tooltip.target", (Object[])new Object[]{nbtData.func_74762_e(targetXNbt), nbtData.func_74762_e(targetYNbt), nbtData.func_74762_e(targetZNbt)}));
        } else {
            tooltip.add(StatCollector.func_74838_a((String)"ic2.frequency_transmitter.tooltip.blank"));
        }
    }
}

