/*
 * Decompiled with CFR 0.152.
 */
package ic2.core.item.tool;

import ic2.api.item.ElectricItem;
import ic2.api.item.IBoxable;
import ic2.api.item.IElectricItem;
import ic2.api.item.IItemHudInfo;
import ic2.core.IC2;
import ic2.core.audio.AudioSource;
import ic2.core.audio.PositionSpec;
import ic2.core.item.ElectricItemManager;
import ic2.core.item.ItemIC2;
import ic2.core.ref.IItemModelProvider;
import ic2.core.ref.ItemName;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemTool;
import net.minecraft.util.BlockPos;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.StatCollector;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.registry.GameRegistry;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public abstract class ItemElectricTool
extends ItemTool
implements IItemModelProvider,
IElectricItem,
IBoxable,
IItemHudInfo {
    public double operationEnergyCost;
    public int maxCharge;
    public int transferLimit;
    public int tier;
    protected AudioSource audioSource;
    protected boolean wasEquipped;
    private final Set<ToolClass> toolClasses;

    protected ItemElectricTool(ItemName name, int operationEnergyCost) {
        this(name, operationEnergyCost, HarvestLevel.Iron, Collections.emptySet());
    }

    protected ItemElectricTool(ItemName name, int operationEnergyCost, HarvestLevel harvestLevel, Set<ToolClass> toolClasses) {
        this(name, operationEnergyCost, harvestLevel, toolClasses, new HashSet<Block>());
    }

    private ItemElectricTool(ItemName name, int operationEnergyCost, HarvestLevel harvestLevel, Set<ToolClass> toolClasses, Set<Block> mineableBlocks) {
        super(0.0f, harvestLevel.toolMaterial, mineableBlocks);
        this.operationEnergyCost = operationEnergyCost;
        this.toolClasses = toolClasses;
        this.func_77656_e(27);
        this.func_77625_d(1);
        this.setNoRepair();
        this.func_77655_b(name.name());
        this.func_77637_a(IC2.tabIC2);
        for (ToolClass toolClass : toolClasses) {
            if (toolClass.name == null) continue;
            this.setHarvestLevel(toolClass.name, harvestLevel.level);
        }
        if (toolClasses.contains((Object)ToolClass.Pickaxe) && harvestLevel.toolMaterial == Item.ToolMaterial.EMERALD) {
            mineableBlocks.add(Blocks.field_150343_Z);
            mineableBlocks.add(Blocks.field_150450_ax);
            mineableBlocks.add(Blocks.field_150439_ay);
        }
        GameRegistry.registerItem((Item)this, (String)name.name());
        name.setInstance(this);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void registerModels(ItemName name) {
        ItemIC2.registerModel((Item)this, 0, name, null);
    }

    public boolean func_180614_a(ItemStack stack, EntityPlayer player, World world, BlockPos pos, EnumFacing side, float xOffset, float yOffset, float zOffset) {
        ElectricItem.manager.use(stack, 0.0, (EntityLivingBase)player);
        return super.func_180614_a(stack, player, world, pos, side, xOffset, yOffset, zOffset);
    }

    public ItemStack func_77659_a(ItemStack stack, World world, EntityPlayer player) {
        ElectricItem.manager.use(stack, 0.0, (EntityLivingBase)player);
        return super.func_77659_a(stack, world, player);
    }

    public String func_77658_a() {
        return "ic2." + super.func_77658_a().substring(5);
    }

    public String func_77667_c(ItemStack stack) {
        return this.func_77658_a();
    }

    public String func_77653_i(ItemStack stack) {
        return StatCollector.func_74838_a((String)this.func_77667_c(stack));
    }

    public boolean shouldCauseReequipAnimation(ItemStack oldStack, ItemStack newStack, boolean slotChanged) {
        return ItemIC2.shouldReequip(oldStack, newStack, slotChanged);
    }

    public boolean canHarvestBlock(Block block, ItemStack stack) {
        Material material = block.func_149688_o();
        for (ToolClass toolClass : this.toolClasses) {
            if (!toolClass.whitelist.contains(block) && !toolClass.whitelist.contains(material)) continue;
            return true;
        }
        return super.canHarvestBlock(block, stack);
    }

    public float getDigSpeed(ItemStack tool, IBlockState state) {
        if (!ElectricItem.manager.canUse(tool, this.operationEnergyCost)) {
            return 1.0f;
        }
        return super.getDigSpeed(tool, state);
    }

    public float func_150893_a(ItemStack stack, Block block) {
        if (this.canHarvestBlock(block, stack)) {
            return this.field_77864_a;
        }
        return super.func_150893_a(stack, block);
    }

    public boolean func_77644_a(ItemStack itemstack, EntityLivingBase entityliving, EntityLivingBase entityliving1) {
        return true;
    }

    public int func_77619_b() {
        return 0;
    }

    public boolean isRepairable() {
        return false;
    }

    @Override
    public boolean canProvideEnergy(ItemStack stack) {
        return false;
    }

    @Override
    public double getMaxCharge(ItemStack stack) {
        return this.maxCharge;
    }

    @Override
    public int getTier(ItemStack stack) {
        return this.tier;
    }

    @Override
    public double getTransferLimit(ItemStack stack) {
        return this.transferLimit;
    }

    public boolean func_179218_a(ItemStack stack, World world, Block block, BlockPos pos, EntityLivingBase user) {
        if (block.func_176195_g(world, pos) != 0.0f) {
            if (user != null) {
                ElectricItem.manager.use(stack, this.operationEnergyCost, user);
            } else {
                ElectricItem.manager.discharge(stack, this.operationEnergyCost, this.tier, true, false, false);
            }
        }
        return true;
    }

    public boolean func_82789_a(ItemStack par1ItemStack, ItemStack par2ItemStack) {
        return false;
    }

    @Override
    public boolean canBeStoredInToolbox(ItemStack itemstack) {
        return true;
    }

    public boolean isBookEnchantable(ItemStack itemstack1, ItemStack itemstack2) {
        return false;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_150895_a(Item item, CreativeTabs tab, List<ItemStack> subItems) {
        ElectricItemManager.addChargeVariants(item, subItems);
    }

    @Override
    public List<String> getHudInfo(ItemStack stack) {
        LinkedList<String> info = new LinkedList<String>();
        info.add(ElectricItem.manager.getToolTip(stack));
        info.add(StatCollector.func_74837_a((String)"ic2.item.tooltip.PowerTier", (Object[])new Object[]{this.tier}));
        return info;
    }

    protected ItemStack getItemStack(double charge) {
        ItemStack ret = new ItemStack((Item)this);
        ElectricItem.manager.charge(ret, charge, Integer.MAX_VALUE, true, false);
        return ret;
    }

    public void func_77663_a(ItemStack itemstack, World world, Entity entity, int i, boolean flag) {
        boolean isEquipped;
        boolean bl = isEquipped = flag && entity instanceof EntityLivingBase;
        if (IC2.platform.isRendering()) {
            if (isEquipped && !this.wasEquipped) {
                String initSound;
                String sound;
                if (this.audioSource == null && (sound = this.getIdleSound((EntityLivingBase)entity, itemstack)) != null) {
                    this.audioSource = IC2.audioManager.createSource(entity, PositionSpec.Hand, sound, true, false, IC2.audioManager.getDefaultVolume());
                }
                if (this.audioSource != null) {
                    this.audioSource.play();
                }
                if ((initSound = this.getStartSound((EntityLivingBase)entity, itemstack)) != null) {
                    IC2.audioManager.playOnce(entity, PositionSpec.Hand, initSound, true, IC2.audioManager.getDefaultVolume());
                }
            } else if (!isEquipped && this.audioSource != null) {
                String sound;
                this.removeAudioSource();
                if (entity instanceof EntityLivingBase && (sound = this.getStopSound((EntityLivingBase)entity, itemstack)) != null) {
                    IC2.audioManager.playOnce(entity, PositionSpec.Hand, sound, true, IC2.audioManager.getDefaultVolume());
                }
            } else if (this.audioSource != null) {
                this.audioSource.updatePosition();
            }
            this.wasEquipped = isEquipped;
        }
    }

    protected void removeAudioSource() {
        if (this.audioSource != null) {
            this.audioSource.stop();
            this.audioSource.remove();
            this.audioSource = null;
        }
    }

    public boolean onDroppedByPlayer(ItemStack item, EntityPlayer player) {
        this.removeAudioSource();
        return true;
    }

    protected String getIdleSound(EntityLivingBase player, ItemStack stack) {
        return null;
    }

    protected String getStopSound(EntityLivingBase player, ItemStack stack) {
        return null;
    }

    protected String getStartSound(EntityLivingBase player, ItemStack stack) {
        return null;
    }

    protected static enum ToolClass {
        Axe("axe", Material.field_151575_d, Material.field_151585_k, Material.field_151582_l),
        Pickaxe("pickaxe", Material.field_151573_f, Material.field_151574_g, Material.field_151576_e),
        Shears("shears", Blocks.field_150321_G, Blocks.field_150325_L, Blocks.field_150488_af, Blocks.field_150473_bD, Material.field_151584_j),
        Shovel("shovel", Blocks.field_150431_aC, Blocks.field_150433_aE),
        Sword("sword", Blocks.field_150321_G, Material.field_151585_k, Material.field_151582_l, Material.field_151589_v, Material.field_151584_j, Material.field_151572_C),
        Hoe(null, Blocks.field_150346_d, Blocks.field_150349_c, Blocks.field_150391_bh);

        public final String name;
        public final Set<Object> whitelist;

        private ToolClass(String name, Object ... whitelist) {
            this.name = name;
            this.whitelist = new HashSet<Object>(Arrays.asList(whitelist));
        }
    }

    protected static enum HarvestLevel {
        Wood(0, Item.ToolMaterial.WOOD),
        Stone(1, Item.ToolMaterial.STONE),
        Iron(2, Item.ToolMaterial.IRON),
        Diamond(3, Item.ToolMaterial.EMERALD),
        Iridium(100, Item.ToolMaterial.EMERALD);

        public final int level;
        public final Item.ToolMaterial toolMaterial;

        private HarvestLevel(int level, Item.ToolMaterial toolMaterial) {
            this.level = level;
            this.toolMaterial = toolMaterial;
        }
    }
}

