/*
 * Decompiled with CFR 0.152.
 */
package ic2.core.item.armor;

import ic2.core.IC2;
import ic2.core.audio.AudioSource;
import ic2.core.audio.PositionSpec;
import ic2.core.init.InternalName;
import ic2.core.item.armor.ItemArmorFluidTank;
import ic2.core.ref.FluidName;
import ic2.core.ref.ItemName;
import ic2.core.util.StackUtil;
import java.util.List;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class ItemArmorJetpack
extends ItemArmorFluidTank {
    protected static AudioSource audioSource;
    private static boolean lastJetpackUsed;

    public ItemArmorJetpack() {
        this(ItemName.jetpack);
    }

    protected ItemArmorJetpack(ItemName name) {
        super(name, InternalName.jetpack, FluidName.biogas.getInstance(), 30000);
    }

    public void use(ItemStack stack, double amount) {
        this.drainfromJetpack(stack, (int)amount);
        this.Updatedamage(stack);
    }

    public boolean useJetpack(EntityPlayer player, boolean hoverMode) {
        ItemStack jetpack = player.field_71071_by.field_70460_b[2];
        if (this.getCharge(jetpack) <= 0.0) {
            return false;
        }
        boolean electric = jetpack.func_77973_b() == ItemName.jetpack_electric.getInstance();
        float power = 1.0f;
        float dropPercentage = 0.2f;
        if (electric) {
            power = 0.7f;
            dropPercentage = 0.05f;
        }
        if (this.getCharge(jetpack) / this.getMaxCharge(jetpack) <= (double)dropPercentage) {
            power = (float)((double)power * (this.getCharge(jetpack) / (this.getMaxCharge(jetpack) * (double)dropPercentage)));
        }
        if (IC2.keyboard.isForwardKeyDown(player)) {
            float forwardpower;
            float retruster = 0.15f;
            if (hoverMode) {
                retruster = 1.0f;
            }
            if (electric) {
                retruster += 0.15f;
            }
            if ((forwardpower = power * retruster * 2.0f) > 0.0f) {
                player.func_70060_a(0.0f, 0.4f * forwardpower, 0.02f);
            }
        }
        int worldHeight = IC2.getWorldHeight(player.field_70170_p);
        double y = player.field_70163_u;
        int maxFlightHeight = electric ? (int)((float)worldHeight / 1.28f) : worldHeight;
        if (y > (double)(maxFlightHeight - 25)) {
            if (y > (double)maxFlightHeight) {
                y = maxFlightHeight;
            }
            power = (float)((double)power * (((double)maxFlightHeight - y) / 25.0));
        }
        double prevmotion = player.field_70181_x;
        player.field_70181_x = Math.min(player.field_70181_x + (double)(power * 0.2f), (double)0.6f);
        if (hoverMode) {
            float maxHoverY = 0.0f;
            if (IC2.keyboard.isJumpKeyDown(player)) {
                maxHoverY = electric ? 0.1f : 0.2f;
            }
            if (IC2.keyboard.isSneakKeyDown(player)) {
                maxHoverY = electric ? -0.1f : -0.2f;
            }
            if (player.field_70181_x > (double)maxHoverY) {
                player.field_70181_x = maxHoverY;
                if (prevmotion > player.field_70181_x) {
                    player.field_70181_x = prevmotion;
                }
            }
        }
        int consume = 2;
        if (hoverMode) {
            consume = 1;
        }
        if (electric) {
            consume += 6;
        }
        if (!player.field_70122_E) {
            this.use(jetpack, consume);
        }
        player.field_70143_R = 0.0f;
        player.field_70140_Q = 0.0f;
        IC2.platform.resetPlayerInAirTime(player);
        return true;
    }

    public boolean drainfromJetpack(ItemStack pack, int amount) {
        if (this.isEmpty(pack)) {
            return false;
        }
        if (this.drain((ItemStack)pack, (int)amount, (boolean)false).amount < amount) {
            return false;
        }
        this.drain(pack, amount, true);
        return true;
    }

    public void onArmorTick(World world, EntityPlayer player, ItemStack stack) {
        if (player.field_71071_by.field_70460_b[2] != stack) {
            return;
        }
        NBTTagCompound nbtData = StackUtil.getOrCreateNbtData(stack);
        boolean hoverMode = nbtData.func_74767_n("hoverMode");
        byte toggleTimer = nbtData.func_74771_c("toggleTimer");
        boolean jetpackUsed = false;
        if (IC2.keyboard.isJumpKeyDown(player) && IC2.keyboard.isModeSwitchKeyDown(player) && toggleTimer == 0) {
            toggleTimer = 10;
            boolean bl = hoverMode = !hoverMode;
            if (IC2.platform.isSimulating()) {
                nbtData.func_74757_a("hoverMode", hoverMode);
                if (hoverMode) {
                    IC2.platform.messagePlayer(player, "Hover Mode enabled.", new Object[0]);
                } else {
                    IC2.platform.messagePlayer(player, "Hover Mode disabled.", new Object[0]);
                }
            }
        }
        if (IC2.keyboard.isJumpKeyDown(player) || hoverMode) {
            jetpackUsed = this.useJetpack(player, hoverMode);
        }
        if (IC2.platform.isSimulating() && toggleTimer > 0) {
            toggleTimer = (byte)(toggleTimer - 1);
            nbtData.func_74774_a("toggleTimer", toggleTimer);
        }
        if (IC2.platform.isRendering() && player == IC2.platform.getPlayerInstance()) {
            if (lastJetpackUsed != jetpackUsed) {
                if (jetpackUsed) {
                    if (audioSource == null) {
                        audioSource = IC2.audioManager.createSource(player, PositionSpec.Backpack, "Tools/Jetpack/JetpackLoop.ogg", true, false, IC2.audioManager.getDefaultVolume());
                    }
                    if (audioSource != null) {
                        audioSource.play();
                    }
                } else if (audioSource != null) {
                    audioSource.remove();
                    audioSource = null;
                }
                lastJetpackUsed = jetpackUsed;
            }
            if (audioSource != null) {
                audioSource.updatePosition();
            }
        }
        if (jetpackUsed) {
            player.field_71069_bz.func_75142_b();
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void func_150895_a(Item item, CreativeTabs tab, List<ItemStack> subItems) {
        ItemStack stack = new ItemStack(item, 1);
        this.filltank(stack);
        stack.func_77964_b(1);
        subItems.add(stack);
        stack = new ItemStack(item, 1);
        stack.func_77964_b(this.func_77612_l());
        subItems.add(stack);
    }

    static {
        lastJetpackUsed = false;
    }
}

