/*
 * Decompiled with CFR 0.152.
 */
package ic2.core.init;

import ic2.core.item.type.IngotResourceType;
import ic2.core.item.type.MiscResourceType;
import ic2.core.ref.BlockName;
import ic2.core.ref.ItemName;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraft.util.WeightedRandomChestContent;
import net.minecraftforge.common.ChestGenHooks;

public class Ic2Loot {
    private static final WeightedRandomChestContent[] MINESHAFT_CORRIDOR = new WeightedRandomChestContent[]{new WeightedRandomChestContent(ItemName.bronze_pickaxe.getItemStack(), 1, 1, 1), new WeightedRandomChestContent(ItemName.misc_resource.getItemStack(MiscResourceType.iridium_shard), 2, 5, 8)};
    private static final WeightedRandomChestContent[] STRONGHOLD_CORRIDOR = new WeightedRandomChestContent[]{new WeightedRandomChestContent(ItemName.misc_resource.getItemStack(MiscResourceType.iridium_ore), 1, 4, 1), new WeightedRandomChestContent(ItemName.misc_resource.getItemStack(MiscResourceType.iridium_shard), 4, 14, 8)};
    private static final WeightedRandomChestContent[] STRONGHOLD_CROSSING = new WeightedRandomChestContent[]{new WeightedRandomChestContent(ItemName.bronze_pickaxe.getItemStack(), 1, 1, 1), new WeightedRandomChestContent(ItemName.misc_resource.getItemStack(MiscResourceType.iridium_ore), 1, 1, 1), new WeightedRandomChestContent(ItemName.misc_resource.getItemStack(MiscResourceType.iridium_shard), 3, 7, 4)};
    private static final WeightedRandomChestContent[] VILLAGE_BLACKSMITH = new WeightedRandomChestContent[]{new WeightedRandomChestContent(ItemName.ingot.getItemStack(IngotResourceType.bronze), 2, 4, 5), new WeightedRandomChestContent(ItemName.misc_resource.getItemStack(MiscResourceType.iridium_shard), 3, 7, 4), new WeightedRandomChestContent(BlockName.sapling.getItemStack(), 1, 4, 4)};
    private static final WeightedRandomChestContent[] BONUS_CHEST = new WeightedRandomChestContent[]{new WeightedRandomChestContent(ItemName.treetap.getItemStack(), 1, 1, 2)};
    private static final WeightedRandomChestContent[] DUNGEON_CHEST = new WeightedRandomChestContent[]{new WeightedRandomChestContent(ItemName.ingot.getItemStack(IngotResourceType.copper), 2, 5, 100), new WeightedRandomChestContent(ItemName.ingot.getItemStack(IngotResourceType.tin), 2, 5, 100), new WeightedRandomChestContent(ItemName.misc_resource.getItemStack(MiscResourceType.iridium_ore), 1, 2, 20), new WeightedRandomChestContent(ItemName.misc_resource.getItemStack(MiscResourceType.iridium_shard), 6, 14, 100), new WeightedRandomChestContent(new ItemStack(Items.field_151094_cf), 1, 1, 5), new WeightedRandomChestContent(new ItemStack(Items.field_151091_cg), 1, 1, 5), new WeightedRandomChestContent(new ItemStack(Items.field_151092_ch), 1, 1, 5), new WeightedRandomChestContent(new ItemStack(Items.field_151089_ci), 1, 1, 5), new WeightedRandomChestContent(new ItemStack(Items.field_151090_cj), 1, 1, 5), new WeightedRandomChestContent(new ItemStack(Items.field_151087_ck), 1, 1, 5), new WeightedRandomChestContent(new ItemStack(Items.field_151088_cl), 1, 1, 5), new WeightedRandomChestContent(new ItemStack(Items.field_151085_cm), 1, 1, 5), new WeightedRandomChestContent(new ItemStack(Items.field_151086_cn), 1, 1, 5), new WeightedRandomChestContent(new ItemStack(Items.field_151084_co), 1, 1, 5)};
    private static final WeightedRandomChestContent[] bronzeToolsArmor = new WeightedRandomChestContent[]{new WeightedRandomChestContent(ItemName.bronze_pickaxe.getItemStack(), 1, 1, 3), new WeightedRandomChestContent(ItemName.bronze_sword.getItemStack(), 1, 1, 3)};
    private static final WeightedRandomChestContent[] ingots = new WeightedRandomChestContent[]{new WeightedRandomChestContent(ItemName.ingot.getItemStack(IngotResourceType.copper), 2, 6, 9), new WeightedRandomChestContent(ItemName.ingot.getItemStack(IngotResourceType.tin), 1, 5, 8)};

    public static void load() {
        Ic2Loot.addLoot("mineshaftCorridor", MINESHAFT_CORRIDOR, ingots);
        Ic2Loot.addLoot("pyramidDesertyChest", bronzeToolsArmor, ingots);
        Ic2Loot.addLoot("pyramidJungleChest", bronzeToolsArmor, ingots);
        Ic2Loot.addLoot("strongholdCorridor", STRONGHOLD_CORRIDOR, bronzeToolsArmor, ingots);
        Ic2Loot.addLoot("strongholdCrossing", STRONGHOLD_CROSSING, bronzeToolsArmor, ingots);
        Ic2Loot.addLoot("villageBlacksmith", VILLAGE_BLACKSMITH, bronzeToolsArmor, ingots);
        Ic2Loot.addLoot("bonusChest", new WeightedRandomChestContent[][]{BONUS_CHEST});
        Ic2Loot.addLoot("dungeonChest", new WeightedRandomChestContent[][]{DUNGEON_CHEST});
    }

    private static void addLoot(String category, WeightedRandomChestContent[] ... loot) {
        ChestGenHooks cgh = ChestGenHooks.getInfo((String)category);
        WeightedRandomChestContent[][] weightedRandomChestContentArray = loot;
        int n = weightedRandomChestContentArray.length;
        for (int i = 0; i < n; ++i) {
            WeightedRandomChestContent[] lootList;
            for (WeightedRandomChestContent lootEntry : lootList = weightedRandomChestContentArray[i]) {
                cgh.addItem(lootEntry);
            }
        }
    }
}

