/*
 * Decompiled with CFR 0.152.
 */
package ic2.core.energy.leg;

import ic2.api.energy.event.EnergyTileLoadEvent;
import ic2.api.energy.event.EnergyTileUnloadEvent;
import ic2.core.IC2;
import ic2.core.energy.leg.BasicEnergyTileTask;
import ic2.core.energy.leg.EnergyNetLocalLeg;
import ic2.core.util.LogCategory;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.world.WorldEvent;
import net.minecraftforge.fml.common.eventhandler.EventPriority;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;

public class EventHandler {
    public EventHandler() {
        MinecraftForge.EVENT_BUS.register((Object)this);
    }

    @SubscribeEvent
    public void onEnergyTileLoad(EnergyTileLoadEvent event) {
        if (!IC2.platform.isSimulating()) {
            IC2.log.warn(LogCategory.EnergyNet, "EnergyNet.addTileEntity: called for " + event.tile + " client-side, aborting");
            return;
        }
        EnergyNetLocalLeg enet = EnergyNetLocalLeg.getForWorld(event.world);
        enet.thread.queue.add(new BasicEnergyTileTask.EnergyTileLoadTask(event.tile));
    }

    @SubscribeEvent
    public void onEnergyTileUnload(EnergyTileUnloadEvent event) {
        if (!IC2.platform.isSimulating()) {
            IC2.log.warn(LogCategory.EnergyNet, "EnergyNet.removeTileEntity: called for " + event.tile + " client-side, aborting");
            return;
        }
        EnergyNetLocalLeg enet = EnergyNetLocalLeg.getForWorld(event.world);
        enet.thread.queue.add(new BasicEnergyTileTask.EnergyTileUnloadTask(event.tile));
    }

    @SubscribeEvent
    public void preTick(TickEvent.WorldTickEvent event) {
        EnergyNetLocalLeg enet = EnergyNetLocalLeg.getForWorld(event.world);
        if (event.phase == TickEvent.Phase.START) {
            enet.tickStart();
        } else {
            enet.tickEnd();
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGH)
    public void onWorldUnload(WorldEvent.Unload event) {
        if (event.world.field_72995_K) {
            return;
        }
        EnergyNetLocalLeg enet = EnergyNetLocalLeg.getForWorld(event.world);
        enet.thread.queue.add(new BasicEnergyTileTask.EndThreadTask());
    }
}

