/*
 * Decompiled with CFR 0.152.
 */
package ic2.core.command;

import ic2.api.recipe.IRecipeInput;
import ic2.core.IC2;
import ic2.core.IWorldTickCallback;
import ic2.core.WorldData;
import ic2.core.block.BlockTileEntity;
import ic2.core.block.TileEntityBlock;
import ic2.core.energy.EnergyNetGateway;
import ic2.core.energy.EnergyNetLocal;
import ic2.core.energy.GridInfo;
import ic2.core.ref.BlockName;
import ic2.core.ref.IBlockModelProvider;
import ic2.core.ref.IMultiBlock;
import ic2.core.ref.IMultiItem;
import ic2.core.ref.TeBlock;
import ic2.core.util.ConfigUtil;
import ic2.core.util.LogCategory;
import ic2.core.util.StackUtil;
import ic2.core.util.Util;
import ic2.core.uu.DropScan;
import ic2.core.uu.UuGraph;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.IOException;
import java.nio.IntBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.regex.Pattern;
import javax.imageio.ImageIO;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.OpenGlHelper;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.command.CommandBase;
import net.minecraft.command.CommandException;
import net.minecraft.command.CommandResultStats;
import net.minecraft.command.ICommand;
import net.minecraft.command.ICommandSender;
import net.minecraft.command.WrongUsageException;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.Blocks;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.JsonToNBT;
import net.minecraft.nbt.NBTException;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.BlockPos;
import net.minecraft.util.ChatComponentText;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.IChatComponent;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraftforge.client.event.RenderWorldLastEvent;
import net.minecraftforge.common.DimensionManager;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.registry.GameData;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.oredict.OreDictionary;
import org.lwjgl.BufferUtils;
import org.lwjgl.opengl.GL11;

public class CommandIc2
extends CommandBase {
    public String func_71517_b() {
        return "ic2";
    }

    public String func_71518_a(ICommandSender icommandsender) {
        return "/ic2 uu-world-scan <small|medium|large> | debug (dumpUuValues | resolveIngredient <name> | dumpTextures <name> <size> | dumpLargeGrids)";
    }

    public List<String> func_180525_a(ICommandSender sender, String[] args, BlockPos pos) {
        if (args.length == 1) {
            return CommandIc2.func_71530_a((String[])args, (String[])new String[]{"uu-world-scan", "debug", "currentItem", "itemNameWithVariant", "setblock", "fill"});
        }
        if (args.length == 2 && args[0].equals("uu-world-scan")) {
            return CommandIc2.func_71530_a((String[])args, (String[])new String[]{"small", "medium", "large"});
        }
        if (args.length >= 2 && args[0].equals("debug")) {
            if (args.length == 2) {
                return CommandIc2.func_71530_a((String[])args, (String[])new String[]{"dumpUuValues", "resolveIngredient", "dumpTextures", "dumpLargeGrids"});
            }
            if (args.length == 3 && args[1].equals("resolveIngredient")) {
                ArrayList<String> possibilities = new ArrayList<String>(1024);
                for (ResourceLocation loc : Item.field_150901_e.func_148742_b()) {
                    possibilities.add(loc.toString());
                }
                for (String name : OreDictionary.getOreNames()) {
                    possibilities.add("OreDict:" + name);
                }
                for (String name : FluidRegistry.getRegisteredFluids().keySet()) {
                    possibilities.add("Fluid:" + name);
                }
                return CommandIc2.func_175762_a((String[])args, possibilities);
            }
        } else if (args.length == 5 && "setblock".equals(args[0]) || args.length == 8 && "fill".equals(args[0])) {
            ArrayList<String> options = new ArrayList<String>(150);
            for (BlockName block : BlockName.values) {
                Object instance = block.getInstance();
                if (instance instanceof IMultiBlock) {
                    options.addAll(((IMultiBlock)instance).getTypes());
                    continue;
                }
                if (instance instanceof IBlockModelProvider) {
                    options.add(block.name());
                    continue;
                }
                if (instance != null) {
                    IC2.log.info(LogCategory.Block, "Patch needed in setblock for " + instance.func_149732_F());
                    continue;
                }
                IC2.log.info(LogCategory.Block, block.name() + " has a null instance");
            }
            return CommandIc2.func_175762_a((String[])args, options);
        }
        return null;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void func_71515_b(ICommandSender sender, String[] args) throws CommandException {
        if (args.length == 0) {
            throw new WrongUsageException(this.func_71518_a(sender), new Object[0]);
        }
        if (args.length == 2 && args[0].equals("uu-world-scan")) {
            this.cmdUuWorldScan(sender, args[1]);
            return;
        } else if (args[0].equals("debug")) {
            if (args.length == 2 && args[1].equals("dumpUuValues")) {
                this.cmdDumpUuValues(sender);
                return;
            } else if (args.length == 3 && args[1].equals("resolveIngredient")) {
                this.cmdDebugResolveIngredient(sender, args[2]);
                return;
            } else if (args.length == 4 && args[1].equals("dumpTextures")) {
                this.cmdDebugDumpTextures(sender, args[2], args[3]);
                return;
            } else {
                if (args.length != 2 || !args[1].equals("dumpLargeGrids")) throw new WrongUsageException(this.func_71518_a(sender), new Object[0]);
                this.dumpLargeGrids(sender);
            }
            return;
        } else if (args.length == 1 && args[0].equals("currentItem") && sender instanceof EntityPlayer) {
            EntityPlayer player = (EntityPlayer)sender;
            if (player.field_71071_by.func_70448_g() == null) {
                player.func_145747_a((IChatComponent)new ChatComponentText("null"));
                return;
            } else {
                player.func_145747_a((IChatComponent)new ChatComponentText("Current Item excluding amount: " + ConfigUtil.fromStack(player.field_71071_by.func_70448_g())));
                player.func_145747_a((IChatComponent)new ChatComponentText("Current Item including amount: " + ConfigUtil.fromStackWithAmount(player.field_71071_by.func_70448_g())));
            }
            return;
        } else if (args.length == 1 && args[0].equals("itemNameWithVariant") && sender instanceof EntityPlayer) {
            EntityPlayer player = (EntityPlayer)sender;
            ItemStack stack = player.field_71071_by.func_70448_g();
            if (stack == null) {
                player.func_145747_a((IChatComponent)new ChatComponentText("null"));
                return;
            } else if (!stack.func_77973_b().getClass().getCanonicalName().startsWith("ic2.core")) {
                player.func_145747_a((IChatComponent)new ChatComponentText("Not an IC2 Item."));
                return;
            } else {
                String name = Util.getName(stack.func_77973_b()).func_110623_a();
                String variant = null;
                if (stack.func_77973_b() instanceof IMultiItem) {
                    variant = ((IMultiItem)stack.func_77973_b()).getVariant(stack);
                } else if (stack.func_77973_b() instanceof ItemBlock && ((ItemBlock)stack.func_77973_b()).func_179223_d() instanceof IMultiBlock) {
                    variant = ((IMultiBlock)((ItemBlock)stack.func_77973_b()).func_179223_d()).getVariant(stack);
                }
                player.func_145747_a((IChatComponent)new ChatComponentText("Name: " + name + (variant == null ? "" : " Variant: " + variant)));
            }
            return;
        } else if ("setblock".equals(args[0])) {
            if (args.length <= 4) throw new WrongUsageException("/ic2 setblock <x> <y> <z> <type> [destroy|keep] [facing] [nbt]", new Object[0]);
            this.setBlocks(sender, CommandIc2.func_175757_a((ICommandSender)sender, (String[])args, (int)1, (boolean)false), args[4], Arrays.copyOfRange(args, 5, args.length));
            return;
        } else if ("fill".equals(args[0])) {
            if (args.length <= 7) throw new WrongUsageException("/ic2 fill <x1> <y1> <z1> <x2> <y2> <z2> <type> [destroy|keep|replace] [solid|hollow|outline] [facing] [nbt]", new Object[0]);
            this.fillBlocks(sender, CommandIc2.func_175757_a((ICommandSender)sender, (String[])args, (int)1, (boolean)false), CommandIc2.func_175757_a((ICommandSender)sender, (String[])args, (int)4, (boolean)false), args[7], Arrays.copyOfRange(args, 8, args.length));
            return;
        } else {
            sender.func_145747_a((IChatComponent)new ChatComponentText("Unknown Command."));
        }
    }

    private void cmdUuWorldScan(ICommandSender sender, String arg) throws CommandException {
        int areaCount;
        if (arg.equals("small")) {
            areaCount = 1024;
        } else if (arg.equals("medium")) {
            areaCount = 2048;
        } else if (arg.equals("large")) {
            areaCount = 4096;
        } else {
            throw new WrongUsageException(this.func_71518_a(sender), new Object[0]);
        }
        int time = areaCount / 1024 * 4;
        sender.func_145747_a((IChatComponent)new ChatComponentText("Starting world scan, this will take about " + time + " minutes with a powerful cpu."));
        sender.func_145747_a((IChatComponent)new ChatComponentText("The server will not respond while the calculations are running."));
        Object world = null;
        world = sender instanceof EntityPlayerMP ? ((EntityPlayerMP)sender).field_70170_p : DimensionManager.getWorld((int)0);
        if (world == null) {
            sender.func_145747_a((IChatComponent)new ChatComponentText("Can't determine the world to scan."));
            return;
        }
        int area = 50000;
        int range = 5;
        DropScan.start((World)world, area, areaCount, range);
    }

    private void cmdDumpUuValues(ICommandSender sender) {
        ArrayList<Map.Entry<ItemStack, Double>> list = new ArrayList<Map.Entry<ItemStack, Double>>();
        Iterator<Map.Entry<ItemStack, Double>> it = UuGraph.iterator();
        while (it.hasNext()) {
            list.add(it.next());
        }
        Collections.sort(list, new Comparator<Map.Entry<ItemStack, Double>>(){

            @Override
            public int compare(Map.Entry<ItemStack, Double> a, Map.Entry<ItemStack, Double> b) {
                return a.getKey().func_77973_b().func_77653_i(a.getKey()).compareTo(b.getKey().func_77973_b().func_77653_i(b.getKey()));
            }
        });
        sender.func_145747_a((IChatComponent)new ChatComponentText("UU Values:"));
        for (Map.Entry entry : list) {
            sender.func_145747_a((IChatComponent)new ChatComponentText(String.format("  %s: %s", ((ItemStack)entry.getKey()).func_77973_b().func_77653_i((ItemStack)entry.getKey()), entry.getValue())));
        }
        sender.func_145747_a((IChatComponent)new ChatComponentText("(check console for full list)"));
    }

    private void cmdDebugResolveIngredient(ICommandSender sender, String arg) {
        try {
            IRecipeInput input = ConfigUtil.asRecipeInput(arg);
            if (input == null) {
                sender.func_145747_a((IChatComponent)new ChatComponentText("No match"));
            } else {
                List<ItemStack> inputs = input.getInputs();
                sender.func_145747_a((IChatComponent)new ChatComponentText(inputs.size() + " matches:"));
                for (ItemStack stack : inputs) {
                    if (stack == null) {
                        sender.func_145747_a((IChatComponent)new ChatComponentText(" null"));
                        continue;
                    }
                    sender.func_145747_a((IChatComponent)new ChatComponentText(String.format(" %s (%s, od: %s, name: %s / %s)", StackUtil.toStringSafe(stack), Util.getName(stack.func_77973_b()), this.getOreDictNames(stack), stack.func_77977_a(), stack.func_82833_r())));
                }
            }
        }
        catch (Exception e) {
            sender.func_145747_a((IChatComponent)new ChatComponentText("Error: " + e));
        }
    }

    private String getOreDictNames(ItemStack stack) {
        String ret = "";
        for (int oreId : OreDictionary.getOreIDs((ItemStack)stack)) {
            if (!ret.isEmpty()) {
                ret = ret + ", ";
            }
            ret = ret + OreDictionary.getOreName((int)oreId);
        }
        return ret.isEmpty() ? "<none>" : ret;
    }

    private void cmdDebugDumpTextures(ICommandSender sender, String arg1, String arg2) {
        if (FMLCommonHandler.instance().getSide().isServer()) {
            sender.func_145747_a((IChatComponent)new ChatComponentText("Can't dump textures on the dedicated server."));
            return;
        }
        sender.func_145747_a((IChatComponent)new ChatComponentText("Dumping requested textures to sprites texture..."));
        Integer meta = null;
        int pos = arg1.indexOf(64);
        if (pos != -1) {
            meta = Integer.valueOf(arg1.substring(pos + 1));
            arg1 = arg1.substring(0, pos);
        }
        String regex = "^" + Pattern.quote(arg1).replace("*", "\\E.*\\Q") + "$";
        Pattern pattern = Pattern.compile(regex);
        IC2.tickHandler.requestSingleWorldTick(IC2.platform.getPlayerWorld(), new TextureDumper(pattern, Integer.valueOf(arg2), meta));
    }

    private void dumpLargeGrids(ICommandSender sender) {
        if (EnergyNetGateway.useEnergyNetLeg()) {
            sender.func_145747_a((IChatComponent)new ChatComponentText("Not supported for EnergyNetLeg."));
            return;
        }
        ArrayList<GridInfo> allGrids = new ArrayList<GridInfo>();
        for (WorldServer world : DimensionManager.getWorlds()) {
            EnergyNetLocal energyNet = WorldData.get((World)world).energyNet;
            allGrids.addAll(energyNet.getGridInfos());
        }
        Collections.sort(allGrids, new Comparator<GridInfo>(){

            @Override
            public int compare(GridInfo a, GridInfo b) {
                return b.complexNodeCount - a.complexNodeCount;
            }
        });
        sender.func_145747_a((IChatComponent)new ChatComponentText("found " + allGrids.size() + " grids overall"));
        for (int i = 0; i < 8 && i < allGrids.size(); ++i) {
            GridInfo grid = (GridInfo)allGrids.get(i);
            if (grid.nodeCount == 0) {
                sender.func_145747_a((IChatComponent)new ChatComponentText("grid " + grid.id + " is empty"));
                continue;
            }
            sender.func_145747_a((IChatComponent)new ChatComponentText(String.format("%d complex / %d total nodes in grid %d (%d/%d/%d - %d/%d/%d)", grid.complexNodeCount, grid.nodeCount, grid.id, grid.minX, grid.minY, grid.minZ, grid.maxX, grid.maxY, grid.maxZ)));
        }
    }

    private IBlockState getBlockFromName(String blockName) {
        IBlockState block = null;
        for (BlockName blockname : BlockName.values) {
            if (blockname.name().equals(blockName)) {
                block = blockname.getInstance().func_176223_P();
                break;
            }
            Object instance = blockname.getInstance();
            if (instance instanceof IMultiBlock) {
                block = ((IMultiBlock)instance).getStateFromName(blockName);
            } else if (instance != null) {
                IC2.log.info(LogCategory.Block, "Patch needed in getBlockFromName for " + instance.func_149732_F());
            } else {
                IC2.log.info(LogCategory.Block, blockname.name() + " has a null instance");
            }
            if (block != null) break;
        }
        return block;
    }

    private void setBlocks(ICommandSender sender, BlockPos position, String blockName, String ... args) throws CommandException {
        TileEntity tileEntity;
        IBlockState block = this.getBlockFromName(blockName);
        if (block == null) {
            throw new CommandException("Invalid type", new Object[0]);
        }
        World world = sender.func_130014_f_();
        if (!world.func_175667_e(position)) {
            throw new CommandException("commands.setblock.outOfWorld", new Object[0]);
        }
        EnumFacing facing = null;
        NBTTagCompound nbt = null;
        if (args.length > 0) {
            for (String arg : args) {
                if ("destory".equals(arg)) {
                    world.func_175655_b(position, true);
                    continue;
                }
                if ("keep".equals(arg) && !world.func_175623_d(position)) {
                    throw new CommandException("commands.setblock.noChange", new Object[0]);
                }
                if (!(block.func_177230_c() instanceof BlockTileEntity)) continue;
                if (arg.startsWith("{")) {
                    try {
                        nbt = JsonToNBT.func_180713_a((String)arg);
                        continue;
                    }
                    catch (NBTException e) {
                        throw new CommandException("commands.setblock.tagError", new Object[]{e.getMessage()});
                    }
                }
                EnumFacing testFace = EnumFacing.func_176739_a((String)arg);
                if (testFace == null) continue;
                facing = testFace;
            }
        }
        if ((tileEntity = world.func_175625_s(position)) != null) {
            if (tileEntity instanceof IInventory) {
                ((IInventory)tileEntity).func_174888_l();
            }
            world.func_180501_a(position, Blocks.field_150350_a.func_176223_P(), 4);
        }
        if (!world.func_180501_a(position, block, 2)) {
            throw new CommandException("commands.setblock.noChange", new Object[0]);
        }
        if (block.func_177230_c() instanceof BlockTileEntity) {
            TileEntityBlock te = TileEntityBlock.instantiate(TeBlock.get(blockName).getTeClass());
            world.func_175690_a(position, (TileEntity)te);
            Entity entity = sender.func_174793_f();
            te.onPlaced(null, facing == null && entity instanceof EntityLivingBase ? (EntityLivingBase)entity : null, facing == null ? EnumFacing.UP : facing.func_176734_d());
            world.func_175689_h(position);
            if (!world.field_72995_K) {
                IC2.network.get(true).sendInitialData(te);
            }
            if (nbt != null) {
                NBTTagCompound other = new NBTTagCompound();
                te.func_145841_b(other);
                other.func_179237_a(nbt);
                te.func_145839_a(other);
            }
        }
        world.func_175722_b(position, block.func_177230_c());
        sender.func_174794_a(CommandResultStats.Type.AFFECTED_BLOCKS, 1);
        CommandIc2.func_152373_a((ICommandSender)sender, (ICommand)this, (String)"commands.setblock.success", (Object[])new Object[0]);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void fillBlocks(ICommandSender sender, BlockPos start, BlockPos end, String blockName, String ... args) throws CommandException {
        BlockReplacement action;
        FillType shape;
        NBTTagCompound nbt;
        EnumFacing facing;
        boolean hasTileEntity;
        World world;
        int changedBlocks;
        BlockPos actualEnd;
        BlockPos actualStart;
        IBlockState block;
        block36: {
            int n;
            String[] stringArray;
            block = this.getBlockFromName(blockName);
            if (block == null) {
                throw new CommandException("Invalid type", new Object[0]);
            }
            actualStart = new BlockPos(Math.min(start.func_177958_n(), end.func_177958_n()), Math.min(start.func_177956_o(), end.func_177956_o()), Math.min(start.func_177952_p(), end.func_177952_p()));
            actualEnd = new BlockPos(Math.max(start.func_177958_n(), end.func_177958_n()), Math.max(start.func_177956_o(), end.func_177956_o()), Math.max(start.func_177952_p(), end.func_177952_p()));
            changedBlocks = (actualEnd.func_177958_n() - actualStart.func_177958_n() + 1) * (actualEnd.func_177956_o() - actualStart.func_177956_o() + 1) * (actualEnd.func_177952_p() - actualStart.func_177952_p() + 1);
            if (changedBlocks > 32768) {
                throw new CommandException("commands.fill.tooManyBlocks", new Object[]{changedBlocks, 32768});
            }
            if (actualStart.func_177956_o() < 0 || actualEnd.func_177956_o() > 255) {
                throw new CommandException("commands.fill.outOfWorld", new Object[0]);
            }
            world = sender.func_130014_f_();
            int z = actualStart.func_177952_p();
            while (true) {
                if (z < actualEnd.func_177952_p() + 16) {
                } else {
                    hasTileEntity = block.func_177230_c() instanceof BlockTileEntity;
                    facing = null;
                    nbt = null;
                    shape = FillType.SOLID;
                    action = BlockReplacement.REPLACE;
                    if (args.length > 0) {
                        stringArray = args;
                        n = stringArray.length;
                        break;
                    }
                    break block36;
                }
                for (int x = actualStart.func_177958_n(); x < actualEnd.func_177958_n() + 16; x += 16) {
                    if (world.func_175667_e(new BlockPos(x, actualEnd.func_177956_o() - actualStart.func_177956_o(), z))) continue;
                    throw new CommandException("commands.fill.outOfWorld", new Object[0]);
                }
                z += 16;
            }
            for (int i = 0; i < n; ++i) {
                String arg = stringArray[i];
                String upper = arg.toUpperCase(Locale.ENGLISH);
                if (FillType.OPTIONS.containsKey(upper)) {
                    shape = (FillType)((Object)FillType.OPTIONS.get(upper));
                } else if (BlockReplacement.OPTIONS.containsKey(upper)) {
                    action = (BlockReplacement)((Object)BlockReplacement.OPTIONS.get(upper));
                }
                if (!hasTileEntity) continue;
                if (arg.startsWith("{")) {
                    try {
                        nbt = JsonToNBT.func_180713_a((String)arg);
                        continue;
                    }
                    catch (NBTException e) {
                        throw new CommandException("commands.setblock.tagError", new Object[]{e.getMessage()});
                    }
                }
                EnumFacing testFace = EnumFacing.func_176739_a((String)arg);
                if (testFace == null) continue;
                facing = testFace;
            }
        }
        ArrayList<BlockPos> list = new ArrayList<BlockPos>(changedBlocks);
        changedBlocks = 0;
        int z = actualStart.func_177952_p();
        block15: while (true) {
            if (z > actualEnd.func_177952_p()) {
                for (BlockPos changedBlock : list) {
                    world.func_175722_b(changedBlock, world.func_180495_p(changedBlock).func_177230_c());
                }
                if (changedBlocks <= 0) {
                    throw new CommandException("commands.fill.failed", new Object[0]);
                }
                sender.func_174794_a(CommandResultStats.Type.AFFECTED_BLOCKS, changedBlocks);
                CommandIc2.func_152373_a((ICommandSender)sender, (ICommand)this, (String)"commands.fill.success", (Object[])new Object[]{changedBlocks});
                return;
            }
            int y = actualStart.func_177956_o();
            while (true) {
                if (y <= actualEnd.func_177956_o()) {
                } else {
                    ++z;
                    continue block15;
                }
                block18: for (int x = actualStart.func_177958_n(); x <= actualEnd.func_177958_n(); ++x) {
                    BlockPos position = new BlockPos(x, y, z);
                    switch (action) {
                        case REPLACE: {
                            break;
                        }
                        case DESTROY: {
                            world.func_175655_b(position, true);
                            break;
                        }
                        case KEEP: {
                            if (!world.func_175623_d(position)) continue block18;
                        }
                    }
                    switch (shape) {
                        case SOLID: {
                            break;
                        }
                        case HOLLOW: {
                            if (x == actualStart.func_177958_n() || x == actualEnd.func_177958_n() || y == actualStart.func_177956_o() || y == actualEnd.func_177956_o() || z == actualStart.func_177952_p() || z == actualEnd.func_177952_p()) break;
                            world.func_180501_a(position, Blocks.field_150350_a.func_176223_P(), 2);
                            list.add(position);
                            continue block18;
                        }
                        case OUTLINE: {
                            if (x != actualStart.func_177958_n() && x != actualEnd.func_177958_n() && y != actualStart.func_177956_o() && y != actualEnd.func_177956_o() && z != actualStart.func_177952_p() && z != actualEnd.func_177952_p()) continue block18;
                        }
                    }
                    TileEntity tileEntity = world.func_175625_s(position);
                    if (tileEntity != null) {
                        if (tileEntity instanceof IInventory) {
                            ((IInventory)tileEntity).func_174888_l();
                        }
                        world.func_180501_a(position, Blocks.field_180401_cv.func_176223_P(), 4);
                    }
                    if (!world.func_180501_a(position, block, 2)) continue;
                    list.add(position);
                    ++changedBlocks;
                    if (!hasTileEntity) continue;
                    TileEntityBlock te = TileEntityBlock.instantiate(TeBlock.get(blockName).getTeClass());
                    world.func_175690_a(position, (TileEntity)te);
                    Entity entity = sender.func_174793_f();
                    te.onPlaced(null, facing == null && entity instanceof EntityLivingBase ? (EntityLivingBase)entity : null, facing == null ? EnumFacing.UP : facing.func_176734_d());
                    world.func_175689_h(position);
                    if (!world.field_72995_K) {
                        IC2.network.get(true).sendInitialData(te);
                    }
                    if (nbt == null) continue;
                    NBTTagCompound other = new NBTTagCompound();
                    te.func_145841_b(other);
                    other.func_179237_a(nbt);
                    te.func_145839_a(other);
                }
                ++y;
            }
            break;
        }
    }

    public static class TextureDumper
    implements IWorldTickCallback {
        private final Pattern pattern;
        private final int size;
        private final Integer meta;

        TextureDumper(Pattern pattern, int size, Integer meta) {
            this.pattern = pattern;
            this.size = size;
            this.meta = meta;
        }

        @Override
        public void onTick(World world) {
            MinecraftForge.EVENT_BUS.register((Object)this);
        }

        @SubscribeEvent
        @SideOnly(value=Side.CLIENT)
        public void onRenderWorldLast(RenderWorldLastEvent event) {
            IC2.log.info(LogCategory.General, "Starting texture dump.");
            int count = 0;
            block2: for (Item item : GameData.getItemRegistry().typeSafeIterable()) {
                String regName = "" + Util.getName(item);
                if (!this.pattern.matcher(regName).matches()) continue;
                if (this.meta == null) {
                    HashSet<String> processedNames = new HashSet<String>();
                    for (int i = 0; i < Integer.MAX_VALUE; ++i) {
                        ItemStack stack;
                        block6: {
                            stack = new ItemStack(item, 1, i);
                            try {
                                String name = stack.func_77977_a();
                                if (name == null) continue block2;
                                if (!processedNames.add(name)) {
                                }
                                break block6;
                            }
                            catch (Exception e) {
                                IC2.log.info(LogCategory.General, e, "Exception for %s.", stack);
                            }
                            continue block2;
                        }
                        this.dump(stack, regName);
                        ++count;
                    }
                    continue;
                }
                this.dump(new ItemStack(item, 1, this.meta.intValue()), regName);
                ++count;
            }
            IC2.log.info(LogCategory.General, "Dumped %d sprites.", count);
            MinecraftForge.EVENT_BUS.unregister((Object)this);
        }

        @SideOnly(value=Side.CLIENT)
        void dump(ItemStack stack, String name) {
            Minecraft mc = Minecraft.func_71410_x();
            GL11.glClear((int)16640);
            GL11.glMatrixMode((int)5889);
            GL11.glPushMatrix();
            GL11.glLoadIdentity();
            GL11.glOrtho((double)0.0, (double)mc.field_71443_c, (double)mc.field_71440_d, (double)0.0, (double)1000.0, (double)3000.0);
            GL11.glMatrixMode((int)5888);
            GL11.glPushMatrix();
            GL11.glLoadIdentity();
            GL11.glTranslatef((float)0.0f, (float)0.0f, (float)-2000.0f);
            RenderHelper.func_74520_c();
            GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            GL11.glEnable((int)32826);
            OpenGlHelper.func_77475_a((int)OpenGlHelper.field_77476_b, (float)240.0f, (float)240.0f);
            float scale = (float)this.size / 16.0f;
            GL11.glScalef((float)scale, (float)scale, (float)scale);
            mc.func_175599_af().func_175042_a(stack, 0, 0);
            BufferedImage img = new BufferedImage(this.size, this.size, 2);
            if (OpenGlHelper.func_148822_b()) {
                int width = mc.func_147110_a().field_147622_a;
                int height = mc.func_147110_a().field_147620_b;
                IntBuffer buffer = BufferUtils.createIntBuffer((int)(width * height));
                int[] data = new int[width * height];
                GL11.glBindTexture((int)3553, (int)mc.func_147110_a().field_147617_g);
                GL11.glGetTexImage((int)3553, (int)0, (int)32993, (int)33639, (IntBuffer)buffer);
                buffer.get(data);
                int[] mirroredData = new int[data.length];
                for (int y = 0; y < height; ++y) {
                    System.arraycopy(data, y * width, mirroredData, (height - y - 1) * width, width);
                }
                img.setRGB(0, 0, this.size, this.size, mirroredData, 0, width);
            } else {
                IntBuffer buffer = BufferUtils.createIntBuffer((int)(this.size * this.size));
                int[] data = new int[this.size * this.size];
                GL11.glReadPixels((int)0, (int)0, (int)this.size, (int)this.size, (int)32993, (int)33639, (IntBuffer)buffer);
                buffer.get(data);
                img.setRGB(0, 0, this.size, this.size, data, 0, this.size);
            }
            try {
                File dir = new File(IC2.platform.getMinecraftDir(), "sprites");
                dir.mkdir();
                String modId = name.indexOf(58) >= 0 ? name.substring(0, name.indexOf(58)) : name;
                String fileName = "Sprite_" + modId + "_" + stack.func_82833_r() + "_" + this.size;
                fileName = fileName.replaceAll("[^\\w\\- ]+", "");
                ImageIO.write((RenderedImage)img, "png", new File(dir, fileName + ".png"));
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
            GL11.glPopMatrix();
            GL11.glMatrixMode((int)5889);
            GL11.glPopMatrix();
            GL11.glMatrixMode((int)5888);
        }
    }

    private static enum BlockReplacement {
        DESTROY,
        KEEP,
        REPLACE;

        private static final Map<String, BlockReplacement> OPTIONS;

        static {
            OPTIONS = new HashMap<String, BlockReplacement>(7);
            for (BlockReplacement type : BlockReplacement.values()) {
                OPTIONS.put(type.name(), type);
            }
        }
    }

    private static enum FillType {
        HOLLOW,
        OUTLINE,
        SOLID;

        private static final Map<String, FillType> OPTIONS;

        static {
            OPTIONS = new HashMap<String, FillType>(7);
            for (FillType type : FillType.values()) {
                OPTIONS.put(type.name(), type);
            }
        }
    }
}

