/*
 * Decompiled with CFR 0.152.
 */
package ic2.core.block.wiring;

import ic2.api.network.INetworkClientTileEntityEventListener;
import ic2.api.tile.IEnergyStorage;
import ic2.core.ContainerBase;
import ic2.core.IC2;
import ic2.core.IHasGui;
import ic2.core.block.TileEntityInventory;
import ic2.core.block.comp.Energy;
import ic2.core.block.comp.RedstoneEmitter;
import ic2.core.block.invslot.InvSlot;
import ic2.core.block.invslot.InvSlotCharge;
import ic2.core.block.invslot.InvSlotDischarge;
import ic2.core.block.wiring.ContainerElectricBlock;
import ic2.core.block.wiring.GuiElectricBlock;
import ic2.core.init.MainConfig;
import ic2.core.ref.TeBlock;
import ic2.core.util.ConfigUtil;
import ic2.core.util.StackUtil;
import java.util.EnumSet;
import java.util.List;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.StatCollector;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public abstract class TileEntityElectricBlock
extends TileEntityInventory
implements IHasGui,
INetworkClientTileEntityEventListener,
IEnergyStorage,
TeBlock.IAdditionalProvider {
    public boolean hasRedstone = false;
    protected double output;
    public byte redstoneMode = 0;
    public static byte redstoneModes = (byte)7;
    public final InvSlotCharge chargeSlot;
    public final InvSlotDischarge dischargeSlot;
    public final Energy energy;
    public final RedstoneEmitter rsEmitter;

    public TileEntityElectricBlock(int tier, int output, int maxStorage) {
        this.output = output;
        this.chargeSlot = new InvSlotCharge(this, tier);
        this.dischargeSlot = new InvSlotDischarge((TileEntityInventory)this, InvSlot.Access.IO, tier, InvSlot.InvSide.BOTTOM);
        this.energy = this.addComponent(new Energy(this, maxStorage, EnumSet.complementOf(EnumSet.of(EnumFacing.DOWN)), EnumSet.of(EnumFacing.DOWN), tier, tier, true).addManagedSlot(this.chargeSlot).addManagedSlot(this.dischargeSlot));
        this.rsEmitter = this.addComponent(new RedstoneEmitter(this));
    }

    @Override
    public void func_145839_a(NBTTagCompound nbt) {
        super.func_145839_a(nbt);
        this.energy.setDirections(EnumSet.complementOf(EnumSet.of(this.getFacing())), EnumSet.of(this.getFacing()));
        this.redstoneMode = nbt.func_74771_c("redstoneMode");
    }

    @Override
    public void func_145841_b(NBTTagCompound nbt) {
        super.func_145841_b(nbt);
        nbt.func_74774_a("redstoneMode", this.redstoneMode);
    }

    @Override
    protected void updateEntityServer() {
        super.updateEntityServer();
        if (this.redstoneMode == 5 || this.redstoneMode == 6) {
            this.hasRedstone = this.field_145850_b.func_175640_z(this.field_174879_c);
        }
        this.rsEmitter.setLevel(this.shouldEmitRedstone() ? 15 : 0);
    }

    public ContainerBase<? extends TileEntityElectricBlock> getGuiContainer(EntityPlayer player) {
        return new ContainerElectricBlock(player, this);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public GuiScreen getGui(EntityPlayer player, boolean isAdmin) {
        return new GuiElectricBlock(new ContainerElectricBlock(player, this));
    }

    @Override
    public void onGuiClosed(EntityPlayer player) {
    }

    @Override
    public void setFacing(EnumFacing facing) {
        super.setFacing(facing);
        this.energy.setDirections(EnumSet.complementOf(EnumSet.of(this.getFacing())), EnumSet.of(this.getFacing()));
    }

    protected boolean shouldEmitRedstone() {
        switch (this.redstoneMode) {
            case 1: {
                return this.energy.getEnergy() >= this.energy.getCapacity() - this.output * 20.0;
            }
            case 2: {
                return this.energy.getEnergy() > this.output && this.energy.getEnergy() < this.energy.getCapacity();
            }
            case 3: {
                return this.energy.getEnergy() > this.output || this.energy.getEnergy() < this.energy.getCapacity();
            }
            case 4: {
                return this.energy.getEnergy() < this.output;
            }
        }
        return false;
    }

    @Override
    public void onNetworkEvent(EntityPlayer player, int event) {
        this.redstoneMode = (byte)(this.redstoneMode + 1);
        if (this.redstoneMode >= redstoneModes) {
            this.redstoneMode = 0;
        }
        IC2.platform.messagePlayer(player, this.getRedstoneMode(), new Object[0]);
    }

    public String getRedstoneMode() {
        if (this.redstoneMode > 6 || this.redstoneMode < 0) {
            return "";
        }
        return StatCollector.func_74838_a((String)("ic2.EUStorage.gui.mod.redstone" + this.redstoneMode));
    }

    @Override
    protected int getComparatorInputOverride() {
        return this.energy.getComparatorValue();
    }

    @Override
    public void onPlaced(ItemStack stack, EntityLivingBase placer, EnumFacing facing) {
        super.onPlaced(stack, placer, facing);
        if (!this.field_145850_b.field_72995_K) {
            NBTTagCompound nbt = StackUtil.getOrCreateNbtData(stack);
            this.energy.addEnergy(nbt.func_74769_h("energy"));
        }
    }

    @Override
    protected ItemStack adjustDrop(ItemStack drop, boolean wrench) {
        drop = super.adjustDrop(drop, wrench);
        if (wrench || this.teBlock.defaultDrop == TeBlock.DefaultDrop.Self) {
            double retainedRatio = ConfigUtil.getDouble(MainConfig.get(), "balance/energyRetainedInStorageBlockDrops");
            double totalEnergy = this.energy.getEnergy();
            if (retainedRatio > 0.0 && totalEnergy > 0.0) {
                NBTTagCompound nbt = StackUtil.getOrCreateNbtData(drop);
                nbt.func_74780_a("energy", totalEnergy * retainedRatio);
            }
        }
        return drop;
    }

    @Override
    public int getOutput() {
        return (int)this.output;
    }

    @Override
    public double getOutputEnergyUnitsPerTick() {
        return this.output;
    }

    @Override
    public void setStored(int energy1) {
    }

    @Override
    public int addEnergy(int amount) {
        this.energy.addEnergy(amount);
        return amount;
    }

    @Override
    public int getStored() {
        return (int)this.energy.getEnergy();
    }

    @Override
    public int getCapacity() {
        return (int)this.energy.getCapacity();
    }

    @Override
    public boolean isTeleporterCompatible(EnumFacing side) {
        return true;
    }

    @Override
    public void addSubBlocks(ItemStack item, CreativeTabs tabs, List<ItemStack> list) {
        StackUtil.getOrCreateNbtData(item).func_74780_a("energy", (double)this.getCapacity());
        list.add(item);
    }
}

