/*
 * Decompiled with CFR 0.152.
 */
package ic2.core.block.machine.gui;

import com.google.common.collect.ImmutableSet;
import ic2.core.ChunkLoaderLogic;
import ic2.core.GuiIC2;
import ic2.core.IC2;
import ic2.core.block.TileEntityBlock;
import ic2.core.block.machine.container.ContainerChunkLoader;
import ic2.core.block.machine.tileentity.TileEntityChunkloader;
import ic2.core.gui.EnergyGauge;
import ic2.core.util.Ic2BlockPos;
import java.io.IOException;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.init.Blocks;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.BlockPos;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.ChunkCoordIntPair;
import net.minecraft.world.chunk.Chunk;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public class GuiChunkLoader
extends GuiIC2<ContainerChunkLoader> {
    private static final ResourceLocation background = new ResourceLocation("ic2", "textures/gui/GUIChunkLoader.png");

    public GuiChunkLoader(ContainerChunkLoader container) {
        super(container, 250);
        this.addElement(EnergyGauge.asBolt(12, 125, (TileEntityBlock)container.base));
    }

    @Override
    protected ResourceLocation getTexture() {
        return background;
    }

    @Override
    protected void func_146979_b(int mouseX, int mouseY) {
        ChunkCoordIntPair mainChunk = ChunkLoaderLogic.getChunkCoords(((TileEntityChunkloader)((ContainerChunkLoader)this.container).base).func_174877_v());
        ImmutableSet<ChunkCoordIntPair> loadedChunks = ((TileEntityChunkloader)((ContainerChunkLoader)this.container).base).getLoadedChunks();
        int amountLoadedChunks = 0;
        for (int i = -4; i <= 4; ++i) {
            for (int j = -4; j <= 4; ++j) {
                ChunkCoordIntPair currentChunk = new ChunkCoordIntPair(mainChunk.field_77276_a + i, mainChunk.field_77275_b + j);
                int xpos = -this.field_147003_i + 89 + 16 * i;
                int ypos = -this.field_147009_r + 80 + 16 * j;
                this.drawChunkAt(xpos, ypos, currentChunk);
                if (loadedChunks.contains(currentChunk)) {
                    this.drawColoredRect(xpos, ypos, 16, 16, 0x3000FF00);
                    ++amountLoadedChunks;
                    continue;
                }
                this.drawColoredRect(xpos, ypos, 16, 16, 0x30FF0000);
            }
        }
        GlStateManager.func_179141_d();
        this.field_146289_q.func_78279_b(amountLoadedChunks + " / " + ChunkLoaderLogic.getInstance().getMaxChunksPerTicket(), 8, 16, 15, 0x404040);
        super.func_146979_b(mouseX, mouseY);
    }

    private void drawChunkAt(int x, int y, ChunkCoordIntPair chunkPos) {
        Chunk chunk = ((TileEntityChunkloader)((ContainerChunkLoader)this.container).base).func_145831_w().func_72964_e(chunkPos.field_77276_a, chunkPos.field_77275_b);
        for (int i = 0; i < 16; ++i) {
            for (int j = 0; j < 16; ++j) {
                Ic2BlockPos pos = new Ic2BlockPos(i, 255, j);
                while (chunk.func_177428_a((BlockPos)pos) == Blocks.field_150350_a && pos.func_177956_o() > 0) {
                    pos.moveDown();
                }
                this.drawColoredRect(x + i, y + j, 1, 1, this.getColor(chunk.func_177435_g((BlockPos)pos)));
            }
        }
    }

    private int getColor(IBlockState state) {
        return state.func_177230_c().func_180659_g((IBlockState)state).field_76291_p | 0xFF000000;
    }

    @Override
    protected void func_73864_a(int mouseX, int mouseY, int mouseButton) throws IOException {
        if (mouseButton == 0) {
            ChunkCoordIntPair mainChunk = ChunkLoaderLogic.getChunkCoords(((TileEntityChunkloader)((ContainerChunkLoader)this.container).base).func_174877_v());
            for (int i = -4; i <= 4; ++i) {
                for (int j = -4; j <= 4; ++j) {
                    if (mouseX - this.field_147003_i <= 89 + 16 * i || mouseX - this.field_147003_i > 89 + 16 * i + 16 || mouseY - this.field_147009_r <= 80 + 16 * j || mouseY - this.field_147009_r > 80 + 16 * j + 16) continue;
                    this.changeChunk(new ChunkCoordIntPair(mainChunk.field_77276_a + i, mainChunk.field_77275_b + j));
                    return;
                }
            }
        }
        super.func_73864_a(mouseX, mouseY, mouseButton);
    }

    private void changeChunk(ChunkCoordIntPair chunk) {
        ChunkCoordIntPair mainChunk = ChunkLoaderLogic.getChunkCoords(((TileEntityChunkloader)((ContainerChunkLoader)this.container).base).func_174877_v());
        IC2.network.get(false).initiateClientTileEntityEvent((TileEntity)((ContainerChunkLoader)this.container).base, chunk.field_77276_a - mainChunk.field_77276_a + 8 & 0xF | (chunk.field_77275_b - mainChunk.field_77275_b + 8 & 0xF) << 4);
    }
}

