/*
 * Decompiled with CFR 0.152.
 */
package ic2.core.block;

import ic2.core.block.BlockBase;
import ic2.core.block.EntityStickyDynamite;
import ic2.core.block.MaterialIC2TNT;
import ic2.core.ref.BlockName;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.BlockTorch;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyBool;
import net.minecraft.block.state.BlockState;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.BlockPos;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumWorldBlockLayer;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.util.Vec3;
import net.minecraft.world.Explosion;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class BlockDynamite
extends BlockBase {
    public static final IProperty<Boolean> linked = PropertyBool.func_177716_a((String)"linked");

    public BlockDynamite() {
        super(BlockName.dynamite, MaterialIC2TNT.instance, null);
        this.func_180632_j(this.func_176223_P().func_177226_a(linked, (Comparable)Boolean.valueOf(false)).func_177226_a((IProperty)BlockTorch.field_176596_a, (Comparable)EnumFacing.UP));
        this.func_149675_a(true);
        this.func_149711_c(0.0f);
        this.func_149672_a(field_149779_h);
        this.func_149647_a(null);
    }

    protected BlockState func_180661_e() {
        return new BlockState((Block)this, new IProperty[]{BlockTorch.field_176596_a, linked});
    }

    public AxisAlignedBB func_180640_a(World world, BlockPos pos, IBlockState state) {
        return null;
    }

    public boolean func_149662_c() {
        return false;
    }

    public boolean func_149686_d() {
        return false;
    }

    @SideOnly(value=Side.CLIENT)
    public EnumWorldBlockLayer func_180664_k() {
        return EnumWorldBlockLayer.CUTOUT;
    }

    public boolean func_176196_c(World world, BlockPos pos) {
        for (EnumFacing dir : BlockTorch.field_176596_a.func_177700_c()) {
            if (!world.func_175677_d(pos.func_177972_a(dir.func_176734_d()), false)) continue;
            return true;
        }
        return false;
    }

    public IBlockState func_180642_a(World world, BlockPos pos, EnumFacing facing, float hitX, float hitY, float hitZ, int meta, EntityLivingBase placer) {
        if (facing == EnumFacing.DOWN || !world.func_175677_d(pos.func_177972_a(facing.func_176734_d()), false)) {
            for (EnumFacing facing2 : BlockTorch.field_176596_a.func_177700_c()) {
                if (!world.func_175677_d(pos.func_177972_a(facing2.func_176734_d()), false)) continue;
                facing = facing2;
                break;
            }
        }
        return this.func_176223_P().func_177226_a((IProperty)BlockTorch.field_176596_a, (Comparable)facing);
    }

    public int func_176201_c(IBlockState state) {
        return ((EnumFacing)state.func_177229_b((IProperty)BlockTorch.field_176596_a)).ordinal() << 1 | ((Boolean)state.func_177229_b(linked) != false ? 1 : 0);
    }

    public IBlockState func_176203_a(int meta) {
        return this.func_176223_P().func_177226_a(linked, (Comparable)Boolean.valueOf((meta & 1) != 0)).func_177226_a((IProperty)BlockTorch.field_176596_a, (Comparable)EnumFacing.field_82609_l[meta >> 1]);
    }

    public void func_180633_a(World world, BlockPos pos, IBlockState state, EntityLivingBase placer, ItemStack stack) {
        this.checkPlacement(world, pos, state);
    }

    public void func_180645_a(World world, BlockPos pos, IBlockState state, Random random) {
        this.checkPlacement(world, pos, state);
    }

    public void func_176204_a(World world, BlockPos pos, IBlockState state, Block neighborBlock) {
        this.checkPlacement(world, pos, state);
    }

    public int func_149745_a(Random random) {
        return 0;
    }

    public int func_180651_a(IBlockState state) {
        return 0;
    }

    public void func_180652_a(World world, BlockPos pos, Explosion explosion) {
        this.explode(world, pos, explosion != null ? explosion.func_94613_c() : null, true);
    }

    public boolean removedByPlayer(World world, BlockPos pos, EntityPlayer player, boolean willHarvest) {
        if (!world.field_72995_K) {
            this.explode(world, pos, (EntityLivingBase)player, false);
        }
        return false;
    }

    private void checkPlacement(World world, BlockPos pos, IBlockState state) {
        if (world.field_72995_K) {
            return;
        }
        if (world.func_175640_z(pos)) {
            this.explode(world, pos, null, false);
        } else if (!world.func_175677_d(pos.func_177972_a(((EnumFacing)state.func_177229_b((IProperty)BlockTorch.field_176596_a)).func_176734_d()), false)) {
            world.func_175698_g(pos);
            this.func_176226_b(world, pos, state, 0);
        }
    }

    private void explode(World world, BlockPos pos, EntityLivingBase player, boolean byExplosion) {
        world.func_175698_g(pos);
        EntityStickyDynamite entity = new EntityStickyDynamite(world, (double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o() + 0.5, (float)pos.func_177952_p() + 0.5f);
        entity.owner = player;
        entity.fuse = byExplosion ? 5 : 40;
        world.func_72838_d((Entity)entity);
        world.func_72956_a((Entity)entity, "game.tnt.primed", 1.0f, 1.0f);
    }

    public MovingObjectPosition func_180636_a(World worldIn, BlockPos pos, Vec3 start, Vec3 end) {
        EnumFacing enumfacing = (EnumFacing)worldIn.func_180495_p(pos).func_177229_b((IProperty)BlockTorch.field_176596_a);
        float f = 0.15f;
        if (enumfacing == EnumFacing.EAST) {
            this.func_149676_a(0.0f, 0.2f, 0.5f - f, f * 2.0f, 0.8f, 0.5f + f);
        } else if (enumfacing == EnumFacing.WEST) {
            this.func_149676_a(1.0f - f * 2.0f, 0.2f, 0.5f - f, 1.0f, 0.8f, 0.5f + f);
        } else if (enumfacing == EnumFacing.SOUTH) {
            this.func_149676_a(0.5f - f, 0.2f, 0.0f, 0.5f + f, 0.8f, f * 2.0f);
        } else if (enumfacing == EnumFacing.NORTH) {
            this.func_149676_a(0.5f - f, 0.2f, 1.0f - f * 2.0f, 0.5f + f, 0.8f, 1.0f);
        } else {
            f = 0.1f;
            this.func_149676_a(0.5f - f, 0.0f, 0.5f - f, 0.5f + f, 0.6f, 0.5f + f);
        }
        return super.func_180636_a(worldIn, pos, start, end);
    }
}

