/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.transport.utils;

import buildcraft.api.transport.PipeWire;
import buildcraft.transport.utils.BitSetCodec;
import buildcraft.transport.utils.ConnectionMatrix;
import io.netty.buffer.ByteBuf;
import java.util.BitSet;
import net.minecraft.util.EnumFacing;

public class WireMatrix {
    private final BitSet hasWire = new BitSet(PipeWire.values().length);
    private final BitSetCodec bitSetCodec = new BitSetCodec();
    private final ConnectionMatrix[] wires = new ConnectionMatrix[PipeWire.values().length];
    private final BitSet lit = new BitSet(PipeWire.values().length);
    private boolean dirty = false;

    public WireMatrix() {
        for (int i = 0; i < PipeWire.values().length; ++i) {
            this.wires[i] = new ConnectionMatrix();
        }
    }

    public boolean hasWire(PipeWire color) {
        return this.hasWire.get(color.ordinal());
    }

    public void setWire(PipeWire color, boolean value) {
        if (this.hasWire.get(color.ordinal()) != value) {
            this.hasWire.set(color.ordinal(), value);
            this.dirty = true;
        }
    }

    public boolean isWireLit(PipeWire wire) {
        return this.lit.get(wire.ordinal());
    }

    public void setWireLit(PipeWire wire, boolean lit) {
        if (this.lit.get(wire.ordinal()) != lit) {
            this.lit.set(wire.ordinal(), lit);
            this.dirty = true;
        }
    }

    public boolean isWireConnected(PipeWire color, EnumFacing direction) {
        return this.wires[color.ordinal()].isConnected(direction);
    }

    public void setWireConnected(PipeWire color, EnumFacing direction, boolean value) {
        this.wires[color.ordinal()].setConnected(direction, value);
    }

    public boolean isDirty() {
        boolean d = this.dirty;
        boolean[] dirtyArray = new boolean[5];
        dirtyArray[4] = this.dirty;
        for (int i = 0; i < PipeWire.values().length; ++i) {
            if (!this.wires[i].isDirty()) continue;
            dirtyArray[i] = true;
            d = true;
        }
        return d;
    }

    public void clean() {
        for (int i = 0; i < PipeWire.values().length; ++i) {
            this.wires[i].clean();
        }
        this.dirty = false;
    }

    public void writeData(ByteBuf data) {
        data.writeByte((int)this.bitSetCodec.encode(this.hasWire));
        data.writeByte((int)this.bitSetCodec.encode(this.lit));
        for (int i = 0; i < PipeWire.values().length; ++i) {
            this.wires[i].writeData(data);
        }
    }

    public void readData(ByteBuf data) {
        this.dirty |= this.bitSetCodec.decode(data.readByte(), this.hasWire);
        this.dirty |= this.bitSetCodec.decode(data.readByte(), this.lit);
        for (int i = 0; i < PipeWire.values().length; ++i) {
            this.wires[i].readData(data);
        }
    }
}

