/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.transport.utils;

import buildcraft.api.transport.pluggable.IConnectionMatrix;
import io.netty.buffer.ByteBuf;
import net.minecraft.util.EnumFacing;

public class ConnectionMatrix
implements IConnectionMatrix {
    private int mask = 0;
    private boolean dirty = false;

    @Override
    public boolean isConnected(EnumFacing direction) {
        return (this.mask & 1 << direction.ordinal()) != 0;
    }

    public void setConnected(EnumFacing direction, boolean value) {
        if (this.isConnected(direction) != value) {
            this.mask ^= 1 << direction.ordinal();
            this.dirty = true;
        }
    }

    public int getMask() {
        return this.mask;
    }

    public boolean isDirty() {
        return this.dirty;
    }

    public void clean() {
        this.dirty = false;
    }

    public void writeData(ByteBuf data) {
        data.writeByte(this.mask);
    }

    public void readData(ByteBuf data) {
        byte newMask = data.readByte();
        if (newMask != this.mask) {
            this.mask = newMask;
            this.dirty = true;
        }
    }
}

