/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.transport.stripes;

import buildcraft.api.transport.IStripesActivator;
import buildcraft.api.transport.IStripesHandler;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.BlockPos;
import net.minecraft.util.EnumFacing;
import net.minecraft.world.World;

public class StripesHandlerEntityInteract
implements IStripesHandler {
    @Override
    public IStripesHandler.StripesHandlerType getType() {
        return IStripesHandler.StripesHandlerType.ITEM_USE;
    }

    @Override
    public boolean shouldHandle(ItemStack stack) {
        return true;
    }

    @Override
    public boolean handle(World world, BlockPos pos, EnumFacing direction, ItemStack stack, EntityPlayer player, IStripesActivator activator) {
        AxisAlignedBB box = new AxisAlignedBB(pos, pos.func_177982_a(1, 1, 1));
        List entities = world.func_72839_b(null, box);
        if (entities.size() <= 0) {
            return false;
        }
        LinkedList<EntityLivingBase> livingEntities = new LinkedList<EntityLivingBase>();
        for (Entity entityObj : entities) {
            if (!(entityObj instanceof EntityLivingBase)) continue;
            livingEntities.add((EntityLivingBase)entityObj);
        }
        player.func_70062_b(0, stack);
        boolean successful = false;
        Collections.shuffle(livingEntities);
        while (livingEntities.size() > 0) {
            EntityLivingBase entity = (EntityLivingBase)livingEntities.remove(0);
            if (!player.func_70998_m((Entity)entity)) continue;
            successful = true;
            this.dropItemsExcept(stack, player, activator, direction);
        }
        if (stack.field_77994_a > 0 && successful) {
            activator.sendItem(stack, direction.func_176734_d());
        }
        player.func_70062_b(0, null);
        return successful;
    }

    private void dropItemsExcept(ItemStack stack, EntityPlayer player, IStripesActivator activator, EnumFacing direction) {
        for (int i = 0; i < player.field_71071_by.func_70302_i_(); ++i) {
            ItemStack invStack = player.field_71071_by.func_70301_a(i);
            if (invStack == null || invStack == stack) continue;
            player.field_71071_by.func_70299_a(i, null);
            activator.sendItem(invStack, direction.func_176734_d());
        }
    }
}

