/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.transport.stripes;

import buildcraft.api.transport.IStripesActivator;
import buildcraft.api.transport.IStripesHandler;
import buildcraft.core.lib.utils.BlockUtils;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.ItemBucket;
import net.minecraft.item.ItemStack;
import net.minecraft.util.BlockPos;
import net.minecraft.util.EnumFacing;
import net.minecraft.world.World;
import net.minecraftforge.fluids.FluidContainerRegistry;
import net.minecraftforge.fluids.FluidStack;

public class StripesHandlerBucket
implements IStripesHandler {
    private static final ItemStack emptyBucket = new ItemStack(Items.field_151133_ar, 1);

    private ItemStack getFilledBucket(FluidStack fluidStack, Block underblock) {
        if (underblock == Blocks.field_150353_l) {
            return new ItemStack(Items.field_151129_at, 1);
        }
        if (underblock == Blocks.field_150355_j) {
            return new ItemStack(Items.field_151131_as, 1);
        }
        return FluidContainerRegistry.fillFluidContainer((FluidStack)fluidStack, (ItemStack)emptyBucket);
    }

    @Override
    public IStripesHandler.StripesHandlerType getType() {
        return IStripesHandler.StripesHandlerType.ITEM_USE;
    }

    @Override
    public boolean shouldHandle(ItemStack stack) {
        return stack.func_77973_b() instanceof ItemBucket;
    }

    @Override
    public boolean handle(World world, BlockPos pos, EnumFacing direction, ItemStack stack, EntityPlayer player, IStripesActivator activator) {
        if (world.func_175623_d(pos)) {
            BlockPos place = new BlockPos(pos.func_177958_n(), direction.ordinal() < 2 ? pos.func_177956_o() : pos.func_177956_o() - 1, pos.func_177952_p());
            if (((ItemBucket)stack.func_77973_b()).func_180616_a(world, place)) {
                activator.sendItem(emptyBucket, direction.func_176734_d());
                --stack.field_77994_a;
                if (stack.field_77994_a > 0) {
                    activator.sendItem(stack, direction.func_176734_d());
                }
                return true;
            }
        }
        if (!FluidContainerRegistry.isEmptyContainer((ItemStack)stack)) {
            activator.sendItem(stack, direction.func_176734_d());
            return true;
        }
        IBlockState targetBlock = world.func_180495_p(pos);
        FluidStack fluidStack = BlockUtils.drainBlock(targetBlock, world, pos, true);
        if (fluidStack == null) {
            targetBlock = world.func_180495_p(pos.func_177977_b());
            fluidStack = BlockUtils.drainBlock(targetBlock, world, pos.func_177977_b(), true);
        }
        ItemStack filledBucket = this.getFilledBucket(fluidStack, targetBlock.func_177230_c());
        if (fluidStack == null || filledBucket == null) {
            activator.sendItem(stack, direction.func_176734_d());
            return true;
        }
        activator.sendItem(filledBucket, direction.func_176734_d());
        --stack.field_77994_a;
        if (stack.field_77994_a > 0) {
            activator.sendItem(stack, direction.func_176734_d());
        }
        return true;
    }
}

