/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.transport.statements;

import buildcraft.api.statements.IStatement;
import buildcraft.api.statements.IStatementContainer;
import buildcraft.api.statements.IStatementParameter;
import buildcraft.api.statements.StatementMouseClick;
import buildcraft.api.transport.PipeWire;
import buildcraft.core.lib.utils.BCStringUtils;
import buildcraft.transport.Gate;
import java.util.Locale;
import java.util.Objects;
import javax.annotation.Nullable;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.event.TextureStitchEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class ActionParameterSignal
implements IStatementParameter {
    @SideOnly(value=Side.CLIENT)
    private static TextureAtlasSprite[] icons;
    @Nullable
    private PipeWire color = null;

    @Nullable
    public PipeWire getColor() {
        return this.color;
    }

    @Override
    public TextureAtlasSprite getIcon() {
        PipeWire colour = this.getColor();
        if (colour == null) {
            return null;
        }
        return icons[colour.ordinal()];
    }

    @Override
    public void onClick(IStatementContainer source, IStatement stmt, ItemStack stack, StatementMouseClick mouse) {
        PipeWire colour;
        int maxColor = 4;
        if (source instanceof Gate) {
            maxColor = ((Gate)source).material.maxWireColor;
        }
        if ((colour = this.getColor()) == null) {
            colour = mouse.getButton() == 0 ? PipeWire.RED : PipeWire.values()[maxColor - 1];
        } else if (colour == (mouse.getButton() == 0 ? PipeWire.values()[maxColor - 1] : PipeWire.RED)) {
            colour = null;
        } else {
            while ((colour = PipeWire.values()[(mouse.getButton() == 0 ? colour.ordinal() + 1 : colour.ordinal() - 1) & 3]).ordinal() >= maxColor) {
            }
        }
        this.color = colour;
    }

    @Override
    public void writeToNBT(NBTTagCompound nbt) {
        PipeWire colour = this.getColor();
        if (colour != null) {
            nbt.func_74774_a("color", (byte)colour.ordinal());
        }
    }

    @Override
    public void readFromNBT(NBTTagCompound nbt) {
        if (nbt.func_74764_b("color")) {
            this.color = PipeWire.values()[nbt.func_74771_c("color")];
        }
    }

    public boolean equals(Object object) {
        if (object instanceof ActionParameterSignal) {
            ActionParameterSignal param = (ActionParameterSignal)object;
            return param.getColor() == this.getColor();
        }
        return false;
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.getColor()});
    }

    @Override
    public String getDescription() {
        PipeWire colour = this.getColor();
        if (colour == null) {
            return null;
        }
        String format = BCStringUtils.localize("gate.action.pipe.wire");
        Object[] args = new Object[]{BCStringUtils.localize("color." + colour.name().toLowerCase(Locale.ENGLISH))};
        return String.format(format, args);
    }

    @Override
    public String getUniqueTag() {
        return "buildcraft:pipeWireAction";
    }

    public static void registerIcons(TextureStitchEvent.Pre event) {
        icons = new TextureAtlasSprite[4];
        ActionParameterSignal.icons[0] = ActionParameterSignal.getOrRegister(event.map, "buildcrafttransport:triggers/trigger_pipesignal_red_active");
        ActionParameterSignal.icons[1] = ActionParameterSignal.getOrRegister(event.map, "buildcrafttransport:triggers/trigger_pipesignal_blue_active");
        ActionParameterSignal.icons[2] = ActionParameterSignal.getOrRegister(event.map, "buildcrafttransport:triggers/trigger_pipesignal_green_active");
        ActionParameterSignal.icons[3] = ActionParameterSignal.getOrRegister(event.map, "buildcrafttransport:triggers/trigger_pipesignal_yellow_active");
    }

    private static TextureAtlasSprite getOrRegister(TextureMap map, String location) {
        TextureAtlasSprite sprite = map.getTextureExtry(location);
        if (sprite == null) {
            sprite = map.func_174942_a(new ResourceLocation(location));
        }
        return sprite;
    }

    @Override
    public IStatementParameter rotateLeft() {
        return this;
    }

    @Override
    public ItemStack getItemStack() {
        return null;
    }
}

