/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.transport.pluggable;

import buildcraft.BuildCraftTransport;
import buildcraft.api.transport.IPipeTile;
import buildcraft.api.transport.pluggable.PipePluggable;
import buildcraft.api.transport.pluggable.PluggableModelKey;
import buildcraft.core.lib.utils.MatrixTranformations;
import buildcraft.transport.client.model.ModelKeyPowerAdapter;
import cofh.api.energy.IEnergyHandler;
import cofh.api.energy.IEnergyReceiver;
import io.netty.buffer.ByteBuf;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumWorldBlockLayer;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class PowerAdapterPluggable
extends PipePluggable
implements IEnergyReceiver {
    private static final int MAX_POWER = 40;
    private IPipeTile container;

    @Override
    public void validate(IPipeTile pipe, EnumFacing direction) {
        this.container = pipe;
    }

    @Override
    public void invalidate() {
        this.container = null;
    }

    @Override
    public void writeToNBT(NBTTagCompound nbt) {
    }

    @Override
    public void readFromNBT(NBTTagCompound nbt) {
    }

    @Override
    public ItemStack[] getDropItems(IPipeTile pipe) {
        return new ItemStack[]{new ItemStack(BuildCraftTransport.powerAdapterItem)};
    }

    @Override
    public boolean isBlocking(IPipeTile pipe, EnumFacing direction) {
        return true;
    }

    @Override
    public AxisAlignedBB getBoundingBox(EnumFacing side) {
        float[][] bounds = new float[3][2];
        bounds[0][0] = 0.1875f;
        bounds[0][1] = 0.8125f;
        bounds[1][0] = 0.0f;
        bounds[1][1] = 0.251f;
        bounds[2][0] = 0.1875f;
        bounds[2][1] = 0.8125f;
        MatrixTranformations.transform(bounds, side);
        return new AxisAlignedBB((double)bounds[0][0], (double)bounds[1][0], (double)bounds[2][0], (double)bounds[0][1], (double)bounds[1][1], (double)bounds[2][1]);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public PluggableModelKey<?> getModelRenderKey(EnumWorldBlockLayer layer, EnumFacing side) {
        if (layer == EnumWorldBlockLayer.CUTOUT) {
            return new ModelKeyPowerAdapter(side);
        }
        return null;
    }

    @Override
    public void writeData(ByteBuf data) {
    }

    @Override
    public void readData(ByteBuf data) {
    }

    @Override
    public int receiveEnergy(EnumFacing from, int maxReceive, boolean simulate) {
        int maxR = Math.min(40, maxReceive);
        if (this.container != null && this.container.getPipe() instanceof IEnergyReceiver) {
            int energyCanReceive = ((IEnergyReceiver)((Object)this.container.getPipe())).receiveEnergy(from, maxR, true);
            if (!simulate) {
                return ((IEnergyReceiver)((Object)this.container.getPipe())).receiveEnergy(from, energyCanReceive, false);
            }
            return energyCanReceive;
        }
        return 0;
    }

    @Override
    public int getEnergyStored(EnumFacing from) {
        if (this.container.getPipe() instanceof IEnergyHandler) {
            return ((IEnergyHandler)((Object)this.container.getPipe())).getEnergyStored(from);
        }
        return 0;
    }

    @Override
    public int getMaxEnergyStored(EnumFacing from) {
        if (this.container.getPipe() instanceof IEnergyHandler) {
            return ((IEnergyHandler)((Object)this.container.getPipe())).getMaxEnergyStored(from);
        }
        return 0;
    }

    @Override
    public boolean canConnectEnergy(EnumFacing from) {
        return true;
    }

    @Override
    public boolean requiresRenderUpdate(PipePluggable o) {
        return false;
    }
}

