/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.transport.pipes.bc8;

import buildcraft.api.transport.pipe_bc8.BCPipeEventHandler;
import buildcraft.api.transport.pipe_bc8.EnumContentsJourneyPart;
import buildcraft.api.transport.pipe_bc8.IConnection_BC8;
import buildcraft.api.transport.pipe_bc8.IPipeContents;
import buildcraft.api.transport.pipe_bc8.IPipeContentsEditable;
import buildcraft.api.transport.pipe_bc8.IPipeListener;
import buildcraft.api.transport.pipe_bc8.IPipeListenerFactory;
import buildcraft.api.transport.pipe_bc8.IPipePropertyProvider;
import buildcraft.api.transport.pipe_bc8.IPipe_BC8;
import buildcraft.api.transport.pipe_bc8.PipeAPI_BC8;
import buildcraft.api.transport.pipe_bc8.event_bc8.IPipeEventContents_BC8;
import buildcraft.api.transport.pipe_bc8.event_bc8.IPipeEvent_BC8;
import buildcraft.core.lib.inventory.StackHelper;
import buildcraft.transport.pipes.bc8.PipeContentsEditableItem;
import io.netty.buffer.ByteBuf;
import java.util.Set;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.Vec3;

public class TravellingItem_BC8
implements IPipeListener {
    private final IPipeContentsEditable.IPipeContentsEditableItem item;
    private final IPipe_BC8 pipe;
    private long tickStarted;
    private long tickFinished;

    public TravellingItem_BC8(IPipe_BC8 pipe, IPipeContentsEditable.IPipeContentsEditableItem item, long now, long reachDest) {
        if (pipe == null) {
            throw new NullPointerException("pipe");
        }
        if (item == null) {
            throw new NullPointerException("item");
        }
        this.pipe = pipe;
        this.item = item;
        this.tickStarted = now;
        this.tickFinished = reachDest;
    }

    public double getWayThrough(long now) {
        long diff = this.tickFinished - this.tickStarted;
        long nowDiff = now - this.tickStarted;
        return (double)nowDiff / (double)diff;
    }

    public void genTimings(long now, double distance) {
        this.tickStarted = now;
        double time = distance / this.item.getSpeed();
        time = Math.ceil(time);
        this.tickFinished = now + (long)time;
    }

    public Vec3 interpolatePosition(Vec3 start, Vec3 end, long tick, float partialTicks) {
        long diff = this.tickFinished - this.tickStarted;
        long nowDiff = tick - this.tickStarted;
        double sinceStart = (float)nowDiff + partialTicks;
        double interpMul = sinceStart / (double)diff;
        double oneMinus = 1.0 - interpMul;
        if (interpMul <= 0.0) {
            return start;
        }
        if (interpMul >= 1.0) {
            return end;
        }
        double x = oneMinus * start.field_72450_a + interpMul * end.field_72450_a;
        double y = oneMinus * start.field_72448_b + interpMul * end.field_72448_b;
        double z = oneMinus * start.field_72449_c + interpMul * end.field_72449_c;
        return new Vec3(x, y, z);
    }

    public boolean canBeGroupedWith(IPipeContents.IPipeContentsItem other) {
        if (this.item.getDirection() != other.getDirection()) {
            return false;
        }
        if (this.item.getJourneyPart() != other.getJourneyPart()) {
            return false;
        }
        if (!StackHelper.canStacksMerge(this.item.cloneItemStack(), other.cloneItemStack())) {
            return false;
        }
        Set<IPipePropertyProvider.IPipeProperty<?>> thisProperties = this.item.getProperties().getPropertySet();
        Set<IPipePropertyProvider.IPipeProperty<?>> otherProperties = other.getProperties().getPropertySet();
        if (thisProperties.size() != otherProperties.size()) {
            return false;
        }
        for (IPipePropertyProvider.IPipeProperty<?> property : thisProperties) {
            Object otherValue;
            if (!otherProperties.contains(property)) {
                return false;
            }
            Object thisValue = this.item.getProperties().getValue(property);
            if (thisValue.equals(otherValue = other.getProperties().getValue(property))) continue;
            return false;
        }
        return true;
    }

    public boolean tryEncompass(IPipeContentsEditable.IPipeContentsEditableItem other) {
        if (!this.canBeGroupedWith(other)) {
            return false;
        }
        ItemStack thisStack = this.item.cloneItemStack();
        ItemStack otherStack = other.cloneItemStack();
        int merged = StackHelper.mergeStacks(otherStack, thisStack, true);
        if (merged == otherStack.field_77994_a) {
            otherStack.field_77994_a = 0;
            this.item.setStack(thisStack);
            other.setStack(otherStack);
            return true;
        }
        return false;
    }

    @BCPipeEventHandler
    public void itemInsertion(IPipeEventContents_BC8.Enter enter) {
        if (enter.hasBeenHandled()) {
            return;
        }
        if (enter.getContents() instanceof IPipeContentsEditable.IPipeContentsEditableItem) {
            int stacks = enter.getPipe().getProperties().getValue(PipeAPI_BC8.STACK_COUNT);
            if (stacks < 64) {
                return;
            }
            IPipeContentsEditable.IPipeContentsEditableItem item = (IPipeContentsEditable.IPipeContentsEditableItem)enter.getContents();
            long now = enter.getPipe().getWorld().func_82737_E();
            double dist = this.getWayThrough(now);
            if (dist > 0.25) {
                return;
            }
            if (this.tryEncompass(item)) {
                enter.handle();
            }
        }
    }

    @BCPipeEventHandler
    public void tick(IPipeEvent_BC8.Tick tick) {
        if (this.item.getProperties().getValue(PipeAPI_BC8.ITEM_PAUSED).booleanValue()) {
            ++this.tickStarted;
            ++this.tickFinished;
            return;
        }
        if (tick instanceof IPipeEvent_BC8.Tick.Client) {
            return;
        }
        EnumContentsJourneyPart direction = this.item.getJourneyPart();
        if (direction == EnumContentsJourneyPart.JUST_ENTERED) {
            double normalizedSpeed = this.item.getSpeed() * 20.0;
            IPipeEvent_BC8 changeSpeed = null;
            this.pipe.fireEvent(changeSpeed);
            this.item.setSpeed(normalizedSpeed / 20.0);
            double distance = 0.25;
            IConnection_BC8 connection = this.pipe.getConnections().get(this.item.getDirection().func_176734_d());
            if (connection != null) {
                distance += connection.getLength();
            }
            this.genTimings(this.pipe.getWorld().func_82737_E(), distance);
            this.pipe.sendClientUpdate(this);
            return;
        }
        if (tick.getCurrentTick() < this.tickFinished) {
            return;
        }
        if (direction == EnumContentsJourneyPart.TO_CENTER) {
            // empty if block
        }
    }

    @BCPipeEventHandler
    public <T> void queryProperty(IPipeEvent_BC8.PropertyQuery<T> property) {
        if (property.getProperty() == PipeAPI_BC8.ITEM_COUNT) {
            IPipeEvent_BC8.PropertyQuery<Integer> event = property;
            int current = (Integer)event.getValue();
            event.setValue(current += this.item.cloneItemStack().field_77994_a);
        } else if (property.getProperty() == PipeAPI_BC8.STACK_COUNT) {
            IPipeEvent_BC8.PropertyQuery<Integer> event = property;
            if (this.item.cloneItemStack().field_77994_a > 0) {
                event.setValue((Integer)event.getValue() + 1);
            }
        }
    }

    @Override
    public TravellingItem_BC8 readFromNBT(NBTBase nbt) {
        NBTTagCompound tag = (NBTTagCompound)nbt;
        IPipeContentsEditable.IPipeContentsEditableItem item = this.item.readFromNBT((NBTBase)tag.func_74775_l("item"));
        long started = tag.func_74763_f("tickStarted");
        long finished = tag.func_74763_f("tickFinished");
        return new TravellingItem_BC8(this.pipe, item, started, finished);
    }

    public NBTTagCompound writeToNBT() {
        NBTTagCompound nbt = new NBTTagCompound();
        nbt.func_74782_a("item", this.item.writeToNBT());
        nbt.func_74772_a("tickStarted", this.tickStarted);
        nbt.func_74772_a("tickFinished", this.tickFinished);
        return nbt;
    }

    @Override
    public TravellingItem_BC8 readFromByteBuf(ByteBuf buf) {
        IPipeContentsEditable.IPipeContentsEditableItem item = this.item.readFromByteBuf(buf);
        long now = this.pipe.getWorld().func_82737_E();
        long started = now + buf.readLong();
        long finished = now + buf.readLong();
        return new TravellingItem_BC8(this.pipe, item, started, finished);
    }

    @Override
    public void writeToByteBuf(ByteBuf buf) {
        this.item.writeToByteBuf(buf);
        long now = this.pipe.getWorld().func_82737_E();
        buf.writeShort((int)((short)(this.tickStarted - now)));
        buf.writeShort((int)((short)(this.tickFinished - now)));
    }

    public static enum Factory implements IPipeListenerFactory
    {
        INSTANCE;


        @Override
        public IPipeListener createNewListener(IPipe_BC8 pipe) {
            return new TravellingItem_BC8(pipe, new PipeContentsEditableItem(null, null, null), 0L, 0L);
        }
    }
}

