/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.transport.pipes.bc8;

import buildcraft.api.transport.pipe_bc8.BCPipeEventHandler;
import buildcraft.api.transport.pipe_bc8.EnumContentsJourneyPart;
import buildcraft.api.transport.pipe_bc8.IPipeContents;
import buildcraft.api.transport.pipe_bc8.IPipeContentsEditable;
import buildcraft.api.transport.pipe_bc8.IPipeListener;
import buildcraft.api.transport.pipe_bc8.IPipe_BC8;
import buildcraft.api.transport.pipe_bc8.PipeAPI_BC8;
import buildcraft.api.transport.pipe_bc8.event_bc8.IPipeEventConnection_BC8;
import buildcraft.api.transport.pipe_bc8.event_bc8.IPipeEventContents_BC8;
import buildcraft.transport.pipes.bc8.TravellingItem_BC8;
import io.netty.buffer.ByteBuf;
import net.minecraft.nbt.NBTBase;

public class PipeTransportItem_BC8
implements IPipeListener {
    public static final int MAX_PIPE_STACKS = 64;
    public static final int MAX_PIPE_ITEMS = 1024;
    public static final double SPEED_NORMALIZER = 20.0;
    public final IPipe_BC8 pipe;

    public PipeTransportItem_BC8(IPipe_BC8 pipe) {
        this.pipe = pipe;
    }

    public void attemptInsertion(IPipeEventContents_BC8.AttemptEnter attemptEnter) {
        boolean isItem = attemptEnter.getContents() instanceof IPipeContents.IPipeContentsItem;
        if (!isItem) {
            // empty if block
        }
    }

    @BCPipeEventHandler
    public void attemptConnection(IPipeEventConnection_BC8.AttemptCreate event) {
        if (event.getConnection().getInserter().acceptsItems()) {
            event.couldAccept();
        } else if (event.getConnection().getExtractor().givesItems()) {
            event.couldAccept();
        }
    }

    @BCPipeEventHandler
    public void itemInsertion(IPipeEventContents_BC8.Enter enter) {
        if (enter.hasBeenHandled()) {
            return;
        }
        int stacks = enter.getPipe().getProperties().getValue(PipeAPI_BC8.STACK_COUNT);
        if (stacks >= 64) {
            return;
        }
        IPipeContentsEditable.IPipeContentsEditableItem item = (IPipeContentsEditable.IPipeContentsEditableItem)enter.getContents();
        item.setJourneyPart(EnumContentsJourneyPart.JUST_ENTERED);
        item.setDirection(enter.getFrom().func_176734_d());
        long now = this.pipe.getWorld().func_82737_E();
        TravellingItem_BC8 travellingItem = new TravellingItem_BC8(this.pipe, item, now, now);
        if (this.pipe.addEventListener(travellingItem)) {
            enter.handle();
        }
    }

    @Override
    public PipeTransportItem_BC8 readFromNBT(NBTBase nbt) {
        return this;
    }

    @Override
    public NBTBase writeToNBT() {
        return null;
    }

    @Override
    public PipeTransportItem_BC8 readFromByteBuf(ByteBuf buf) {
        return this;
    }

    @Override
    public void writeToByteBuf(ByteBuf buf) {
    }
}

