/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.transport.pipes;

import buildcraft.BuildCraftCore;
import buildcraft.BuildCraftTransport;
import buildcraft.api.core.IIconProvider;
import buildcraft.api.properties.BuildCraftProperties;
import buildcraft.api.statements.IActionInternal;
import buildcraft.api.statements.StatementSlot;
import buildcraft.api.tools.IToolWrench;
import buildcraft.core.PowerMode;
import buildcraft.core.lib.utils.BCStringUtils;
import buildcraft.transport.Pipe;
import buildcraft.transport.PipeIconProvider;
import buildcraft.transport.PipeTransportPower;
import buildcraft.transport.statements.ActionPowerLimiter;
import java.util.Collection;
import java.util.LinkedList;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.util.ChatComponentTranslation;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.IChatComponent;
import net.minecraftforge.common.util.FakePlayer;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class PipePowerIron
extends Pipe<PipeTransportPower> {
    public PipePowerIron(Item item) {
        super(new PipeTransportPower(), item);
        ((PipeTransportPower)this.transport).initFromPipe(this.getClass());
    }

    @Override
    public int getIconIndex(EnumFacing direction) {
        if (this.container == null) {
            return PipeIconProvider.TYPE.PipePowerIronM128.ordinal();
        }
        return PipeIconProvider.TYPE.PipePowerIronM2.ordinal() + this.container.func_145832_p();
    }

    @Override
    public boolean blockActivated(EntityPlayer player, EnumFacing direction) {
        Item equipped;
        Item item = equipped = player.func_71045_bC() != null ? player.func_71045_bC().func_77973_b() : null;
        if (equipped instanceof IToolWrench && ((IToolWrench)equipped).canWrench(player, this.container.func_174877_v())) {
            if (player.func_70093_af()) {
                this.setMode(this.getMode().getPrevious());
            } else {
                this.setMode(this.getMode().getNext());
            }
            if (this.getWorld().field_72995_K && !(player instanceof FakePlayer)) {
                if (BuildCraftCore.hidePowerNumbers) {
                    player.func_145747_a((IChatComponent)new ChatComponentTranslation("chat.pipe.power.iron.mode.numberless", new Object[]{BCStringUtils.localize("chat.pipe.power.iron.level." + this.getMode().maxPower)}));
                } else {
                    player.func_145747_a((IChatComponent)new ChatComponentTranslation("chat.pipe.power.iron.mode", new Object[]{this.getMode().maxPower}));
                }
            }
            ((IToolWrench)equipped).wrenchUsed(player, this.container.func_174877_v());
            return true;
        }
        return false;
    }

    @Override
    public void updateEntity() {
        super.updateEntity();
        ((PipeTransportPower)this.transport).maxPower = this.getMode().maxPower;
    }

    public PowerMode getMode() {
        return PowerMode.fromId(this.container.func_145832_p());
    }

    public void setMode(PowerMode mode) {
        IBlockState state = this.container.func_145831_w().func_180495_p(this.container.func_174877_v());
        if (mode.ordinal() != ((Integer)state.func_177229_b(BuildCraftProperties.GENERIC_PIPE_DATA)).intValue()) {
            this.container.func_145831_w().func_175656_a(this.container.func_174877_v(), state.func_177226_a(BuildCraftProperties.GENERIC_PIPE_DATA, (Comparable)Integer.valueOf(mode.ordinal())));
            this.container.scheduleRenderUpdate();
        }
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public IIconProvider getIconProvider() {
        return BuildCraftTransport.instance.pipeIconProvider;
    }

    @Override
    protected void actionsActivated(Collection<StatementSlot> actions) {
        super.actionsActivated(actions);
        for (StatementSlot action : actions) {
            if (!(action.statement instanceof ActionPowerLimiter)) continue;
            this.setMode(((ActionPowerLimiter)action.statement).limit);
            break;
        }
    }

    @Override
    public LinkedList<IActionInternal> getActions() {
        LinkedList<IActionInternal> action = super.getActions();
        for (PowerMode mode : PowerMode.VALUES) {
            action.add(BuildCraftTransport.actionPowerLimiter[mode.ordinal()]);
        }
        return action;
    }
}

