/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.transport.pipes;

import buildcraft.api.core.EnumPipePart;
import buildcraft.api.tools.IToolWrench;
import buildcraft.core.lib.TileBuffer;
import buildcraft.transport.BlockGenericPipe;
import buildcraft.transport.Pipe;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;

public abstract class PipeLogicWood {
    protected final Pipe<?> pipe;

    public PipeLogicWood(Pipe<?> pipe) {
        this.pipe = pipe;
    }

    private void switchSource() {
        int meta = this.pipe.container.func_145832_p();
        EnumPipePart oldFacing = EnumPipePart.fromMeta(meta);
        EnumPipePart newFacing = oldFacing.next();
        if (oldFacing == EnumPipePart.CENTER) {
            oldFacing = oldFacing.next();
        }
        boolean first = true;
        while (oldFacing != newFacing || first) {
            first = false;
            if (this.setSource(newFacing)) {
                return;
            }
            newFacing = newFacing.next();
        }
        this.setSource(EnumPipePart.CENTER);
    }

    private boolean setSource(EnumPipePart newFacing) {
        if (newFacing == EnumPipePart.CENTER || this.isValidFacing(newFacing.face)) {
            int meta = this.pipe.container.func_145832_p();
            if (newFacing.ordinal() != meta) {
                IBlockState state = this.pipe.container.func_145831_w().func_180495_p(this.pipe.container.func_174877_v());
                state = state.func_177226_a((IProperty)BlockGenericPipe.GENERIC_PIPE_DATA, (Comparable)Integer.valueOf(newFacing.ordinal()));
                this.pipe.container.func_145831_w().func_175656_a(this.pipe.container.func_174877_v(), state);
                this.pipe.container.scheduleRenderUpdate();
            }
            return true;
        }
        return false;
    }

    private void switchSourceIfNeeded() {
        int meta = this.pipe.container.func_145832_p();
        if (meta > 5) {
            this.switchSource();
        } else {
            EnumFacing facing = EnumFacing.func_82600_a((int)meta);
            if (!this.isValidFacing(facing)) {
                this.switchSource();
            }
        }
    }

    private boolean isValidFacing(EnumFacing side) {
        TileBuffer[] tileBuffer = this.pipe.container.getTileCache();
        if (tileBuffer == null) {
            return false;
        }
        if (!tileBuffer[side.ordinal()].exists()) {
            return false;
        }
        if (this.pipe.container.hasBlockingPluggable(side)) {
            return false;
        }
        TileEntity tile = tileBuffer[side.ordinal()].getTile();
        return this.isValidConnectingTile(tile);
    }

    protected abstract boolean isValidConnectingTile(TileEntity var1);

    public void initialize() {
        if (!this.pipe.container.func_145831_w().field_72995_K) {
            this.switchSourceIfNeeded();
        }
    }

    public boolean blockActivated(EntityPlayer entityplayer, EnumPipePart side) {
        Item equipped;
        Item item = equipped = entityplayer.func_71045_bC() != null ? entityplayer.func_71045_bC().func_77973_b() : null;
        if (equipped instanceof IToolWrench && ((IToolWrench)equipped).canWrench(entityplayer, this.pipe.container.func_174877_v())) {
            if (side != EnumPipePart.CENTER && this.pipe.getContainer().isPipeConnected(side.face)) {
                this.setSource(side);
            } else {
                this.switchSource();
            }
            ((IToolWrench)equipped).wrenchUsed(entityplayer, this.pipe.container.func_174877_v());
            return true;
        }
        return false;
    }

    public void onNeighborBlockChange() {
        if (!this.pipe.container.func_145831_w().field_72995_K) {
            this.switchSourceIfNeeded();
        }
    }
}

