/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.transport.network;

import buildcraft.core.lib.network.PacketCoordinates;
import buildcraft.transport.PipeTransportPower;
import buildcraft.transport.TileGenericPipe;
import io.netty.buffer.ByteBuf;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.World;

public class PacketPowerUpdate
extends PacketCoordinates {
    public boolean overload;
    public short[] displayPower;
    public short[] displayFlow;

    public PacketPowerUpdate() {
    }

    public PacketPowerUpdate(TileEntity tile) {
        super(tile);
    }

    @Override
    public void readData(ByteBuf data) {
        super.readData(data);
        this.displayPower = new short[6];
        this.displayFlow = new short[6];
        this.overload = data.readBoolean();
        for (int i = 0; i < this.displayPower.length; ++i) {
            this.displayPower[i] = data.readUnsignedByte();
            this.displayFlow[i] = data.readByte();
        }
    }

    @Override
    public void writeData(ByteBuf data) {
        super.writeData(data);
        data.writeBoolean(this.overload);
        for (int i = 0; i < this.displayPower.length; ++i) {
            data.writeByte((int)this.displayPower[i]);
            data.writeByte((int)this.displayFlow[i]);
        }
    }

    @Override
    public void applyData(World world, EntityPlayer player) {
        if (!world.func_175667_e(this.pos)) {
            return;
        }
        TileEntity entity = world.func_175625_s(this.pos);
        if (!(entity instanceof TileGenericPipe)) {
            return;
        }
        TileGenericPipe pipe = (TileGenericPipe)entity;
        if (pipe.pipe == null) {
            return;
        }
        if (!(pipe.pipe.transport instanceof PipeTransportPower)) {
            return;
        }
        ((PipeTransportPower)pipe.pipe.transport).handlePowerPacket(this);
    }
}

