/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.transport.gates;

import buildcraft.api.gates.GateExpansionModelKey;
import buildcraft.api.gates.IExpansionBaker;
import buildcraft.api.gates.IGateExpansion;
import buildcraft.core.lib.client.model.BCModelHelper;
import buildcraft.core.lib.client.model.BakedModelHolder;
import buildcraft.core.lib.client.model.MutableQuad;
import buildcraft.core.lib.utils.BCStringUtils;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.vecmath.Matrix4f;
import javax.vecmath.Vector3f;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.client.renderer.vertex.VertexFormat;
import net.minecraft.client.resources.model.IBakedModel;
import net.minecraft.util.EnumWorldBlockLayer;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public abstract class GateExpansionBuildcraft
implements IGateExpansion {
    private final String tag;
    @SideOnly(value=Side.CLIENT)
    private TextureAtlasSprite sprite;
    @SideOnly(value=Side.CLIENT)
    private RenderState renderState;
    @SideOnly(value=Side.CLIENT)
    protected BCModelKey key;

    public GateExpansionBuildcraft(String tag) {
        this.tag = tag;
    }

    @Override
    public String getUniqueIdentifier() {
        return "buildcraft:" + this.tag;
    }

    @Override
    public String getDisplayName() {
        return BCStringUtils.localize("gate.expansion." + this.tag);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void textureStitch(TextureMap map) {
        this.sprite = map.func_174942_a(new ResourceLocation("buildcrafttransport:gates/gate_expansion_" + this.tag));
        if (this.renderState != null) {
            MinecraftForge.EVENT_BUS.unregister((Object)this.renderState);
            this.renderState = null;
        }
    }

    public RenderState getRenderState() {
        if (this.renderState == null) {
            this.renderState = new RenderState();
        }
        return this.renderState;
    }

    public float getPixelExtrusion() {
        return 0.03f;
    }

    @Override
    public GateExpansionModelKey<?> getRenderModelKey(EnumWorldBlockLayer layer) {
        if (layer == EnumWorldBlockLayer.CUTOUT) {
            if (this.key == null) {
                this.key = new BCModelKey(this.getRenderState());
            }
            return this.key;
        }
        return null;
    }

    @SideOnly(value=Side.CLIENT)
    private class RenderState
    extends BakedModelHolder
    implements IExpansionBaker<BCModelKey> {
        private final ResourceLocation identifier = new ResourceLocation("buildcrafttransport:gate/expansion/identifier");
        private ImmutableList<BakedQuad> transformedQuads;

        private RenderState() {
        }

        @Override
        public VertexFormat getVertexFormat() {
            return DefaultVertexFormats.field_176600_a;
        }

        @Override
        public ImmutableList<BakedQuad> bake(BCModelKey key) {
            if (this.transformedQuads == null) {
                IBakedModel baked = this.getModelItemLayer(this.identifier, GateExpansionBuildcraft.this.sprite);
                List quads = baked.func_177550_a();
                ArrayList transformedQuads = Lists.newArrayList();
                Matrix4f translation = new Matrix4f();
                translation.setIdentity();
                translation.setTranslation(new Vector3f((2.0f - GateExpansionBuildcraft.this.getPixelExtrusion()) / 16.0f, 0.0f, 0.0f));
                for (BakedQuad quad : quads) {
                    MutableQuad mutable = MutableQuad.create(quad);
                    mutable.transform(translation);
                    mutable.setTint(0xFFFFFF);
                    BCModelHelper.appendBakeQuads((List<BakedQuad>)transformedQuads, mutable);
                }
                this.transformedQuads = ImmutableList.copyOf((Collection)transformedQuads);
            }
            return this.transformedQuads;
        }
    }

    public static class BCModelKey
    extends GateExpansionModelKey<BCModelKey> {
        public BCModelKey(RenderState state) {
            super(EnumWorldBlockLayer.CUTOUT, state);
        }

        @Override
        public int hashCode() {
            return System.identityHashCode(this);
        }

        @Override
        public boolean equals(Object obj) {
            return obj == this;
        }
    }
}

