/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.transport.client.shader;

import buildcraft.transport.client.shader.FluidShaderRenderer;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.WorldClient;
import net.minecraft.client.shader.ShaderManager;
import net.minecraft.world.World;
import net.minecraftforge.client.event.RenderWorldLastEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public enum FluidShaderManager {
    INSTANCE;

    private FluidShaderRenderer currentRenderer;
    private WorldClient currentWorld;
    private boolean hasInit = false;
    private ShaderManager shader = null;

    public ShaderManager getShader() {
        return this.shader;
    }

    public FluidShaderRenderer getRenderer(WorldClient world) {
        if (!this.hasInit) {
            this.bindShaders();
        }
        if (this.currentWorld != world) {
            this.currentWorld = world;
            if (this.currentRenderer != null) {
                this.currentRenderer.destroy();
            }
            this.currentRenderer = new FluidShaderRenderer((World)this.currentWorld);
        }
        return this.currentRenderer;
    }

    private void bindShaders() {
        this.hasInit = true;
    }

    public void clientTick(TickEvent.ClientTickEvent event) {
        if (event.phase == TickEvent.Phase.END && Minecraft.func_71410_x().field_71441_e != null) {
            this.getRenderer(Minecraft.func_71410_x().field_71441_e).clientTick();
        }
    }

    public void renderWorld(RenderWorldLastEvent event) {
        if (Minecraft.func_71410_x().field_71441_e != null) {
            this.getRenderer(Minecraft.func_71410_x().field_71441_e).renderAll(event.partialTicks);
        }
    }
}

