/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.transport.client.shader;

import buildcraft.core.lib.utils.Utils;
import buildcraft.transport.client.shader.FluidPositionInfo;
import buildcraft.transport.client.shader.FluidPositionInfoBuilder;
import buildcraft.transport.client.shader.FluidShaderDataBuilder;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.util.Vec3;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public class FluidShaderData {
    public final FluidPositionInfo positionA;
    public final FluidPositionInfo positionB;
    public final TextureAtlasSprite sprite;
    public final long expireTick;

    public FluidShaderData(FluidShaderDataBuilder builder) {
        this.positionA = builder.positionA;
        this.positionB = builder.positionB;
        this.sprite = builder.sprite;
        this.expireTick = builder.expire;
    }

    public FluidPositionInfo interpolateA(long tick, float partialTicks) {
        if (!this.positionA.moves) {
            return this.positionA;
        }
        if (tick < this.positionA.startMoving) {
            return this.positionA;
        }
        float position = 0.0f;
        return this.positionA;
    }

    public FluidPositionInfo interpolateB(long tick, float partialTicks) {
        long tickDiff;
        if (!this.positionB.moves) {
            return this.positionB;
        }
        if (tick < this.positionB.startMoving) {
            return this.positionB;
        }
        float position = 0.0f;
        position = tick >= this.positionB.endMoving ? 0.0f : ((tickDiff = this.positionB.endMoving - this.positionB.startMoving) <= 0L ? 1.0f : ((float)(this.positionB.endMoving - tick) - partialTicks) / (float)tickDiff);
        Vec3 diff = this.positionB.point.func_178788_d(this.positionA.point);
        Vec3 offset = Utils.multiply(diff, 1.0f - position);
        FluidPositionInfoBuilder builder = new FluidPositionInfoBuilder(this.positionB);
        builder.setMin(builder.min.func_178787_e(offset));
        builder.setMax(builder.max.func_178787_e(offset));
        builder.setPoint(builder.point.func_178787_e(offset));
        return builder.build();
    }

    public boolean isValid(long tick) {
        return tick < this.expireTick;
    }
}

