/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.transport.client.render;

import buildcraft.core.lib.EntityResizableCuboid;
import buildcraft.core.lib.client.render.RenderResizableCuboid;
import buildcraft.core.lib.client.render.RenderUtils;
import buildcraft.core.lib.utils.Utils;
import buildcraft.transport.Pipe;
import buildcraft.transport.PipeIconProvider;
import buildcraft.transport.PipeTransportPower;
import buildcraft.transport.client.render.PipeTransportRenderer;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.OpenGlHelper;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.Vec3;
import org.lwjgl.opengl.GL11;

public class PipeTransportRendererPower
extends PipeTransportRenderer<PipeTransportPower> {
    public static final double FLOW_MULTIPLIER = 0.048;
    public static final short POWER_STAGES = 64;

    @Override
    public void render(Pipe<PipeTransportPower> pipe, double x, double y, double z, float f) {
        PipeTransportPower pow = (PipeTransportPower)pipe.transport;
        GL11.glPushMatrix();
        GL11.glPushAttrib((int)8192);
        GlStateManager.func_179140_f();
        GL11.glTranslatef((float)((float)x), (float)((float)y), (float)((float)z));
        Minecraft.func_71410_x().func_110434_K().func_110577_a(TextureMap.field_110575_b);
        double centerPower = 0.0;
        double[] power = new double[6];
        short[] flow = pow.displayFlow;
        for (int i = 0; i < 6; ++i) {
            power[i] = pow.displayPowerAverage[i].getAverage();
            double d = power[i];
            if (!(d > centerPower)) continue;
            centerPower = d;
        }
        if (centerPower > 0.0) {
            long ms = System.currentTimeMillis();
            long diff = ms - pow.clientLastDisplayTime;
            if (pow.clientLastDisplayTime == 0L || diff <= 0L) {
                diff = 1L;
            }
            pow.clientLastDisplayTime = ms;
            for (int i = 0; i < 6; ++i) {
                EnumFacing face = EnumFacing.values()[i];
                if (!pipe.getTile().isPipeConnected(face)) continue;
                double actualDiff = (double)((long)flow[i] * diff) * 0.048;
                double connectionDiff = face.func_176743_c() == EnumFacing.AxisDirection.POSITIVE ? actualDiff : -actualDiff;
                int n = i;
                pow.clientDisplayFlow[n] = pow.clientDisplayFlow[n] + connectionDiff;
                while (pow.clientDisplayFlow[i] < 0.0) {
                    int n2 = i;
                    pow.clientDisplayFlow[n2] = pow.clientDisplayFlow[n2] + 16.0;
                }
                while (pow.clientDisplayFlow[i] > 16.0) {
                    int n3 = i;
                    pow.clientDisplayFlow[n3] = pow.clientDisplayFlow[n3] - 16.0;
                }
                pow.clientDisplayFlowCentre = pow.clientDisplayFlowCentre.func_178787_e(Utils.convert(face, actualDiff / 2.0));
                PipeTransportRendererPower.renderSidePower(face, power[i], pow.clientDisplayFlow[i], centerPower);
            }
            for (EnumFacing.Axis axis : EnumFacing.Axis.values()) {
                double value;
                for (value = Utils.getValue(pow.clientDisplayFlowCentre, axis); value < 0.0; value += 16.0) {
                }
                while (value > 16.0) {
                    value -= 16.0;
                }
                pow.clientDisplayFlowCentre = Utils.withValue(pow.clientDisplayFlowCentre, axis, value);
            }
            PipeTransportRendererPower.renderCenterPower(centerPower, pow.clientDisplayFlowCentre);
        }
        GlStateManager.func_179145_e();
        GL11.glPopAttrib();
        GL11.glPopMatrix();
    }

    private static void renderSidePower(EnumFacing face, double stage, double flow, double centerStage) {
        if (stage <= 0.0) {
            return;
        }
        double width = 0.5 * stage / 64.0;
        double centerRadius = 0.25 * centerStage / 64.0;
        Vec3 center = Utils.VEC_HALF.func_178787_e(Utils.convert(face, 0.25 + centerRadius / 2.0));
        face = Utils.convertPositive(face);
        Vec3 size = Utils.VEC_ONE.func_178788_d(Utils.convert(face));
        size = Utils.multiply(size, width);
        size = size.func_178787_e(Utils.convert(face, 0.5 - centerRadius));
        EntityResizableCuboid cuboid = new EntityResizableCuboid(null);
        cuboid.setSize(size);
        cuboid.texture = PipeIconProvider.TYPE.Power_Normal.getIcon();
        cuboid.makeClient();
        double offsetNonFlow = 0.0;
        double offsetFlow = flow;
        Vec3 textureOffset = new Vec3(offsetNonFlow, offsetNonFlow, offsetNonFlow);
        textureOffset = textureOffset.func_178787_e(Utils.convert(face, -offsetNonFlow));
        textureOffset = textureOffset.func_178787_e(Utils.convert(face, offsetFlow));
        cuboid.textureOffsetX = textureOffset.field_72450_a;
        cuboid.textureOffsetY = textureOffset.field_72448_b;
        cuboid.textureOffsetZ = textureOffset.field_72449_c;
        GL11.glPushMatrix();
        RenderUtils.translate(center);
        OpenGlHelper.func_77475_a((int)OpenGlHelper.field_77476_b, (float)240.0f, (float)240.0f);
        RenderResizableCuboid.INSTANCE.renderCubeFromCentre(cuboid);
        GL11.glPopMatrix();
    }

    private static void renderCenterPower(double stage, Vec3 centerFlow) {
        if (stage <= 0.0) {
            return;
        }
        double width = 0.5 * stage / 64.0;
        Vec3 size = new Vec3(width, width, width);
        Vec3 pos = Utils.VEC_HALF;
        EntityResizableCuboid erc = new EntityResizableCuboid(null);
        erc.setSize(size);
        erc.texture = PipeIconProvider.TYPE.Power_Normal.getIcon();
        erc.textureOffsetX = centerFlow.field_72450_a;
        erc.textureOffsetY = centerFlow.field_72448_b;
        erc.textureOffsetZ = centerFlow.field_72449_c;
        GL11.glPushMatrix();
        RenderUtils.translate(pos);
        OpenGlHelper.func_77475_a((int)OpenGlHelper.field_77476_b, (float)240.0f, (float)240.0f);
        RenderResizableCuboid.INSTANCE.renderCubeFromCentre(erc);
        GL11.glPopMatrix();
    }
}

