/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.transport.client.model;

import buildcraft.core.lib.client.model.IModelCache;
import buildcraft.core.lib.client.model.ModelCacheJoiner;
import buildcraft.transport.Pipe;
import buildcraft.transport.PipePluggableState;
import buildcraft.transport.PipeRenderState;
import buildcraft.transport.client.model.PipeModelCacheBase;
import buildcraft.transport.client.model.PipeModelCachePluggable;
import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.Objects;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.util.EnumWorldBlockLayer;

public class PipeModelCacheAll {
    private static final IModelCache<PipeAllCutoutKey> cacheCutout;
    private static final IModelCache<PipeAllTranslucentKey> cacheTranslucent;

    public static ImmutableList<BakedQuad> getCutoutModel(Pipe<?> pipe, PipeRenderState render, PipePluggableState pluggable) {
        PipeAllCutoutKey key = new PipeAllCutoutKey(pipe, render, pluggable);
        return cacheCutout.bake(key, DefaultVertexFormats.field_176600_a);
    }

    public static ImmutableList<BakedQuad> getTranslucentModel(Pipe<?> pipe, PipeRenderState render, PipePluggableState pluggable) {
        PipeAllTranslucentKey key = new PipeAllTranslucentKey(pipe, render, pluggable);
        return cacheTranslucent.bake(key, DefaultVertexFormats.field_176600_a);
    }

    static {
        ArrayList cutout = new ArrayList();
        cutout.add(new ModelCacheJoiner.ModelKeyWrapper<PipeAllCutoutKey, PipeModelCacheBase.PipeBaseCutoutKey>(PipeAllCutoutKey::getBaseCutout, PipeModelCacheBase.cacheCutout));
        cutout.add(new ModelCacheJoiner.ModelKeyWrapper<PipeAllCutoutKey, PipeModelCachePluggable.PluggableKey>(PipeAllCutoutKey::getPluggable, PipeModelCachePluggable.cacheCutoutAll));
        cacheCutout = new ModelCacheJoiner<PipeAllCutoutKey>("pipe.all.cutout", cutout);
        ArrayList translucent = new ArrayList();
        translucent.add(new ModelCacheJoiner.ModelKeyWrapper<PipeAllTranslucentKey, PipeModelCacheBase.PipeBaseTransclucentKey>(PipeAllTranslucentKey::getBaseTranslucent, PipeModelCacheBase.cacheTranslucent));
        translucent.add(new ModelCacheJoiner.ModelKeyWrapper<PipeAllTranslucentKey, PipeModelCachePluggable.PluggableKey>(PipeAllTranslucentKey::getPluggable, PipeModelCachePluggable.cacheTranslucentAll));
        cacheTranslucent = new ModelCacheJoiner<PipeAllTranslucentKey>("pipe.all.transclucent", translucent);
    }

    public static class PipeAllTranslucentKey {
        private final PipeModelCacheBase.PipeBaseTransclucentKey translucent;
        private final PipeModelCachePluggable.PluggableKey pluggable;
        private final int hash;

        public PipeAllTranslucentKey(Pipe<?> pipe, PipeRenderState render, PipePluggableState pluggable) {
            this.translucent = new PipeModelCacheBase.PipeBaseTransclucentKey(render);
            this.pluggable = new PipeModelCachePluggable.PluggableKey(EnumWorldBlockLayer.TRANSLUCENT, pluggable);
            this.hash = Objects.hash(this.translucent, pluggable);
        }

        public PipeModelCacheBase.PipeBaseTransclucentKey getBaseTranslucent() {
            return this.translucent;
        }

        public PipeModelCachePluggable.PluggableKey getPluggable() {
            return this.pluggable;
        }

        public int hashCode() {
            return this.hash;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            PipeAllTranslucentKey other = (PipeAllTranslucentKey)obj;
            if (!this.translucent.equals(other.translucent)) {
                return false;
            }
            return this.pluggable.equals(other.pluggable);
        }

        public String toString() {
            return "PipeAllTranslucentKey [base=" + this.translucent + ", pluggable = " + this.pluggable + "]";
        }
    }

    public static class PipeAllCutoutKey {
        private final PipeModelCacheBase.PipeBaseCutoutKey cutout;
        private final PipeModelCachePluggable.PluggableKey pluggable;
        private final int hash;

        public PipeAllCutoutKey(Pipe<?> pipe, PipeRenderState render, PipePluggableState pluggable) {
            this.cutout = new PipeModelCacheBase.PipeBaseCutoutKey(pipe, render);
            this.pluggable = new PipeModelCachePluggable.PluggableKey(EnumWorldBlockLayer.CUTOUT, pluggable);
            this.hash = Objects.hash(this.cutout, pluggable);
        }

        public PipeModelCacheBase.PipeBaseCutoutKey getBaseCutout() {
            return this.cutout;
        }

        public PipeModelCachePluggable.PluggableKey getPluggable() {
            return this.pluggable;
        }

        public int hashCode() {
            return this.hash;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            PipeAllCutoutKey other = (PipeAllCutoutKey)obj;
            if (!this.cutout.equals(other.cutout)) {
                return false;
            }
            return this.pluggable.equals(other.pluggable);
        }

        public String toString() {
            return "PipeAllCutoutKey [base=" + this.cutout + ", pluggable = " + this.pluggable + "]";
        }
    }
}

