/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.transport.client.model;

import buildcraft.core.lib.client.model.BuildCraftBakedModel;
import buildcraft.transport.BlockGenericPipe;
import buildcraft.transport.Pipe;
import buildcraft.transport.PipePluggableState;
import buildcraft.transport.PipeRenderState;
import buildcraft.transport.TileGenericPipe;
import buildcraft.transport.client.model.PipeModelCacheAll;
import com.google.common.collect.ImmutableList;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.client.renderer.vertex.VertexFormat;
import net.minecraft.util.EnumWorldBlockLayer;
import net.minecraftforge.client.MinecraftForgeClient;
import net.minecraftforge.client.model.ISmartBlockModel;
import net.minecraftforge.common.property.IExtendedBlockState;

public class PipeBlockModel
extends BuildCraftBakedModel
implements ISmartBlockModel {
    public PipeBlockModel() {
        super((ImmutableList<BakedQuad>)ImmutableList.of(), null, null);
    }

    protected PipeBlockModel(ImmutableList<BakedQuad> quads, TextureAtlasSprite particle, VertexFormat format) {
        super(quads, particle, format);
    }

    public ISmartBlockModel handleBlockState(IBlockState state) {
        try {
            return PipeBlockModel.handle((IExtendedBlockState)state);
        }
        catch (Throwable t) {
            t.printStackTrace();
            return PipeBlockModel.defaultModel();
        }
    }

    private static ISmartBlockModel defaultModel() {
        return new PipeBlockModel();
    }

    public static ISmartBlockModel handle(IExtendedBlockState state) {
        TileGenericPipe.CoreState core = BlockGenericPipe.PIPE_CORE_STATE.getUnlistedValue(state);
        PipeRenderState render = BlockGenericPipe.PIPE_RENDER_STATE.getUnlistedValue(state);
        PipePluggableState pluggable = BlockGenericPipe.PIPE_PLUGGABLE_STATE.getUnlistedValue(state);
        Pipe<?> pipe = BlockGenericPipe.PIPE_PIPE.getUnlistedValue(state);
        if (core == null || render == null || pluggable == null || pipe == null) {
            return PipeBlockModel.defaultModel();
        }
        EnumWorldBlockLayer layer = MinecraftForgeClient.getRenderLayer();
        ImmutableList<BakedQuad> quads = layer == EnumWorldBlockLayer.CUTOUT ? PipeBlockModel.renderCutoutPass(render, pluggable, pipe) : (layer == EnumWorldBlockLayer.TRANSLUCENT ? PipeBlockModel.renderTranslucentPass(render, pluggable, pipe) : ImmutableList.of());
        TextureAtlasSprite particle = pipe.getIconProvider().getIcon(pipe.getIconIndex(null));
        return new PipeBlockModel(quads, particle, DefaultVertexFormats.field_176600_a);
    }

    private static ImmutableList<BakedQuad> renderCutoutPass(PipeRenderState render, PipePluggableState pluggable, Pipe<?> pipe) {
        return PipeModelCacheAll.getCutoutModel(pipe, render, pluggable);
    }

    private static ImmutableList<BakedQuad> renderTranslucentPass(PipeRenderState render, PipePluggableState pluggable, Pipe<?> pipe) {
        return PipeModelCacheAll.getTranslucentModel(pipe, render, pluggable);
    }
}

