/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.transport.client.model;

import buildcraft.api.transport.pluggable.IPluggableModelBaker;
import buildcraft.core.lib.client.model.BCModelHelper;
import buildcraft.core.lib.client.model.BakedModelHolder;
import buildcraft.core.lib.client.model.MutableQuad;
import buildcraft.core.lib.utils.MatrixUtils;
import buildcraft.transport.ItemFacade;
import buildcraft.transport.PipeIconProvider;
import buildcraft.transport.client.model.ModelKeyFacade;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import javax.vecmath.Matrix4f;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.client.renderer.vertex.VertexFormat;
import net.minecraft.client.resources.model.ModelRotation;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumWorldBlockLayer;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.model.IFlexibleBakedModel;
import net.minecraftforge.client.model.IModel;
import net.minecraftforge.client.model.IModelState;

public final class FacadePluggableModel
extends BakedModelHolder
implements IPluggableModelBaker<ModelKeyFacade> {
    private static final ResourceLocation hollowLoc = new ResourceLocation("buildcrafttransport:models/blocks/pluggables/facade_hollow.obj");
    private static final ResourceLocation filledLoc = new ResourceLocation("buildcrafttransport:models/blocks/pluggables/facade_filled.obj");
    private static final ResourceLocation connectorLoc = new ResourceLocation("buildcrafttransport:models/blocks/pluggables/plug.obj");
    public static final FacadePluggableModel INSTANCE = new FacadePluggableModel();

    private FacadePluggableModel() {
    }

    public IModel modelHollow() {
        return this.getModelOBJ(hollowLoc);
    }

    public IModel modelFilled() {
        return this.getModelOBJ(filledLoc);
    }

    public IModel modelConnector() {
        return this.getModelOBJ(connectorLoc);
    }

    @Override
    public VertexFormat getVertexFormat() {
        return DefaultVertexFormats.field_176600_a;
    }

    @Override
    public ImmutableList<BakedQuad> bake(ModelKeyFacade key) {
        return ImmutableList.copyOf(this.bake(key.layer, key.side, key.hollow, key.state, this.getVertexFormat()));
    }

    public List<BakedQuad> bake(EnumWorldBlockLayer layer, EnumFacing face, boolean hollow, IBlockState state, VertexFormat format) {
        MutableQuad mutable;
        IFlexibleBakedModel baked;
        ArrayList quads = Lists.newArrayList();
        Matrix4f matrix = MatrixUtils.rotateTowardsFace(face);
        if (layer == EnumWorldBlockLayer.TRANSLUCENT) {
            if (!state.func_177230_c().canRenderInLayer(EnumWorldBlockLayer.TRANSLUCENT)) {
                return quads;
            }
        } else {
            if (!hollow && !ItemFacade.isTransparentFacade(state)) {
                IModel connector = this.modelConnector();
                TextureAtlasSprite structure = PipeIconProvider.TYPE.PipeStructureCobblestone.getIcon();
                baked = connector.bake((IModelState)ModelRotation.X0_Y0, format, FacadePluggableModel.singleTextureFunction(structure));
                for (BakedQuad quad : baked.func_177550_a()) {
                    mutable = MutableQuad.create(quad);
                    mutable.transform(matrix);
                    mutable.setCalculatedDiffuse();
                    BCModelHelper.appendBakeQuads((List<BakedQuad>)quads, mutable);
                }
            }
            if (!(state.func_177230_c().canRenderInLayer(EnumWorldBlockLayer.SOLID) || state.func_177230_c().canRenderInLayer(EnumWorldBlockLayer.CUTOUT) || state.func_177230_c().canRenderInLayer(EnumWorldBlockLayer.CUTOUT_MIPPED))) {
                return quads;
            }
        }
        TextureAtlasSprite sprite = Minecraft.func_71410_x().func_175602_ab().func_175023_a().func_178122_a(state);
        IModel model = hollow ? this.modelHollow() : this.modelFilled();
        if (model != null) {
            baked = model.bake((IModelState)ModelRotation.X0_Y0, format, FacadePluggableModel.singleTextureFunction(sprite));
            for (BakedQuad quad : baked.func_177550_a()) {
                mutable = MutableQuad.create(quad);
                mutable.transform(matrix);
                mutable.setCalculatedDiffuse();
                BCModelHelper.appendBakeQuads((List<BakedQuad>)quads, mutable);
            }
        }
        return quads;
    }
}

