/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.transport;

import buildcraft.BuildCraftCore;
import buildcraft.BuildCraftTransport;
import buildcraft.api.core.SafeTimeTracker;
import buildcraft.api.power.IEngine;
import buildcraft.api.power.IRedstoneEngine;
import buildcraft.api.tiles.IDebuggable;
import buildcraft.api.transport.IPipeTile;
import buildcraft.api.transport.pluggable.PipePluggable;
import buildcraft.core.CompatHooks;
import buildcraft.core.lib.block.TileBuildCraft;
import buildcraft.core.lib.utils.AverageDouble;
import buildcraft.core.lib.utils.AverageInt;
import buildcraft.core.lib.utils.Utils;
import buildcraft.transport.BlockGenericPipe;
import buildcraft.transport.IPipeTransportPowerHook;
import buildcraft.transport.Pipe;
import buildcraft.transport.PipeTransport;
import buildcraft.transport.network.PacketPowerUpdate;
import buildcraft.transport.pipes.PipePowerCobblestone;
import buildcraft.transport.pipes.PipePowerDiamond;
import buildcraft.transport.pipes.PipePowerEmerald;
import buildcraft.transport.pipes.PipePowerGold;
import buildcraft.transport.pipes.PipePowerIron;
import buildcraft.transport.pipes.PipePowerQuartz;
import buildcraft.transport.pipes.PipePowerSandstone;
import buildcraft.transport.pipes.PipePowerStone;
import buildcraft.transport.pipes.PipePowerWood;
import cofh.api.energy.IEnergyConnection;
import cofh.api.energy.IEnergyHandler;
import cofh.api.energy.IEnergyReceiver;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.Vec3;

public class PipeTransportPower
extends PipeTransport
implements IDebuggable {
    public static final Map<Class<? extends Pipe<?>>, Integer> powerCapacities = new HashMap();
    public static final Map<Class<? extends Pipe<?>>, Float> powerResistances = new HashMap();
    public static final Map<Class<? extends Pipe<?>>, Float> powerLosses = new HashMap();
    public static LossMode lossMode = LossMode.LOSSLESS;
    public static boolean canExplode = false;
    private static int MAX_POWER = 0;
    private static final int OVERLOAD_TICKS = 60;
    public static final short POWER_STAGES = 64;
    public AverageDouble[] displayPowerAverage = new AverageDouble[6];
    public short[] displayPower = new short[6];
    public short[] displayFlow = new short[6];
    public int[] nextPowerQuery = new int[6];
    public double[] internalNextPower = new double[6];
    public int overload;
    public int maxPower = 80;
    public int powerLimit = Integer.MAX_VALUE;
    public float powerResistance;
    public int[] dbgEnergyInput = new int[6];
    public int[] dbgEnergyOutput = new int[6];
    public int[] dbgEnergyOffered = new int[6];
    private final AverageInt[] powerAverage = new AverageInt[6];
    private final TileEntity[] tiles = new TileEntity[6];
    private final Object[] providers = new Object[6];
    private boolean needsInit = true;
    private int[] powerQuery = new int[6];
    private int energyInputTick = 0;
    private long currentDate;
    private double[] internalPower = new double[6];
    private SafeTimeTracker tracker = new SafeTimeTracker(2 * BuildCraftCore.updateFactor);
    public double[] clientDisplayFlow = new double[6];
    public Vec3 clientDisplayFlowCentre = Utils.VEC_ZERO;
    public long clientLastDisplayTime = 0L;

    public PipeTransportPower() {
        for (int i = 0; i < 6; ++i) {
            this.powerQuery[i] = 0;
            this.powerAverage[i] = new AverageInt(10);
            this.displayPowerAverage[i] = new AverageDouble(10);
        }
    }

    @Override
    public IPipeTile.PipeType getPipeType() {
        return IPipeTile.PipeType.POWER;
    }

    public void initFromPipe(Class<? extends Pipe<?>> pipeClass) {
        this.maxPower = powerCapacities.get(pipeClass);
        switch (lossMode) {
            case PERCENTAGE: {
                this.powerResistance = powerResistances.get(pipeClass).floatValue();
                break;
            }
            case ABSOLUTE: {
                this.powerResistance = powerLosses.get(pipeClass).floatValue();
            }
        }
        if (canExplode) {
            this.powerLimit = this.maxPower;
            this.maxPower = MAX_POWER;
        }
    }

    @Override
    public boolean canPipeConnect(TileEntity tile, EnumFacing side) {
        IEnergyConnection handler;
        if (tile instanceof IPipeTile) {
            Pipe pipe2 = (Pipe)((IPipeTile)tile).getPipe();
            return !BlockGenericPipe.isValid(pipe2) || pipe2.transport instanceof PipeTransportPower;
        }
        if (this.container.pipe instanceof PipePowerWood) {
            return this.isPowerSource(tile, side);
        }
        if (tile instanceof IEngine) {
            return false;
        }
        Object provider = CompatHooks.INSTANCE.getEnergyProvider(tile);
        return (provider instanceof IEnergyHandler || provider instanceof IEnergyReceiver) && (handler = (IEnergyConnection)provider).canConnectEnergy(side.func_176734_d());
    }

    public boolean isPowerSource(TileEntity tile, EnumFacing side) {
        if (tile instanceof TileBuildCraft && !(tile instanceof IEngine)) {
            return false;
        }
        if (tile instanceof IRedstoneEngine) {
            return false;
        }
        return tile instanceof IEnergyConnection && ((IEnergyConnection)tile).canConnectEnergy(side.func_176734_d());
    }

    @Override
    public void onNeighborChange(EnumFacing side) {
        super.onNeighborChange(side);
        this.updateTile(side);
    }

    private void updateTile(EnumFacing side) {
        int o = side.ordinal();
        TileEntity tile = this.container.getTile(side);
        if (tile != null && this.container.isPipeConnected(side)) {
            this.tiles[o] = tile;
        } else {
            this.tiles[o] = null;
            this.internalPower[o] = 0.0;
            this.internalNextPower[o] = 0.0;
            this.powerAverage[o].clear();
            this.displayFlow[o] = 0;
        }
        this.providers[o] = this.getEnergyProvider(o);
    }

    private void init() {
        if (this.needsInit) {
            this.needsInit = false;
            for (EnumFacing side : EnumFacing.field_82609_l) {
                this.updateTile(side);
            }
        }
    }

    private Object getEnergyProvider(int side) {
        PipePluggable pp;
        EnumFacing fs = EnumFacing.func_82600_a((int)side);
        if (this.container.hasPipePluggable(fs) && (pp = this.container.getPipePluggable(fs)) instanceof IEnergyReceiver) {
            return pp;
        }
        return CompatHooks.INSTANCE.getEnergyProvider(this.tiles[side]);
    }

    @Override
    public void updateEntity() {
        int i;
        int j3;
        int unusedPowerQuery;
        if (this.container.func_145831_w().field_72995_K) {
            for (int i2 = 0; i2 < 6; ++i2) {
                this.displayPowerAverage[i2].tick(this.displayPower[i2]);
            }
            return;
        }
        if (canExplode && this.overload >= 3) {
            this.destroyPipe();
            return;
        }
        this.step();
        this.init();
        for (EnumFacing side : EnumFacing.field_82609_l) {
            if (this.tiles[side.ordinal()] == null || !this.tiles[side.ordinal()].func_145837_r()) continue;
            this.updateTile(side);
        }
        Arrays.fill(this.displayFlow, (short)0);
        for (int i3 = 0; i3 < 6; ++i3) {
            if (!(this.internalPower[i3] > 0.0)) continue;
            int totalPowerQuery = 0;
            for (int j2 = 0; j2 < 6; ++j2) {
                Object ep;
                if (j2 == i3 || this.powerQuery[j2] <= 0 || !((ep = this.providers[j2]) instanceof IPipeTile) && !(ep instanceof IEnergyReceiver) && !(ep instanceof IEnergyHandler)) continue;
                totalPowerQuery += this.powerQuery[j2];
            }
            if (totalPowerQuery <= 0) continue;
            unusedPowerQuery = totalPowerQuery;
            for (int j3 = 0; j3 < 6; ++j3) {
                IEnergyReceiver handler;
                if (j3 == i3 || this.powerQuery[j3] <= 0) continue;
                Object ep = this.providers[j3];
                double watts = Math.min(this.internalPower[i3] * (double)this.powerQuery[j3] / (double)unusedPowerQuery, this.internalPower[i3]);
                unusedPowerQuery -= this.powerQuery[j3];
                if (ep instanceof IPipeTile && ((IPipeTile)ep).getPipeType() == IPipeTile.PipeType.POWER) {
                    Pipe nearbyPipe = (Pipe)((IPipeTile)ep).getPipe();
                    PipeTransportPower nearbyTransport = (PipeTransportPower)nearbyPipe.transport;
                    watts = nearbyTransport.receiveEnergy(EnumFacing.field_82609_l[j3].func_176734_d(), watts);
                    int n = i3;
                    this.internalPower[n] = this.internalPower[n] - watts;
                    int n2 = j3;
                    this.dbgEnergyOutput[n2] = (int)((double)this.dbgEnergyOutput[n2] + watts);
                    this.powerAverage[j3].push((int)Math.ceil(watts));
                    this.powerAverage[i3].push((int)Math.ceil(watts));
                    this.displayFlow[i3] = 1;
                    this.displayFlow[j3] = -1;
                    continue;
                }
                int iWatts = (int)watts;
                if (ep instanceof IEnergyReceiver && (handler = (IEnergyReceiver)ep).canConnectEnergy(EnumFacing.values()[j3].func_176734_d())) {
                    iWatts = handler.receiveEnergy(EnumFacing.values()[j3].func_176734_d(), iWatts, false);
                }
                int n = i3;
                this.internalPower[n] = this.internalPower[n] - (double)iWatts;
                int n3 = j3;
                this.dbgEnergyOutput[n3] = this.dbgEnergyOutput[n3] + iWatts;
                this.powerAverage[j3].push(iWatts);
                this.powerAverage[i3].push(iWatts);
                this.displayFlow[i3] = 1;
                this.displayFlow[j3] = -1;
            }
        }
        short highestPower = 0;
        for (int i4 = 0; i4 < 6; ++i4) {
            this.powerAverage[i4].tick();
            this.displayPower[i4] = (short)Math.round(this.powerAverage[i4].getAverage());
            if (this.displayPower[i4] <= highestPower) continue;
            highestPower = this.displayPower[i4];
        }
        if (canExplode) {
            this.overload = this.energyInputTick > this.powerLimit || this.overload > 0 ? ++this.overload : 0;
        } else {
            this.overload += (float)highestPower > (float)this.maxPower * 0.95f ? 1 : -1;
            if (this.overload < 0) {
                this.overload = 0;
            }
            if (this.overload > 60) {
                this.overload = 60;
            }
        }
        this.energyInputTick = 0;
        EnumFacing[] i4 = EnumFacing.field_82609_l;
        unusedPowerQuery = i4.length;
        for (j3 = 0; j3 < unusedPowerQuery; ++j3) {
            int request;
            IEnergyReceiver handler;
            Object tile;
            EnumFacing dir = i4[j3];
            if (!this.outputOpen(dir) || (tile = this.providers[dir.ordinal()]) instanceof IPipeTile && ((IPipeTile)tile).getPipe() != null && ((Pipe)((IPipeTile)tile).getPipe()).transport instanceof PipeTransportPower) continue;
            if (tile instanceof IEnergyReceiver) {
                handler = (IEnergyReceiver)tile;
                if (!handler.canConnectEnergy(dir.func_176734_d()) || (request = handler.receiveEnergy(dir.func_176734_d(), this.maxPower, true)) <= 0) continue;
                this.requestEnergy(dir, request);
                continue;
            }
            if (!(tile instanceof IEnergyReceiver) || !(handler = (IEnergyReceiver)tile).canConnectEnergy(dir.func_176734_d()) || (request = handler.receiveEnergy(dir.func_176734_d(), this.maxPower, true)) <= 0) continue;
            this.requestEnergy(dir, request);
        }
        int[] transferQuery = new int[6];
        for (i = 0; i < 6; ++i) {
            transferQuery[i] = 0;
            if (!this.inputOpen(EnumFacing.func_82600_a((int)i))) continue;
            for (j3 = 0; j3 < 6; ++j3) {
                if (j3 == i) continue;
                int n = i;
                transferQuery[n] = transferQuery[n] + this.powerQuery[j3];
            }
            transferQuery[i] = Math.min(transferQuery[i], this.maxPower);
        }
        for (i = 0; i < 6; ++i) {
            IPipeTile nearbyTile;
            TileEntity entity;
            if (transferQuery[i] == 0 || this.tiles[i] == null || !((entity = this.tiles[i]) instanceof IPipeTile) || ((IPipeTile)entity).getPipeType() != IPipeTile.PipeType.POWER || (nearbyTile = (IPipeTile)entity).getPipe() == null || nearbyTile.getPipeType() != IPipeTile.PipeType.POWER) continue;
            PipeTransportPower nearbyTransport = (PipeTransportPower)((Pipe)nearbyTile.getPipe()).transport;
            nearbyTransport.requestEnergy(EnumFacing.field_82609_l[i].func_176734_d(), transferQuery[i]);
        }
        if (this.tracker.markTimeIfDelay(this.container.func_145831_w())) {
            PacketPowerUpdate packet = new PacketPowerUpdate(this.container);
            packet.displayPower = new short[6];
            for (int i5 = 0; i5 < 6; ++i5) {
                double val = this.displayPower[i5];
                val /= (double)MAX_POWER;
                val = Math.sqrt(val);
                packet.displayPower[i5] = (short)(val *= 64.0);
            }
            packet.displayFlow = this.displayFlow;
            packet.overload = this.isOverloaded();
            BuildCraftTransport.instance.sendToPlayersNear(packet, this.container);
        }
    }

    public boolean isOverloaded() {
        return this.overload >= 60;
    }

    private void step() {
        if (this.container != null && this.container.func_145831_w() != null && this.currentDate != this.container.func_145831_w().func_82737_E()) {
            this.currentDate = this.container.func_145831_w().func_82737_E();
            Arrays.fill(this.dbgEnergyInput, 0);
            Arrays.fill(this.dbgEnergyOffered, 0);
            Arrays.fill(this.dbgEnergyOutput, 0);
            this.powerQuery = this.nextPowerQuery;
            this.nextPowerQuery = new int[6];
            double[] next = this.internalPower;
            this.internalPower = this.internalNextPower;
            this.internalNextPower = next;
        }
    }

    public double receiveEnergy(EnumFacing from, double tVal) {
        double ret;
        int side = from.ordinal();
        double val = tVal;
        this.step();
        int n = side;
        this.dbgEnergyOffered[n] = (int)((double)this.dbgEnergyOffered[n] + val);
        if (this.container.pipe instanceof IPipeTransportPowerHook && (ret = (double)((IPipeTransportPowerHook)((Object)this.container.pipe)).receiveEnergy(from, (int)val)) >= 0.0) {
            return ret;
        }
        if (this.internalNextPower[side] > (double)this.maxPower) {
            return 0.0;
        }
        switch (lossMode) {
            case LOSSLESS: {
                int n2 = side;
                this.internalNextPower[n2] = this.internalNextPower[n2] + val;
                break;
            }
            case PERCENTAGE: {
                int n3 = side;
                this.internalNextPower[n3] = this.internalNextPower[n3] + val * (double)(1.0f - this.powerResistance);
                break;
            }
            case ABSOLUTE: {
                if (val < (double)this.powerResistance) {
                    return 0.0;
                }
                int n4 = side;
                this.internalNextPower[n4] = this.internalNextPower[n4] + (val - (double)this.powerResistance);
            }
        }
        if (this.internalNextPower[side] > (double)this.maxPower) {
            val -= this.internalNextPower[side] - (double)this.maxPower;
            this.internalNextPower[side] = this.maxPower;
            if (val < 0.0) {
                val = 0.0;
            }
        }
        int n5 = side;
        this.dbgEnergyInput[n5] = (int)((double)this.dbgEnergyInput[n5] + val);
        this.energyInputTick = (int)((double)this.energyInputTick + val);
        return val;
    }

    public void requestEnergy(EnumFacing from, int amount) {
        this.step();
        if (this.container.pipe instanceof IPipeTransportPowerHook) {
            int n = from.ordinal();
            this.nextPowerQuery[n] = this.nextPowerQuery[n] + ((IPipeTransportPowerHook)((Object)this.container.pipe)).requestEnergy(from, amount);
        } else {
            int n = from.ordinal();
            this.nextPowerQuery[n] = this.nextPowerQuery[n] + amount;
        }
    }

    @Override
    public void initialize() {
        this.currentDate = this.container.func_145831_w().func_82737_E();
    }

    @Override
    public void readFromNBT(NBTTagCompound nbttagcompound) {
        super.readFromNBT(nbttagcompound);
        for (int i = 0; i < 6; ++i) {
            this.powerQuery[i] = nbttagcompound.func_74762_e("powerQuery[" + i + "]");
            this.nextPowerQuery[i] = nbttagcompound.func_74762_e("nextPowerQuery[" + i + "]");
            this.internalPower[i] = nbttagcompound.func_74762_e("internalPower[" + i + "]");
            this.internalNextPower[i] = nbttagcompound.func_74762_e("internalNextPower[" + i + "]");
        }
    }

    @Override
    public void writeToNBT(NBTTagCompound nbttagcompound) {
        super.writeToNBT(nbttagcompound);
        for (int i = 0; i < 6; ++i) {
            nbttagcompound.func_74768_a("powerQuery[" + i + "]", this.powerQuery[i]);
            nbttagcompound.func_74768_a("nextPowerQuery[" + i + "]", this.nextPowerQuery[i]);
            nbttagcompound.func_74780_a("internalPower[" + i + "]", this.internalPower[i]);
            nbttagcompound.func_74780_a("internalNextPower[" + i + "]", this.internalNextPower[i]);
        }
    }

    public void handlePowerPacket(PacketPowerUpdate packetPower) {
        this.displayPower = packetPower.displayPower;
        this.displayFlow = packetPower.displayFlow;
        this.overload = packetPower.overload ? 60 : 0;
    }

    public boolean isQueryingPower() {
        for (int d : this.powerQuery) {
            if (d <= 0) continue;
            return true;
        }
        return false;
    }

    public static void setPowerCapacity(Class<? extends Pipe<?>> pipe, int capacity) {
        powerCapacities.put(pipe, capacity);
        int mp = 0;
        for (int p : powerCapacities.values()) {
            if (p <= mp) continue;
            mp = p;
        }
        MAX_POWER = mp;
    }

    public static void setPowerResistance(Class<? extends Pipe<?>> pipe, float resistance) {
        powerResistances.put(pipe, Float.valueOf(resistance));
    }

    public static void setPowerLoss(Class<? extends Pipe<?>> pipe, float loss) {
        powerLosses.put(pipe, Float.valueOf(loss));
    }

    @Override
    public void getDebugInfo(List<String> left, List<String> right, EnumFacing side) {
        left.add("");
        left.add("PipeTransportPower (" + this.maxPower + " RF/t)");
        for (EnumFacing face : EnumFacing.field_82609_l) {
            int ord = face.ordinal();
            left.add(" - " + face.func_176742_j() + " " + this.displayPower[ord]);
        }
    }

    static {
        PipeTransportPower.setPowerCapacity(PipePowerCobblestone.class, 80);
        PipeTransportPower.setPowerCapacity(PipePowerStone.class, 160);
        PipeTransportPower.setPowerCapacity(PipePowerSandstone.class, 160);
        PipeTransportPower.setPowerCapacity(PipePowerWood.class, 320);
        PipeTransportPower.setPowerCapacity(PipePowerQuartz.class, 640);
        PipeTransportPower.setPowerCapacity(PipePowerIron.class, 1280);
        PipeTransportPower.setPowerCapacity(PipePowerGold.class, 2560);
        PipeTransportPower.setPowerCapacity(PipePowerEmerald.class, 2560);
        PipeTransportPower.setPowerCapacity(PipePowerDiamond.class, 5120);
        PipeTransportPower.setPowerResistance(PipePowerCobblestone.class, 0.05f);
        PipeTransportPower.setPowerResistance(PipePowerStone.class, 0.025f);
        PipeTransportPower.setPowerResistance(PipePowerWood.class, 0.0f);
        PipeTransportPower.setPowerResistance(PipePowerSandstone.class, 0.0125f);
        PipeTransportPower.setPowerResistance(PipePowerQuartz.class, 0.0125f);
        PipeTransportPower.setPowerResistance(PipePowerIron.class, 0.0125f);
        PipeTransportPower.setPowerResistance(PipePowerGold.class, 0.003125f);
        PipeTransportPower.setPowerResistance(PipePowerEmerald.class, 0.0f);
        PipeTransportPower.setPowerResistance(PipePowerDiamond.class, 0.0f);
        PipeTransportPower.setPowerLoss(PipePowerCobblestone.class, 0.25f);
        PipeTransportPower.setPowerLoss(PipePowerStone.class, 0.25f);
        PipeTransportPower.setPowerLoss(PipePowerSandstone.class, 0.2f);
        PipeTransportPower.setPowerLoss(PipePowerWood.class, 0.0f);
        PipeTransportPower.setPowerLoss(PipePowerQuartz.class, 2.0f);
        PipeTransportPower.setPowerLoss(PipePowerIron.class, 2.0f);
        PipeTransportPower.setPowerLoss(PipePowerGold.class, 4.0f);
        PipeTransportPower.setPowerLoss(PipePowerEmerald.class, 0.0f);
        PipeTransportPower.setPowerLoss(PipePowerDiamond.class, 0.5f);
    }

    public static enum LossMode {
        LOSSLESS,
        PERCENTAGE,
        ABSOLUTE;

    }
}

