/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.transport;

import buildcraft.BuildCraftTransport;
import buildcraft.api.core.BCLog;
import buildcraft.api.tiles.IDebuggable;
import buildcraft.api.transport.IPipeTile;
import buildcraft.core.DefaultProps;
import buildcraft.core.lib.inventory.ITransactor;
import buildcraft.core.lib.inventory.Transactor;
import buildcraft.core.lib.utils.Utils;
import buildcraft.transport.BlockGenericPipe;
import buildcraft.transport.Pipe;
import buildcraft.transport.PipeTransport;
import buildcraft.transport.TravelerSet;
import buildcraft.transport.TravelingItem;
import buildcraft.transport.network.PacketPipeTransportItemStackRequest;
import buildcraft.transport.network.PacketPipeTransportTraveler;
import buildcraft.transport.pipes.events.PipeEventItem;
import buildcraft.transport.utils.TransportUtils;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.Vec3;
import net.minecraft.util.Vec3i;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import org.apache.logging.log4j.Level;

public class PipeTransportItems
extends PipeTransport
implements IDebuggable {
    public static final int MAX_PIPE_STACKS = 64;
    public static final int MAX_PIPE_ITEMS = 1024;
    public boolean allowBouncing = false;
    public final TravelerSet items = new TravelerSet(this);

    @Override
    public IPipeTile.PipeType getPipeType() {
        return IPipeTile.PipeType.ITEM;
    }

    public void readjustSpeed(TravelingItem item) {
        PipeEventItem.AdjustSpeed event = new PipeEventItem.AdjustSpeed(this.container.pipe, item);
        this.container.pipe.eventBus.handleEvent(event);
        if (!event.handled) {
            this.defaultReadjustSpeed(item, event.slowdownAmount);
        }
    }

    protected void defaultReadjustSpeed(TravelingItem item, float slowdownAmount) {
        float speed = item.getSpeed();
        if (speed > 0.15f) {
            speed = 0.15f;
        }
        if (speed > 0.01f) {
            speed -= slowdownAmount;
        }
        if (speed < 0.01f) {
            speed = 0.01f;
        }
        item.setSpeed(speed);
    }

    private void readjustPosition(TravelingItem item) {
        Vec3 middle = Utils.convertMiddle((Vec3i)this.container.func_174877_v());
        Vec3 littleBitBelow0Point5 = new Vec3(0.49, 0.49, 0.49);
        Vec3 newPos = Utils.clamp(item.pos, middle.func_178788_d(littleBitBelow0Point5), middle.func_178787_e(littleBitBelow0Point5));
        if (item.input.func_176740_k() != EnumFacing.Axis.Y) {
            newPos = new Vec3(newPos.field_72450_a, (double)((float)this.container.func_174877_v().func_177956_o() + TransportUtils.getPipeFloorOf(item.getItemStack())), newPos.field_72449_c);
        }
        item.pos = newPos;
    }

    public void injectItem(TravelingItem item, EnumFacing inputOrientation) {
        if (item.isCorrupted()) {
            return;
        }
        item.reset();
        item.input = inputOrientation;
        this.readjustSpeed(item);
        this.readjustPosition(item);
        PipeEventItem.Entered event = new PipeEventItem.Entered(this.container.pipe, item);
        this.container.pipe.eventBus.handleEvent(event);
        if (event.cancelled) {
            return;
        }
        if (!this.container.func_145831_w().field_72995_K) {
            item.output = this.resolveDestination(item);
        }
        this.items.add(item);
        if (!this.container.func_145831_w().field_72995_K) {
            this.sendTravelerPacket(item, false);
            int itemStackCount = this.getNumberOfStacks();
            if (itemStackCount >= 32) {
                this.groupEntities();
                itemStackCount = this.getNumberOfStacks();
            }
            if (itemStackCount > 64) {
                BCLog.logger.log(Level.WARN, String.format("Pipe exploded at %s because it had too many stacks: %d", this.container.func_174877_v(), this.items.size()));
                this.destroyPipe();
                return;
            }
            int numItems = this.getNumberOfItems();
            if (numItems > 1024) {
                BCLog.logger.log(Level.WARN, String.format("Pipe exploded at %s, because it had too many items: %d", this.container.func_174877_v(), numItems));
                this.destroyPipe();
            }
        }
    }

    protected void reverseItem(TravelingItem item) {
        if (item.isCorrupted()) {
            return;
        }
        item.toCenter = true;
        item.input = item.output.func_176734_d();
        this.readjustSpeed(item);
        this.readjustPosition(item);
        PipeEventItem.Entered event = new PipeEventItem.Entered(this.container.pipe, item);
        this.container.pipe.eventBus.handleEvent(event);
        if (event.cancelled) {
            return;
        }
        if (!this.container.func_145831_w().field_72995_K) {
            item.output = this.resolveDestination(item);
        }
        this.items.unscheduleRemoval(item);
        if (!this.container.func_145831_w().field_72995_K) {
            this.sendTravelerPacket(item, true);
        }
    }

    public EnumFacing resolveDestination(TravelingItem data) {
        List<EnumFacing> validDestinations = this.getPossibleMovements(data);
        if (validDestinations.isEmpty()) {
            return null;
        }
        return validDestinations.get(0);
    }

    public List<EnumFacing> getPossibleMovements(TravelingItem item) {
        LinkedList<EnumFacing> result = new LinkedList<EnumFacing>();
        item.blacklist.add(item.input.func_176734_d());
        EnumSet<EnumFacing> sides = EnumSet.complementOf(item.blacklist);
        sides.remove(null);
        for (EnumFacing o : sides) {
            if (!this.container.pipe.outputOpen(o) || !this.canReceivePipeObjects(o, item)) continue;
            result.add(o);
        }
        PipeEventItem.FindDest event = new PipeEventItem.FindDest(this.container.pipe, item, result);
        this.container.pipe.eventBus.handleEvent(event);
        if (this.allowBouncing && result.isEmpty() && this.canReceivePipeObjects(item.input.func_176734_d(), item)) {
            result.add(item.input.func_176734_d());
        }
        if (event.shuffle) {
            Collections.shuffle(result);
        }
        return result;
    }

    private boolean canReceivePipeObjects(EnumFacing o, TravelingItem item) {
        ITransactor transactor;
        TileEntity entity = this.container.getTile(o);
        if (!this.container.isPipeConnected(o)) {
            return false;
        }
        if (entity instanceof IPipeTile) {
            Pipe pipe = (Pipe)((IPipeTile)entity).getPipe();
            if (pipe == null || pipe.transport == null) {
                return false;
            }
            return pipe.inputOpen(o.func_176734_d()) && pipe.transport instanceof PipeTransportItems;
        }
        return item.getInsertionHandler().canInsertItem(item, entity) && (transactor = Transactor.getTransactorFor(entity, o.func_176734_d())) != null && transactor.add((ItemStack)item.getItemStack(), (boolean)false).field_77994_a > 0;
    }

    @Override
    public void updateEntity() {
        this.moveSolids();
    }

    private void moveSolids() {
        this.items.flush();
        this.items.iterating = true;
        Iterator<TravelingItem> iterator = this.items.iterator();
        while (iterator.hasNext()) {
            TravelingItem item = iterator.next();
            if (item.getContainer() != this.container) {
                this.items.scheduleRemoval(item);
                continue;
            }
            EnumFacing face = item.toCenter ? item.input : item.output;
            item.movePosition(Utils.convert(face, item.getSpeed()));
            if (item.toCenter && this.middleReached(item) || this.outOfBounds(item)) {
                if (item.isCorrupted()) {
                    this.items.remove(item);
                    continue;
                }
                item.toCenter = false;
                item.pos = Utils.convert((Vec3i)this.container.func_174877_v()).func_178787_e(new Vec3(0.5, (double)TransportUtils.getPipeFloorOf(item.getItemStack()), 0.5));
                if (item.output == null) {
                    if (!this.items.scheduleRemoval(item)) continue;
                    this.dropItem(item);
                    continue;
                }
                PipeEventItem.ReachedCenter event = new PipeEventItem.ReachedCenter(this.container.pipe, item);
                this.container.pipe.eventBus.handleEvent(event);
                continue;
            }
            if (item.toCenter || !this.endReached(item)) continue;
            if (item.isCorrupted()) {
                this.items.remove(item);
                continue;
            }
            if (item.output == null) {
                this.items.scheduleRemoval(item);
                BCLog.logger.warn("Glitched item [Output direction UNKNOWN] removed from world @ " + this.container.func_174877_v().func_177958_n() + ", " + this.container.func_174877_v().func_177956_o() + ", " + this.container.func_174877_v().func_177952_p() + "!");
                continue;
            }
            TileEntity tile = this.container.getTile(item.output, true);
            PipeEventItem.ReachedEnd event = new PipeEventItem.ReachedEnd(this.container.pipe, item, tile);
            this.container.pipe.eventBus.handleEvent(event);
            boolean handleItem = !event.handled;
            if (!handleItem || !this.items.scheduleRemoval(item)) continue;
            this.handleTileReached(item, tile);
        }
        this.items.iterating = false;
        this.items.flush();
    }

    private boolean passToNextPipe(TravelingItem item, TileEntity tile) {
        Pipe pipe;
        if (tile instanceof IPipeTile && BlockGenericPipe.isValid(pipe = (Pipe)((IPipeTile)tile).getPipe()) && pipe.transport instanceof PipeTransportItems) {
            ((PipeTransportItems)pipe.transport).injectItem(item, item.output);
            return true;
        }
        return false;
    }

    private void handleTileReached(TravelingItem item, TileEntity tile) {
        if (!this.passToNextPipe(item, tile)) {
            boolean handled = false;
            if (!this.container.func_145831_w().field_72995_K) {
                ITransactor transactor;
                if (item.getInsertionHandler().canInsertItem(item, tile) && (transactor = Transactor.getTransactorFor(tile, item.output.func_176734_d())) != null) {
                    handled = true;
                    ItemStack added = transactor.add(item.getItemStack(), true);
                    item.getItemStack().field_77994_a -= added.field_77994_a;
                }
                if (!handled) {
                    this.dropItem(item);
                } else if (item.getItemStack().field_77994_a > 0) {
                    this.reverseItem(item);
                }
            }
        }
    }

    private void dropItem(TravelingItem item) {
        if (this.container.func_145831_w().field_72995_K) {
            return;
        }
        PipeEventItem.DropItem event = new PipeEventItem.DropItem(this.container.pipe, item, item.toEntityItem());
        this.container.pipe.eventBus.handleEvent(event);
        if (event.entity == null) {
            return;
        }
        EntityItem entity = event.entity;
        EnumFacing direction = item.input;
        entity.func_70107_b(entity.field_70165_t + (double)direction.func_82601_c() * 0.5, entity.field_70163_u + (double)direction.func_96559_d() * 0.5, entity.field_70161_v + (double)direction.func_82599_e() * 0.5);
        entity.field_70159_w = (double)((float)direction.func_82601_c() * item.speed * 5.0f) + this.getWorld().field_73012_v.nextGaussian() * 0.1;
        entity.field_70181_x = (double)((float)direction.func_96559_d() * item.speed * 5.0f) + this.getWorld().field_73012_v.nextGaussian() * 0.1;
        entity.field_70179_y = (double)((float)direction.func_82599_e() * item.speed * 5.0f) + this.getWorld().field_73012_v.nextGaussian() * 0.1;
        this.container.func_145831_w().func_72838_d((Entity)entity);
    }

    protected boolean middleReached(TravelingItem item) {
        float middleLimit = Math.abs(item.getSpeed() * 1.01f);
        return Math.abs((double)this.container.func_174877_v().func_177958_n() + 0.5 - item.pos.field_72450_a) < (double)middleLimit && Math.abs((double)((float)this.container.func_174877_v().func_177956_o() + TransportUtils.getPipeFloorOf(item.getItemStack())) - item.pos.field_72448_b) < (double)middleLimit && Math.abs((double)this.container.func_174877_v().func_177952_p() + 0.5 - item.pos.field_72449_c) < (double)middleLimit;
    }

    protected boolean endReached(TravelingItem item) {
        return item.pos.func_72438_d(Utils.convertMiddle((Vec3i)this.container.func_174877_v())) > 0.65;
    }

    protected boolean outOfBounds(TravelingItem item) {
        return item.pos.func_72438_d(Utils.convertMiddle((Vec3i)this.container.func_174877_v())) > 1.0;
    }

    public Vec3 getPosition() {
        return Utils.convert((Vec3i)this.container.func_174877_v());
    }

    @Override
    public void readFromNBT(NBTTagCompound nbt) {
        super.readFromNBT(nbt);
        NBTTagList nbttaglist = nbt.func_150295_c("travelingEntities", 10);
        for (int j = 0; j < nbttaglist.func_74745_c(); ++j) {
            try {
                NBTTagCompound dataTag = nbttaglist.func_150305_b(j);
                TravelingItem item = TravelingItem.make(dataTag);
                if (item.isCorrupted()) continue;
                this.items.scheduleLoad(item);
                continue;
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }

    @Override
    public void writeToNBT(NBTTagCompound nbt) {
        super.writeToNBT(nbt);
        NBTTagList nbttaglist = new NBTTagList();
        Iterator<TravelingItem> iterator = this.items.iterator();
        while (iterator.hasNext()) {
            TravelingItem item = iterator.next();
            NBTTagCompound dataTag = new NBTTagCompound();
            nbttaglist.func_74742_a((NBTBase)dataTag);
            item.writeToNBT(dataTag);
        }
        nbt.func_74782_a("travelingEntities", (NBTBase)nbttaglist);
    }

    protected void doWork() {
    }

    public void handleTravelerPacket(PacketPipeTransportTraveler packet) {
        TravelingItem item = TravelingItem.clientCache.get(packet.getTravelingEntityId());
        if (item == null) {
            item = TravelingItem.make(packet.getTravelingEntityId());
        }
        if (item.getContainer() != this.container) {
            this.items.add(item);
        }
        if (packet.forceStackRefresh() || item.getItemStack() == null) {
            BuildCraftTransport.instance.sendToServer(new PacketPipeTransportItemStackRequest(this.container, packet));
        }
        item.pos = packet.getItemPos();
        item.setSpeed(packet.getSpeed());
        item.toCenter = true;
        item.input = packet.getInputOrientation();
        item.output = packet.getOutputOrientation();
        item.color = packet.getColor();
    }

    private void sendTravelerPacket(TravelingItem data, boolean forceStackRefresh) {
        PacketPipeTransportTraveler packet = new PacketPipeTransportTraveler(this.container, data, forceStackRefresh);
        BuildCraftTransport.instance.sendToPlayers(packet, this.container.func_145831_w(), this.container.func_174877_v(), DefaultProps.PIPE_CONTENTS_RENDER_DIST);
    }

    public int getNumberOfStacks() {
        int num = 0;
        Iterator<TravelingItem> iterator = this.items.iterator();
        while (iterator.hasNext()) {
            TravelingItem item = iterator.next();
            if (item.ignoreWeight()) continue;
            ++num;
        }
        return num;
    }

    public int getNumberOfItems() {
        int num = 0;
        Iterator<TravelingItem> iterator = this.items.iterator();
        while (iterator.hasNext()) {
            TravelingItem item = iterator.next();
            if (item.ignoreWeight() || item.getItemStack() == null) continue;
            num += item.getItemStack().field_77994_a;
        }
        return num;
    }

    protected void neighborChange() {
    }

    @Override
    public boolean canPipeConnect(TileEntity tile, EnumFacing side) {
        Pipe pipe2;
        if (tile == null) {
            return false;
        }
        if (tile instanceof IPipeTile && BlockGenericPipe.isValid(pipe2 = (Pipe)((IPipeTile)tile).getPipe()) && !(pipe2.transport instanceof PipeTransportItems)) {
            return false;
        }
        if (tile.hasCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, side.func_176734_d())) {
            return ((IItemHandler)tile.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, side.func_176734_d())).getSlots() > 0;
        }
        if (tile instanceof ISidedInventory) {
            int[] slots = ((ISidedInventory)tile).func_180463_a(side.func_176734_d());
            return slots != null && slots.length > 0;
        }
        return tile instanceof IPipeTile || tile instanceof IInventory && ((IInventory)tile).func_70302_i_() > 0;
    }

    public void groupEntities() {
        Iterator<TravelingItem> iterator = this.items.iterator();
        while (iterator.hasNext()) {
            TravelingItem otherItem;
            TravelingItem item = iterator.next();
            if (item.isCorrupted()) continue;
            Iterator<TravelingItem> iterator2 = this.items.iterator();
            while (iterator2.hasNext() && !item.tryMergeInto(otherItem = iterator2.next())) {
            }
        }
    }

    @Override
    public void dropContents() {
        this.groupEntities();
        Iterator<TravelingItem> iterator = this.items.iterator();
        while (iterator.hasNext()) {
            TravelingItem item = iterator.next();
            if (item.isCorrupted()) continue;
            this.container.pipe.dropItem(item.getItemStack());
        }
        this.items.clear();
    }

    @Override
    public List<ItemStack> getDroppedItems() {
        this.groupEntities();
        ArrayList<ItemStack> itemsDropped = new ArrayList<ItemStack>(this.items.size());
        Iterator<TravelingItem> iterator = this.items.iterator();
        while (iterator.hasNext()) {
            TravelingItem item = iterator.next();
            if (item.isCorrupted()) continue;
            itemsDropped.add(item.getItemStack());
        }
        return itemsDropped;
    }

    @Override
    public boolean delveIntoUnloadedChunks() {
        return true;
    }

    @Override
    public void getDebugInfo(List<String> left, List<String> right, EnumFacing side) {
        left.add("");
        left.add("PipeTransportItems");
        left.add("- Items: " + this.getNumberOfStacks() + "/" + 64 + " (" + this.getNumberOfItems() + "/" + 1024 + ")");
        Iterator<TravelingItem> iterator = this.items.iterator();
        while (iterator.hasNext()) {
            TravelingItem item = iterator.next();
            left.add("");
            left.add("  - " + item.itemStack);
            left.add("    - pos = " + item.pos);
            left.add("    - middle = " + this.middleReached(item));
            left.add("    - end = " + this.endReached(item));
            left.add("    - out of boounds = " + this.outOfBounds(item));
        }
    }
}

