/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.silicon.gui;

import buildcraft.BuildCraftCore;
import buildcraft.core.client.CoreIconProvider;
import buildcraft.core.lib.gui.AdvancedSlot;
import buildcraft.core.lib.gui.GuiAdvancedInterface;
import buildcraft.core.lib.gui.Ledger;
import buildcraft.core.lib.utils.BCStringUtils;
import buildcraft.silicon.TileProgrammingTable;
import buildcraft.silicon.gui.ContainerProgrammingTable;
import java.util.Iterator;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import org.lwjgl.opengl.GL11;

public class GuiProgrammingTable
extends GuiAdvancedInterface {
    private static final ResourceLocation TEXTURE = new ResourceLocation("buildcraftsilicon:textures/gui/programming_table.png");
    private final TileProgrammingTable table;

    public GuiProgrammingTable(EntityPlayer player, TileProgrammingTable programmingTable) {
        super(new ContainerProgrammingTable(player, programmingTable), programmingTable, TEXTURE);
        this.table = programmingTable;
        this.field_146999_f = 176;
        this.field_147000_g = 207;
        for (int j = 0; j < 4; ++j) {
            for (int i = 0; i < 6; ++i) {
                this.slots.add(new RecipeSlot(43 + 18 * i, 36 + 18 * j, j * 6 + i));
            }
        }
        this.updateRecipes();
    }

    public void updateRecipes() {
        if (this.table.options != null) {
            Iterator<ItemStack> cur = this.table.options.iterator();
            for (AdvancedSlot s : this.slots) {
                if (cur.hasNext()) {
                    ((RecipeSlot)s).slot = cur.next();
                    continue;
                }
                ((RecipeSlot)s).slot = null;
            }
        } else {
            for (AdvancedSlot s : this.slots) {
                ((RecipeSlot)s).slot = null;
            }
        }
    }

    @Override
    protected void func_146979_b(int par1, int par2) {
        super.func_146979_b(par1, par2);
        String title = BCStringUtils.localize("tile.programmingTableBlock.name");
        this.field_146289_q.func_78276_b(title, this.getCenteredOffset(title), 15, 0x404040);
        this.field_146289_q.func_78276_b(BCStringUtils.localize("gui.inventory"), 8, this.field_147000_g - 97, 0x404040);
        this.drawTooltipForSlotAt(par1, par2);
    }

    @Override
    protected void func_146976_a(float f, int x, int y) {
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.field_146297_k.field_71446_o.func_110577_a(TEXTURE);
        this.func_73729_b(this.field_147003_i, this.field_147009_r, 0, 0, this.field_146999_f, this.field_147000_g);
        this.updateRecipes();
        int i = 0;
        for (AdvancedSlot slot2 : this.slots) {
            RecipeSlot slot = (RecipeSlot)slot2;
            if (slot.slot != null && this.table.optionId == i) {
                this.func_73729_b(this.field_147003_i + slot.x, this.field_147009_r + slot.y, 196, 1, 16, 16);
            }
            ++i;
        }
        int h = this.table.getProgressScaled(70);
        this.func_73729_b(this.field_147003_i + 164, this.field_147009_r + 36 + 70 - h, 176, 18, 4, h);
        this.drawBackgroundSlots(x, y);
    }

    @Override
    protected void slotClicked(AdvancedSlot aslot, int mouseButton) {
        super.slotClicked(aslot, mouseButton);
        if (aslot instanceof RecipeSlot) {
            RecipeSlot slot = (RecipeSlot)aslot;
            if (slot.slot == null) {
                return;
            }
            if (this.table.optionId == slot.id) {
                this.table.rpcSelectOption(-1);
            } else {
                this.table.rpcSelectOption(slot.id);
            }
        }
    }

    @Override
    protected void initLedgers(IInventory inventory) {
        super.initLedgers(inventory);
        if (!BuildCraftCore.hidePowerNumbers) {
            this.ledgerManager.add(new LaserTableLedger());
        }
    }

    class RecipeSlot
    extends AdvancedSlot {
        public ItemStack slot;
        public int id;

        public RecipeSlot(int x, int y, int i) {
            super(GuiProgrammingTable.this, x, y);
            this.id = i;
        }

        @Override
        public ItemStack getItemStack() {
            return this.slot;
        }
    }

    private class LaserTableLedger
    extends Ledger {
        int headerColour;
        int subheaderColour;
        int textColour;

        public LaserTableLedger() {
            super(GuiProgrammingTable.this);
            this.headerColour = 14797103;
            this.subheaderColour = 11186104;
            this.textColour = 0;
            this.maxHeight = 94;
            this.overlayColor = 13921311;
        }

        @Override
        public void draw(int x, int y) {
            this.drawBackground(x, y);
            Minecraft.func_71410_x().field_71446_o.func_110577_a(TextureMap.field_110575_b);
            this.drawIcon(CoreIconProvider.ENERGY.getSprite(), x + 3, y + 4);
            if (!this.isFullyOpened()) {
                return;
            }
            GuiProgrammingTable.this.field_146289_q.func_175063_a(BCStringUtils.localize("gui.energy"), (float)(x + 22), (float)(y + 8), this.headerColour);
            GuiProgrammingTable.this.field_146289_q.func_175063_a(BCStringUtils.localize("gui.assemblyCurrentRequired") + ":", (float)(x + 22), (float)(y + 20), this.subheaderColour);
            GuiProgrammingTable.this.field_146289_q.func_78276_b(String.format("%d RF", ((GuiProgrammingTable)GuiProgrammingTable.this).table.clientRequiredEnergy), x + 22, y + 32, this.textColour);
            GuiProgrammingTable.this.field_146289_q.func_175063_a(BCStringUtils.localize("gui.stored") + ":", (float)(x + 22), (float)(y + 44), this.subheaderColour);
            GuiProgrammingTable.this.field_146289_q.func_78276_b(String.format("%d RF", GuiProgrammingTable.this.table.getEnergy()), x + 22, y + 56, this.textColour);
            GuiProgrammingTable.this.field_146289_q.func_175063_a(BCStringUtils.localize("gui.assemblyRate") + ":", (float)(x + 22), (float)(y + 68), this.subheaderColour);
            GuiProgrammingTable.this.field_146289_q.func_78276_b(String.format("%.1f RF/t", Float.valueOf((float)GuiProgrammingTable.this.table.getRecentEnergyAverage() / 100.0f)), x + 22, y + 80, this.textColour);
        }

        @Override
        public String getTooltip() {
            return String.format("%.1f RF/t", Float.valueOf((float)GuiProgrammingTable.this.table.getRecentEnergyAverage() / 100.0f));
        }
    }
}

