/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.silicon.gui;

import buildcraft.BuildCraftCore;
import buildcraft.core.client.CoreIconProvider;
import buildcraft.core.lib.gui.BuildCraftContainer;
import buildcraft.core.lib.gui.GuiBuildCraft;
import buildcraft.core.lib.gui.Ledger;
import buildcraft.core.lib.utils.BCStringUtils;
import buildcraft.silicon.TileLaserTableBase;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.util.ResourceLocation;

public abstract class GuiLaserTable
extends GuiBuildCraft {
    protected final TileLaserTableBase table;

    public GuiLaserTable(EntityPlayer player, BuildCraftContainer container, TileLaserTableBase table, ResourceLocation texture) {
        super(container, table, texture);
        this.table = table;
    }

    @Override
    protected void func_146979_b(int par1, int par2) {
        super.func_146979_b(par1, par2);
        String title = this.table.getInventoryName();
        this.field_146289_q.func_78276_b(title, this.getCenteredOffset(title), 6, 0x404040);
        this.field_146289_q.func_78276_b(BCStringUtils.localize("gui.inventory"), 8, this.field_147000_g - 97, 0x404040);
    }

    @Override
    protected void initLedgers(IInventory inventory) {
        super.initLedgers(inventory);
        if (!BuildCraftCore.hidePowerNumbers) {
            this.ledgerManager.add(new LaserTableLedger());
        }
    }

    private class LaserTableLedger
    extends Ledger {
        int headerColour;
        int subheaderColour;
        int textColour;

        public LaserTableLedger() {
            super(GuiLaserTable.this);
            this.headerColour = 14797103;
            this.subheaderColour = 11186104;
            this.textColour = 0;
            this.maxHeight = 94;
            this.overlayColor = 13921311;
        }

        @Override
        public void draw(int x, int y) {
            this.drawBackground(x, y);
            Minecraft.func_71410_x().field_71446_o.func_110577_a(TextureMap.field_110575_b);
            this.drawIcon(CoreIconProvider.ENERGY.getSprite(), x + 3, y + 4);
            if (!this.isFullyOpened()) {
                return;
            }
            GuiLaserTable.this.field_146289_q.func_175063_a(BCStringUtils.localize("gui.energy"), (float)(x + 22), (float)(y + 8), this.headerColour);
            GuiLaserTable.this.field_146289_q.func_175063_a(BCStringUtils.localize("gui.assemblyCurrentRequired") + ":", (float)(x + 22), (float)(y + 20), this.subheaderColour);
            GuiLaserTable.this.field_146289_q.func_78276_b(String.format("%d RF", GuiLaserTable.this.table.clientRequiredEnergy), x + 22, y + 32, this.textColour);
            GuiLaserTable.this.field_146289_q.func_175063_a(BCStringUtils.localize("gui.stored") + ":", (float)(x + 22), (float)(y + 44), this.subheaderColour);
            GuiLaserTable.this.field_146289_q.func_78276_b(String.format("%d RF", GuiLaserTable.this.table.getEnergy()), x + 22, y + 56, this.textColour);
            GuiLaserTable.this.field_146289_q.func_175063_a(BCStringUtils.localize("gui.assemblyRate") + ":", (float)(x + 22), (float)(y + 68), this.subheaderColour);
            GuiLaserTable.this.field_146289_q.func_78276_b(String.format("%.1f RF/t", Float.valueOf((float)GuiLaserTable.this.table.getRecentEnergyAverage() / 100.0f)), x + 22, y + 80, this.textColour);
        }

        @Override
        public String getTooltip() {
            return String.format("%.1f RF/t", Float.valueOf((float)GuiLaserTable.this.table.getRecentEnergyAverage() / 100.0f));
        }
    }
}

