/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.robotics.render;

import buildcraft.BuildCraftCore;
import buildcraft.api.transport.pluggable.IPluggableModelBaker;
import buildcraft.core.lib.client.model.BCModelHelper;
import buildcraft.core.lib.client.model.BakedModelHolder;
import buildcraft.core.lib.client.model.BuildCraftBakedModel;
import buildcraft.core.lib.client.model.MutableQuad;
import buildcraft.core.lib.client.model.PerspAwareModelBase;
import buildcraft.core.lib.utils.MatrixUtils;
import buildcraft.robotics.RobotStationPluggable;
import buildcraft.robotics.render.ModelKeyStation;
import com.google.common.base.Function;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.vecmath.Matrix4f;
import javax.vecmath.Vector3f;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.client.renderer.vertex.VertexFormat;
import net.minecraft.client.resources.model.ModelRotation;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.event.TextureStitchEvent;
import net.minecraftforge.client.model.IFlexibleBakedModel;
import net.minecraftforge.client.model.IModel;
import net.minecraftforge.client.model.IModelState;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;

public class RobotStationModel
extends BakedModelHolder
implements IPluggableModelBaker<ModelKeyStation> {
    public static final RobotStationModel INSTANCE = new RobotStationModel();
    private static final ResourceLocation baseLoc = new ResourceLocation("buildcraftrobotics:models/pluggables/robot_station_base.obj");
    private TextureAtlasSprite baseSprite;
    private final Map<RobotStationPluggable.EnumRobotStationState, TextureAtlasSprite> stateSprites = Maps.newEnumMap(RobotStationPluggable.EnumRobotStationState.class);
    private final Map<RobotStationPluggable.EnumRobotStationState, List<MutableQuad>> stateQuads = Maps.newEnumMap(RobotStationPluggable.EnumRobotStationState.class);
    private final List<MutableQuad> modelBaseQuads = new ArrayList<MutableQuad>();

    private IModel modelBase() {
        return this.getModelOBJ(baseLoc);
    }

    public PerspAwareModelBase createItemModel() {
        ImmutableList.Builder quads = ImmutableList.builder();
        VertexFormat format = DefaultVertexFormats.field_176599_b;
        quads.addAll(INSTANCE.bakeCutout(RobotStationPluggable.EnumRobotStationState.Available, EnumFacing.SOUTH, format));
        return new PerspAwareModelBase(format, (ImmutableList<BakedQuad>)quads.build(), this.baseSprite, RobotStationModel.getPluggableTransforms());
    }

    @SubscribeEvent
    public void textureStitchPre(TextureStitchEvent.Pre pre) {
        TextureMap map = pre.map;
        this.baseSprite = null;
        this.baseSprite = map.getTextureExtry("buildcraftrobotics:station/base");
        if (this.baseSprite == null) {
            this.baseSprite = map.func_174942_a(new ResourceLocation("buildcraftrobotics:station/base"));
        }
        for (RobotStationPluggable.EnumRobotStationState state : RobotStationPluggable.EnumRobotStationState.values()) {
            String suffix = state.getTextureSuffix() + (BuildCraftCore.colorBlindMode ? "_cb" : "");
            ResourceLocation location = new ResourceLocation("buildcraftrobotics:station/state_" + suffix);
            TextureAtlasSprite sprite = map.getTextureExtry(location.toString());
            if (sprite == null) {
                sprite = map.func_174942_a(location);
            }
            this.stateSprites.put(state, sprite);
        }
    }

    @SubscribeEvent
    public void textureStitchPost(TextureStitchEvent.Post post) {
        for (RobotStationPluggable.EnumRobotStationState state : RobotStationPluggable.EnumRobotStationState.values()) {
            Matrix4f translation = new Matrix4f();
            translation.setIdentity();
            translation.setTranslation(new Vector3f(0.175f, 0.0f, 0.0f));
            ArrayList quads = Lists.newArrayList();
            for (MutableQuad mutable : BuildCraftBakedModel.createQuadsItemLayer(this.stateSprites.get((Object)state))) {
                mutable.transform(translation);
                mutable.colouri(-1);
                quads.add(mutable);
            }
            this.stateQuads.put(state, quads);
        }
    }

    @Override
    public VertexFormat getVertexFormat() {
        return DefaultVertexFormats.field_176600_a;
    }

    @Override
    public ImmutableList<BakedQuad> bake(ModelKeyStation key) {
        return ImmutableList.copyOf(this.bakeCutout(key.state, key.side, this.getVertexFormat()));
    }

    private List<MutableQuad> baseQuads() {
        IModel base;
        if (this.modelBaseQuads.isEmpty() && (base = this.modelBase()) != null) {
            Function<ResourceLocation, TextureAtlasSprite> singleTextureFunction = BuildCraftBakedModel.singleTextureFunction(this.baseSprite);
            IFlexibleBakedModel baked = base.bake((IModelState)ModelRotation.X0_Y0, DefaultVertexFormats.field_176600_a, singleTextureFunction);
            for (BakedQuad quad : baked.func_177550_a()) {
                MutableQuad mutable = MutableQuad.create(quad);
                this.modelBaseQuads.add(mutable);
            }
        }
        return this.modelBaseQuads;
    }

    private List<BakedQuad> bakeCutout(RobotStationPluggable.EnumRobotStationState state, EnumFacing face, VertexFormat format) {
        IModel base = this.modelBase();
        List<MutableQuad> stateQuads = this.stateQuads.get((Object)state);
        ArrayList quads = Lists.newArrayList();
        if (base != null) {
            float diffuse;
            Vector3f normal;
            Matrix4f matrix = MatrixUtils.rotateTowardsFace(face);
            for (MutableQuad mutable : this.baseQuads()) {
                mutable = new MutableQuad(mutable);
                mutable.transform(matrix);
                normal = mutable.getCalculatedNormal();
                mutable.normalv(normal);
                diffuse = MutableQuad.diffuseLight(normal);
                mutable.colourf(diffuse, diffuse, diffuse, 1.0f);
                BCModelHelper.appendBakeQuads((List<BakedQuad>)quads, format, mutable);
            }
            if (stateQuads != null) {
                for (MutableQuad mutable : stateQuads) {
                    mutable = new MutableQuad(mutable);
                    mutable.transform(matrix);
                    normal = mutable.getCalculatedNormal();
                    mutable.normalv(normal);
                    diffuse = MutableQuad.diffuseLight(normal);
                    mutable.colourf(diffuse, diffuse, diffuse, 1.0f);
                    BCModelHelper.appendBakeQuads((List<BakedQuad>)quads, format, mutable);
                }
            }
        }
        return quads;
    }
}

