/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.robotics.render;

import buildcraft.core.lib.client.sprite.DynamicTextureBC;
import buildcraft.robotics.TileZonePlan;
import java.util.HashMap;
import net.minecraft.block.material.MapColor;
import net.minecraft.client.renderer.tileentity.TileEntitySpecialRenderer;
import org.lwjgl.opengl.GL11;

public class RenderZonePlan
extends TileEntitySpecialRenderer<TileZonePlan> {
    private static final float Z_OFFSET = 1.0004883f;
    private static final HashMap<TileZonePlan, DynamicTextureBC> TEXTURES = new HashMap();

    public void renderTileEntityAt(TileZonePlan zonePlan, double tx, double ty, double tz, float partialTicks, int arg) {
        DynamicTextureBC textureBC;
        boolean rendered = true;
        TileZonePlan tile = zonePlan;
        if (!TEXTURES.containsKey(zonePlan)) {
            textureBC = new DynamicTextureBC(16, 16);
            TEXTURES.put(zonePlan, textureBC);
            rendered = false;
        }
        textureBC = TEXTURES.get(zonePlan);
        byte[] previewColors = zonePlan.getPreviewTexture(!rendered);
        if (previewColors != null) {
            for (int y = 0; y < 8; ++y) {
                for (int x = 0; x < 10; ++x) {
                    int col = MapColor.field_76281_a[previewColors[y * 10 + x]].field_76291_p;
                    if ((x & 1) != (y & 1)) {
                        int ocol = col;
                        col = (ocol & 0xFF) * 15 / 16 | ((ocol & 0xFF00) >> 8) * 15 / 16 << 8 | ((ocol & 0xFF0000) >> 16) * 15 / 16 << 16;
                    }
                    textureBC.setColor(x + 3, y + 3, 0xFF000000 | col);
                }
            }
        }
        GL11.glPushMatrix();
        GL11.glPushAttrib((int)16384);
        GL11.glTranslatef((float)((float)tx + 0.5f), (float)((float)ty + 0.5f), (float)((float)tz + 0.5f));
        GL11.glScalef((float)1.0004883f, (float)1.0004883f, (float)1.0004883f);
        GL11.glTranslatef((float)-0.5f, (float)-0.5f, (float)-0.5f);
        GL11.glEnable((int)3042);
        GL11.glBlendFunc((int)770, (int)1);
        textureBC.updateTexture();
        GL11.glPopAttrib();
        GL11.glPopMatrix();
    }
}

