/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.robotics.render;

import buildcraft.BuildCraftRobotics;
import buildcraft.api.robots.IRobotOverlayItem;
import buildcraft.core.DefaultProps;
import buildcraft.core.EntityLaser;
import buildcraft.core.lib.client.render.RenderUtils;
import buildcraft.core.lib.utils.Utils;
import buildcraft.core.render.RenderLaser;
import buildcraft.robotics.EntityRobot;
import com.mojang.authlib.GameProfile;
import java.util.Date;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.client.model.ModelBase;
import net.minecraft.client.model.ModelBiped;
import net.minecraft.client.model.ModelRenderer;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.OpenGlHelper;
import net.minecraft.client.renderer.block.model.ItemCameraTransforms;
import net.minecraft.client.renderer.entity.Render;
import net.minecraft.client.renderer.entity.RenderEntityItem;
import net.minecraft.client.renderer.entity.RenderManager;
import net.minecraft.client.renderer.entity.RenderPlayer;
import net.minecraft.client.renderer.entity.RendererLivingEntity;
import net.minecraft.client.renderer.entity.layers.LayerBipedArmor;
import net.minecraft.client.renderer.texture.TextureManager;
import net.minecraft.client.renderer.tileentity.TileEntitySkullRenderer;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.item.ItemArmor;
import net.minecraft.item.ItemSkull;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTUtil;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.StringUtils;
import net.minecraftforge.client.ForgeHooksClient;
import org.lwjgl.opengl.GL11;

public class RenderRobot
extends Render<EntityRobot> {
    private static final ResourceLocation overlay_red = new ResourceLocation(DefaultProps.TEXTURE_PATH_ROBOTS + "/overlay_side.png");
    private static final ResourceLocation overlay_cyan = new ResourceLocation(DefaultProps.TEXTURE_PATH_ROBOTS + "/overlay_bottom.png");
    private final EntityItem dummyEntityItem = new EntityItem(null);
    private final RenderEntityItem customRenderItem;
    private final LayerBipedArmor armorRenderer;
    private ModelBase model = new ModelBase(){};
    private ModelBase modelHelmet = new ModelBase(){};
    private ModelBase modelSkullOverlay = new ModelBase(){};
    private ModelRenderer skullOverlayBox;
    private ModelRenderer box;
    private ModelRenderer helmetBox;

    public RenderRobot(RenderManager manager) {
        super(manager);
        this.customRenderItem = new RenderEntityItem(manager, Minecraft.func_71410_x().func_175599_af()){

            public boolean shouldBob() {
                return false;
            }

            public boolean shouldSpreadItems() {
                return false;
            }
        };
        this.armorRenderer = new LayerBipedArmor((RendererLivingEntity)new RenderPlayer(manager));
        this.box = new ModelRenderer(this.model, 0, 0);
        this.box.func_78787_b(32, 32);
        this.box.func_78789_a(-4.0f, -4.0f, -4.0f, 8, 8, 8);
        this.box.func_78793_a(0.0f, 0.0f, 0.0f);
        this.helmetBox = new ModelRenderer(this.modelHelmet, 0, 0);
        this.helmetBox.func_78789_a(-4.0f, -8.0f, -4.0f, 8, 8, 8);
        this.helmetBox.func_78793_a(0.0f, 0.0f, 0.0f);
        this.skullOverlayBox = new ModelRenderer(this.modelSkullOverlay, 32, 0);
        this.skullOverlayBox.func_78790_a(-4.0f, -8.0f, -4.0f, 8, 8, 8, 0.5f);
        this.skullOverlayBox.func_78793_a(0.0f, 0.0f, 0.0f);
    }

    public void doRender(EntityRobot robot, double x, double y, double z, float f, float f1) {
        GL11.glPushMatrix();
        GL11.glTranslated((double)x, (double)y, (double)z);
        float robotYaw = this.interpolateRotation(robot.field_70760_ar, robot.field_70761_aq, f1);
        GL11.glRotatef((float)(-robotYaw), (float)0.0f, (float)1.0f, (float)0.0f);
        boolean glasses = RenderRobot.isWearingGlasses();
        if (glasses) {
            GlStateManager.func_179090_x();
        } else {
            if (robot.func_70301_a(0) != null) {
                GL11.glPushMatrix();
                GL11.glTranslatef((float)-0.125f, (float)0.0f, (float)-0.125f);
                this.doRenderItem(robot.func_70301_a(0));
                GL11.glColor3f((float)1.0f, (float)1.0f, (float)1.0f);
                GL11.glPopMatrix();
            }
            if (robot.func_70301_a(1) != null) {
                GL11.glPushMatrix();
                GL11.glTranslatef((float)0.125f, (float)0.0f, (float)-0.125f);
                this.doRenderItem(robot.func_70301_a(1));
                GL11.glColor3f((float)1.0f, (float)1.0f, (float)1.0f);
                GL11.glPopMatrix();
            }
            if (robot.func_70301_a(2) != null) {
                GL11.glPushMatrix();
                GL11.glTranslatef((float)0.125f, (float)0.0f, (float)0.125f);
                this.doRenderItem(robot.func_70301_a(2));
                GL11.glColor3f((float)1.0f, (float)1.0f, (float)1.0f);
                GL11.glPopMatrix();
            }
            if (robot.func_70301_a(3) != null) {
                GL11.glPushMatrix();
                GL11.glTranslatef((float)-0.125f, (float)0.0f, (float)0.125f);
                this.doRenderItem(robot.func_70301_a(3));
                GL11.glColor3f((float)1.0f, (float)1.0f, (float)1.0f);
                GL11.glPopMatrix();
            }
            if (robot.itemInUse != null) {
                GL11.glPushMatrix();
                GL11.glRotatef((float)robot.itemAimPitch, (float)0.0f, (float)0.0f, (float)1.0f);
                if (robot.itemActive) {
                    long newDate = new Date().getTime();
                    robot.itemActiveStage = (robot.itemActiveStage + (float)((newDate - robot.lastUpdateTime) / 10L)) % 45.0f;
                    GL11.glRotatef((float)robot.itemActiveStage, (float)0.0f, (float)0.0f, (float)1.0f);
                    robot.lastUpdateTime = newDate;
                }
                GL11.glTranslatef((float)-0.4f, (float)0.0f, (float)0.0f);
                GL11.glRotatef((float)135.0f, (float)0.0f, (float)1.0f, (float)0.0f);
                GL11.glScalef((float)0.8f, (float)0.8f, (float)0.8f);
                ItemStack itemstack1 = robot.itemInUse;
                RenderUtils.setGLColorFromInt(itemstack1.func_77973_b().func_82790_a(itemstack1, 0));
                Minecraft.func_71410_x().func_175597_ag().func_178099_a((EntityLivingBase)robot, itemstack1, ItemCameraTransforms.TransformType.THIRD_PERSON);
                GL11.glColor3f((float)1.0f, (float)1.0f, (float)1.0f);
                GL11.glPopMatrix();
            }
        }
        if (robot.laser.isVisible) {
            robot.laser.head = Utils.getVec((Entity)robot);
            RenderLaser.doRenderLaser(robot.field_70170_p, this.field_76990_c.field_78724_e, robot.laser, EntityLaser.LASER_YELLOW);
        }
        if (robot.getTexture() != null) {
            this.field_76990_c.field_78724_e.func_110577_a(robot.getTexture());
            float storagePercent = (float)robot.getBattery().getEnergyStored() / (float)robot.getBattery().getMaxEnergyStored();
            if (robot.field_70737_aN > 0) {
                GL11.glColor3f((float)1.0f, (float)0.6f, (float)0.6f);
                GL11.glRotatef((float)((float)robot.field_70737_aN * 0.01f), (float)0.0f, (float)0.0f, (float)1.0f);
            }
            this.doRenderRobot(0.0625f, this.field_76990_c.field_78724_e, storagePercent, robot.isActive());
        }
        if (glasses) {
            GlStateManager.func_179098_w();
        } else {
            for (ItemStack s : robot.getWearables()) {
                this.doRenderWearable(robot, this.field_76990_c.field_78724_e, s);
            }
        }
        GL11.glPopMatrix();
    }

    private static boolean isWearingGlasses() {
        EntityPlayerSP player = Minecraft.func_71410_x().field_71439_g;
        ItemStack helmet = player.func_82169_q(3);
        return helmet != null && helmet.func_77973_b() == BuildCraftRobotics.robotGoggles;
    }

    protected ResourceLocation getEntityTexture(EntityRobot entity) {
        return entity.getTexture();
    }

    private void doRenderItem(ItemStack stack) {
        float renderScale = 0.5f;
        GL11.glPushMatrix();
        GL11.glTranslatef((float)0.0f, (float)0.28f, (float)0.0f);
        GL11.glScalef((float)renderScale, (float)renderScale, (float)renderScale);
        this.dummyEntityItem.func_92058_a(stack);
        this.customRenderItem.func_76986_a(this.dummyEntityItem, 0.0, 0.0, 0.0, 0.0f, 0.0f);
        GL11.glPopMatrix();
    }

    private void doRenderWearable(EntityRobot entity, TextureManager textureManager, ItemStack wearable) {
        if (wearable.func_77973_b() instanceof IRobotOverlayItem) {
            ((IRobotOverlayItem)wearable.func_77973_b()).renderRobotOverlay(wearable, textureManager);
        } else if (wearable.func_77973_b() instanceof ItemArmor) {
            GL11.glPushMatrix();
            GL11.glScalef((float)1.0125f, (float)1.0125f, (float)1.0125f);
            GL11.glTranslatef((float)0.0f, (float)-0.25f, (float)0.0f);
            GL11.glRotatef((float)180.0f, (float)0.0f, (float)0.0f, (float)1.0f);
            int color = wearable.func_77973_b().func_82790_a(wearable, 0);
            if (color != 0xFFFFFF) {
                GL11.glPushAttrib((int)16384);
                GL11.glColor3ub((byte)((byte)(color >> 16)), (byte)((byte)(color >> 8 & 0xFF)), (byte)((byte)(color & 0xFF)));
            }
            textureManager.func_110577_a(this.armorRenderer.getArmorResource((Entity)entity, wearable, 0, null));
            ModelBiped armorModel = ForgeHooksClient.getArmorModel((EntityLivingBase)entity, (ItemStack)wearable, (int)0, null);
            if (armorModel != null) {
                armorModel.func_78088_a((Entity)entity, 0.0f, 0.0f, 0.0f, -90.0f, 0.0f, 0.0625f);
                if (color != 0xFFFFFF) {
                    GL11.glPopAttrib();
                }
            } else {
                GL11.glRotatef((float)-90.0f, (float)0.0f, (float)1.0f, (float)0.0f);
                this.helmetBox.func_78785_a(0.0625f);
                if (color != 0xFFFFFF) {
                    String armorTexture = ForgeHooksClient.getArmorTexture((Entity)entity, (ItemStack)wearable, (String)"", (int)0, (String)"overlay");
                    if (!StringUtils.func_151246_b((String)armorTexture)) {
                        this.func_110776_a(new ResourceLocation(armorTexture));
                        this.helmetBox.func_78785_a(0.0625f);
                    }
                    GL11.glPopAttrib();
                }
            }
            GL11.glPopMatrix();
        } else if (wearable.func_77973_b() instanceof ItemSkull) {
            this.doRenderSkull(wearable);
        }
    }

    private void doRenderSkull(ItemStack wearable) {
        NBTTagCompound nbt;
        GL11.glPushMatrix();
        GL11.glScalef((float)1.0125f, (float)1.0125f, (float)1.0125f);
        GameProfile gameProfile = null;
        if (wearable.func_77942_o() && !(nbt = wearable.func_77978_p()).func_74764_b("Name") && nbt.func_150297_b("SkullOwner", 10)) {
            gameProfile = NBTUtil.func_152459_a((NBTTagCompound)nbt.func_74775_l("SkullOwner"));
            nbt.func_74778_a("Name", gameProfile.getName());
        }
        TileEntitySkullRenderer.field_147536_b.func_180543_a(-0.5f, -0.25f, -0.5f, EnumFacing.values()[wearable.func_77952_i() & 7], -90.0f, 1, gameProfile, 0);
        if (gameProfile != null) {
            GL11.glTranslatef((float)0.0f, (float)-0.25f, (float)0.0f);
            GL11.glRotatef((float)180.0f, (float)0.0f, (float)0.0f, (float)1.0f);
            GL11.glRotatef((float)-90.0f, (float)0.0f, (float)1.0f, (float)0.0f);
            this.skullOverlayBox.func_78785_a(0.0625f);
        }
        GL11.glPopMatrix();
    }

    private void doRenderRobot(float factor, TextureManager texManager, float storagePercent, boolean isAsleep) {
        boolean glasses = RenderRobot.isWearingGlasses();
        if (glasses) {
            GlStateManager.func_179124_c((float)(1.0f - storagePercent), (float)storagePercent, (float)0.0f);
            GL11.glDepthRange((double)0.0, (double)0.001);
            OpenGlHelper.func_77475_a((int)OpenGlHelper.field_77476_b, (float)240.0f, (float)240.0f);
        }
        this.box.func_78785_a(factor);
        if (glasses) {
            GlStateManager.func_179124_c((float)1.0f, (float)1.0f, (float)1.0f);
            GL11.glDepthRange((double)0.0, (double)1.0);
        }
        if (!isAsleep && !glasses) {
            float lastBrightnessX = OpenGlHelper.lastBrightnessX;
            float lastBrightnessY = OpenGlHelper.lastBrightnessY;
            GL11.glPushMatrix();
            GL11.glEnable((int)3042);
            GL11.glEnable((int)3008);
            GL11.glDisable((int)2896);
            GL11.glBlendFunc((int)770, (int)771);
            OpenGlHelper.func_77475_a((int)OpenGlHelper.field_77476_b, (float)240.0f, (float)240.0f);
            GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)storagePercent);
            texManager.func_110577_a(overlay_red);
            this.box.func_78785_a(factor);
            GL11.glDisable((int)3042);
            GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            texManager.func_110577_a(overlay_cyan);
            this.box.func_78785_a(factor);
            GL11.glEnable((int)2896);
            GL11.glPopMatrix();
            OpenGlHelper.func_77475_a((int)OpenGlHelper.field_77476_b, (float)lastBrightnessX, (float)lastBrightnessY);
        }
    }

    private float interpolateRotation(float prevRot, float rot, float partialTicks) {
        float angle;
        for (angle = rot - prevRot; angle < -180.0f; angle += 360.0f) {
        }
        while (angle >= 180.0f) {
            angle -= 360.0f;
        }
        return prevRot + partialTicks * angle;
    }
}

