/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.robotics.boards;

import buildcraft.api.boards.RedstoneBoardRobotNBT;
import buildcraft.api.core.BuildCraftAPI;
import buildcraft.api.robots.AIRobot;
import buildcraft.api.robots.EntityRobotBase;
import buildcraft.robotics.ai.AIRobotHarvest;
import buildcraft.robotics.boards.BCBoardNBT;
import buildcraft.robotics.boards.BoardRobotGenericSearchBlock;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.BlockPos;
import net.minecraft.world.World;

public class BoardRobotHarvester
extends BoardRobotGenericSearchBlock {
    public BoardRobotHarvester(EntityRobotBase iRobot) {
        super(iRobot);
    }

    public BoardRobotHarvester(EntityRobotBase iRobot, NBTTagCompound nbt) {
        super(iRobot);
    }

    @Override
    public RedstoneBoardRobotNBT getNBTHandler() {
        return BCBoardNBT.REGISTRY.get("harvester");
    }

    @Override
    public boolean isExpectedBlock(World world, BlockPos pos) {
        return BuildCraftAPI.getWorldProperty("harvestable").get(world, pos);
    }

    @Override
    public void update() {
        if (this.blockFound() != null) {
            this.startDelegateAI(new AIRobotHarvest(this.robot, this.blockFound()));
        } else {
            super.update();
        }
    }

    @Override
    public void delegateAIEnded(AIRobot ai) {
        if (ai instanceof AIRobotHarvest) {
            this.releaseBlockFound(ai.success());
        }
        super.delegateAIEnded(ai);
    }
}

