/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.robotics.boards;

import buildcraft.api.boards.RedstoneBoardRobot;
import buildcraft.api.boards.RedstoneBoardRobotNBT;
import buildcraft.api.core.BuildCraftAPI;
import buildcraft.api.core.IStackFilter;
import buildcraft.api.core.IWorldProperty;
import buildcraft.api.robots.AIRobot;
import buildcraft.api.robots.EntityRobotBase;
import buildcraft.api.robots.ResourceIdBlock;
import buildcraft.core.lib.utils.IBlockFilter;
import buildcraft.core.lib.utils.NBTUtils;
import buildcraft.robotics.ai.AIRobotFetchAndEquipItemStack;
import buildcraft.robotics.ai.AIRobotGotoSleep;
import buildcraft.robotics.ai.AIRobotSearchAndGotoBlock;
import buildcraft.robotics.ai.AIRobotUseToolOnBlock;
import buildcraft.robotics.boards.BCBoardNBT;
import net.minecraft.item.ItemHoe;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.BlockPos;
import net.minecraft.world.World;

public class BoardRobotFarmer
extends RedstoneBoardRobot {
    private BlockPos blockFound;

    public BoardRobotFarmer(EntityRobotBase iRobot) {
        super(iRobot);
    }

    @Override
    public RedstoneBoardRobotNBT getNBTHandler() {
        return BCBoardNBT.REGISTRY.get("farmer");
    }

    @Override
    public void update() {
        final IWorldProperty isDirt = BuildCraftAPI.getWorldProperty("dirt");
        if (this.robot.func_70694_bm() == null) {
            this.startDelegateAI(new AIRobotFetchAndEquipItemStack(this.robot, new IStackFilter(){

                @Override
                public boolean matches(ItemStack stack) {
                    return stack != null && stack.func_77973_b() instanceof ItemHoe;
                }
            }));
        } else {
            this.startDelegateAI(new AIRobotSearchAndGotoBlock(this.robot, false, new IBlockFilter(){

                @Override
                public boolean matches(World world, BlockPos pos) {
                    return isDirt.get(world, pos) && !BoardRobotFarmer.this.robot.getRegistry().isTaken(new ResourceIdBlock(pos)) && BoardRobotFarmer.this.isAirAbove(world, pos);
                }
            }));
        }
    }

    @Override
    public void delegateAIEnded(AIRobot ai) {
        if (ai instanceof AIRobotSearchAndGotoBlock) {
            if (ai.success()) {
                this.blockFound = ((AIRobotSearchAndGotoBlock)ai).getBlockFound();
                this.startDelegateAI(new AIRobotUseToolOnBlock(this.robot, this.blockFound));
            } else {
                this.startDelegateAI(new AIRobotGotoSleep(this.robot));
            }
        } else if (ai instanceof AIRobotFetchAndEquipItemStack) {
            if (!ai.success()) {
                this.startDelegateAI(new AIRobotGotoSleep(this.robot));
            }
        } else if (ai instanceof AIRobotUseToolOnBlock) {
            this.releaseBlockFound();
        }
    }

    private void releaseBlockFound() {
        if (this.blockFound != null) {
            this.robot.getRegistry().release(new ResourceIdBlock(this.blockFound));
            this.blockFound = null;
        }
    }

    @Override
    public void end() {
        this.releaseBlockFound();
    }

    @Override
    public void writeSelfToNBT(NBTTagCompound nbt) {
        super.writeSelfToNBT(nbt);
        if (this.blockFound != null) {
            nbt.func_74782_a("blockFound", NBTUtils.writeBlockPos(this.blockFound));
        }
    }

    @Override
    public void loadSelfFromNBT(NBTTagCompound nbt) {
        super.loadSelfFromNBT(nbt);
        if (nbt.func_74764_b("blockFound")) {
            this.blockFound = NBTUtils.readBlockPos(nbt.func_74781_a("blockFound"));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean isAirAbove(World world, BlockPos pos) {
        World world2 = world;
        synchronized (world2) {
            return world.func_175623_d(pos.func_177984_a());
        }
    }
}

