/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.robotics.boards;

import buildcraft.api.boards.RedstoneBoardRobot;
import buildcraft.api.boards.RedstoneBoardRobotNBT;
import buildcraft.api.core.IStackFilter;
import buildcraft.api.robots.AIRobot;
import buildcraft.api.robots.EntityRobotBase;
import buildcraft.core.lib.inventory.StackHelper;
import buildcraft.robotics.StackRequest;
import buildcraft.robotics.ai.AIRobotDeliverRequested;
import buildcraft.robotics.ai.AIRobotDisposeItems;
import buildcraft.robotics.ai.AIRobotGotoSleep;
import buildcraft.robotics.ai.AIRobotGotoStationAndLoad;
import buildcraft.robotics.ai.AIRobotSearchStackRequest;
import buildcraft.robotics.boards.BCBoardNBT;
import buildcraft.robotics.statements.ActionRobotFilter;
import java.util.ArrayList;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;

public class BoardRobotDelivery
extends RedstoneBoardRobot {
    private ArrayList<ItemStack> deliveryBlacklist = new ArrayList();
    private StackRequest currentRequest = null;

    public BoardRobotDelivery(EntityRobotBase iRobot) {
        super(iRobot);
    }

    @Override
    public RedstoneBoardRobotNBT getNBTHandler() {
        return BCBoardNBT.REGISTRY.get("delivery");
    }

    @Override
    public void update() {
        if (this.robot.containsItems()) {
            this.startDelegateAI(new AIRobotDisposeItems(this.robot));
            return;
        }
        if (this.currentRequest == null) {
            this.startDelegateAI(new AIRobotSearchStackRequest(this.robot, ActionRobotFilter.getGateFilter(this.robot.getLinkedStation()), this.deliveryBlacklist));
        } else {
            this.startDelegateAI(new AIRobotGotoStationAndLoad(this.robot, new IStackFilter(){

                @Override
                public boolean matches(ItemStack stack) {
                    return BoardRobotDelivery.this.currentRequest != null && StackHelper.isMatchingItemOrList(stack, BoardRobotDelivery.this.currentRequest.getStack());
                }
            }, this.currentRequest.getStack().field_77994_a));
        }
    }

    @Override
    public void delegateAIEnded(AIRobot ai) {
        if (ai instanceof AIRobotSearchStackRequest) {
            if (!ai.success()) {
                this.deliveryBlacklist.clear();
                this.startDelegateAI(new AIRobotGotoSleep(this.robot));
            } else {
                this.currentRequest = ((AIRobotSearchStackRequest)ai).request;
                if (!this.currentRequest.getStation(this.robot.field_70170_p).take(this.robot)) {
                    this.releaseCurrentRequest();
                }
            }
        } else if (ai instanceof AIRobotGotoStationAndLoad) {
            if (!ai.success()) {
                this.deliveryBlacklist.add(this.currentRequest.getStack());
                this.releaseCurrentRequest();
            } else {
                this.startDelegateAI(new AIRobotDeliverRequested(this.robot, this.currentRequest));
            }
        } else if (ai instanceof AIRobotDeliverRequested) {
            this.releaseCurrentRequest();
        }
    }

    private void releaseCurrentRequest() {
        if (this.currentRequest != null) {
            this.robot.getRegistry().release(this.currentRequest.getResourceId(this.robot.field_70170_p));
            this.currentRequest.getStation(this.robot.field_70170_p).release(this.robot);
            this.currentRequest = null;
        }
    }

    @Override
    public boolean canLoadFromNBT() {
        return true;
    }

    @Override
    public void writeSelfToNBT(NBTTagCompound nbt) {
        super.writeSelfToNBT(nbt);
        if (this.currentRequest != null) {
            NBTTagCompound requestNBT = new NBTTagCompound();
            this.currentRequest.writeToNBT(requestNBT);
            nbt.func_74782_a("currentRequest", (NBTBase)requestNBT);
        }
    }

    @Override
    public void loadSelfFromNBT(NBTTagCompound nbt) {
        super.loadSelfFromNBT(nbt);
        if (nbt.func_74764_b("currentRequest")) {
            this.currentRequest = StackRequest.loadFromNBT(nbt.func_74775_l("currentRequest"));
        }
    }
}

