/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.robotics.boards;

import buildcraft.api.boards.RedstoneBoardRobot;
import buildcraft.api.boards.RedstoneBoardRobotNBT;
import buildcraft.api.core.IStackFilter;
import buildcraft.api.robots.AIRobot;
import buildcraft.api.robots.EntityRobotBase;
import buildcraft.core.lib.inventory.ITransactor;
import buildcraft.core.lib.inventory.Transactor;
import buildcraft.core.lib.inventory.filters.ArrayStackFilter;
import buildcraft.core.lib.utils.IBlockFilter;
import buildcraft.robotics.ai.AIRobotGotoBlock;
import buildcraft.robotics.ai.AIRobotGotoSleep;
import buildcraft.robotics.ai.AIRobotGotoStationAndLoad;
import buildcraft.robotics.ai.AIRobotSearchRandomGroundBlock;
import buildcraft.robotics.boards.BCBoardNBT;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityTNTPrimed;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.util.BlockPos;
import net.minecraft.world.World;

public class BoardRobotBomber
extends RedstoneBoardRobot {
    private static final IStackFilter TNT_FILTER = new ArrayStackFilter(new ItemStack(Blocks.field_150335_W));
    private int flyingHeight = 20;

    public BoardRobotBomber(EntityRobotBase iRobot) {
        super(iRobot);
    }

    @Override
    public RedstoneBoardRobotNBT getNBTHandler() {
        return BCBoardNBT.REGISTRY.get("bomber");
    }

    @Override
    public final void update() {
        boolean containItems = false;
        for (int i = 0; i < this.robot.func_70302_i_(); ++i) {
            if (this.robot.func_70301_a(i) == null) continue;
            containItems = true;
        }
        if (!containItems) {
            this.startDelegateAI(new AIRobotGotoStationAndLoad(this.robot, TNT_FILTER, -1));
        } else {
            this.startDelegateAI(new AIRobotSearchRandomGroundBlock(this.robot, 100, new IBlockFilter(){

                @Override
                public boolean matches(World world, BlockPos pos) {
                    return pos.func_177956_o() < world.func_72940_L() - BoardRobotBomber.this.flyingHeight && !world.func_175623_d(pos);
                }
            }, this.robot.getZoneToWork()));
        }
    }

    @Override
    public void delegateAIEnded(AIRobot ai) {
        if (ai instanceof AIRobotGotoStationAndLoad) {
            if (!ai.success()) {
                this.startDelegateAI(new AIRobotGotoSleep(this.robot));
            }
        } else if (ai instanceof AIRobotSearchRandomGroundBlock) {
            if (ai.success()) {
                AIRobotSearchRandomGroundBlock aiFind = (AIRobotSearchRandomGroundBlock)ai;
                this.startDelegateAI(new AIRobotGotoBlock(this.robot, aiFind.blockFound.func_177982_a(0, this.flyingHeight, 0)));
            } else {
                this.startDelegateAI(new AIRobotGotoSleep(this.robot));
            }
        } else if (ai instanceof AIRobotGotoBlock) {
            if (ai.success()) {
                ITransactor t = Transactor.getTransactorFor((Object)this.robot, null);
                ItemStack stack = t.remove(TNT_FILTER, true);
                if (stack != null && stack.field_77994_a > 0) {
                    EntityTNTPrimed tnt = new EntityTNTPrimed(this.robot.field_70170_p, this.robot.field_70165_t + 0.25, this.robot.field_70163_u - 1.0, this.robot.field_70161_v + 0.25, (EntityLivingBase)this.robot);
                    tnt.field_70516_a = 37;
                    this.robot.field_70170_p.func_72838_d((Entity)tnt);
                    this.robot.field_70170_p.func_72956_a((Entity)tnt, "game.tnt.primed", 1.0f, 1.0f);
                }
            } else {
                this.startDelegateAI(new AIRobotGotoSleep(this.robot));
            }
        }
    }
}

