/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.robotics.ai;

import buildcraft.api.core.IZone;
import buildcraft.api.robots.AIRobot;
import buildcraft.api.robots.EntityRobotBase;
import buildcraft.core.lib.utils.IBlockFilter;
import net.minecraft.util.BlockPos;
import net.minecraft.util.MathHelper;
import net.minecraft.util.Vec3i;

public class AIRobotSearchRandomGroundBlock
extends AIRobot {
    private static final int MAX_ATTEMPTS = 4096;
    public BlockPos blockFound;
    private int range;
    private IBlockFilter filter;
    private IZone zone;
    private int attempts = 0;

    public AIRobotSearchRandomGroundBlock(EntityRobotBase iRobot) {
        super(iRobot);
    }

    public AIRobotSearchRandomGroundBlock(EntityRobotBase iRobot, int iRange, IBlockFilter iFilter, IZone iZone) {
        this(iRobot);
        this.range = iRange;
        this.filter = iFilter;
        this.zone = iZone;
    }

    @Override
    public void update() {
        int z;
        int x;
        if (this.filter == null) {
            this.terminate();
        }
        ++this.attempts;
        if (this.attempts > 4096) {
            this.terminate();
        }
        if (this.zone == null) {
            double r = this.robot.field_70170_p.field_73012_v.nextFloat() * (float)this.range;
            float a = this.robot.field_70170_p.field_73012_v.nextFloat() * 2.0f * (float)Math.PI;
            x = (int)((double)MathHelper.func_76134_b((float)a) * r + Math.floor(this.robot.field_70165_t));
            z = (int)((double)MathHelper.func_76126_a((float)a) * r + Math.floor(this.robot.field_70161_v));
        } else {
            BlockPos b = this.zone.getRandomBlockPos(this.robot.field_70170_p.field_73012_v);
            x = b.func_177958_n();
            z = b.func_177952_p();
        }
        BlockPos pos = new BlockPos(x, this.robot.field_70170_p.func_72800_K(), z);
        while (pos.func_177956_o() >= 0) {
            if (this.filter.matches(this.robot.field_70170_p, pos)) {
                this.blockFound = new BlockPos((Vec3i)pos);
                this.terminate();
                return;
            }
            if (!this.robot.field_70170_p.func_175623_d(pos)) {
                return;
            }
            pos = pos.func_177977_b();
        }
    }

    @Override
    public boolean success() {
        return this.blockFound != null;
    }

    @Override
    public int getEnergyCost() {
        return 2;
    }
}

